/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-ui-elementlist.h"

#include "glrr-gobject.h"


void
g_inspector_panel_attach_element_list (GInspectorPanel       *panel,
				       GInspectorElementList *element_list)
{
  g_return_if_fail (panel != NULL);
  g_return_if_fail (element_list != NULL);
  g_return_if_fail (G_IS_INSPECTOR_PANEL (panel));
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_LIST (element_list));


  g_signal_connect_swapped (panel,
			    "update",
			    G_CALLBACK (g_inspector_element_list_update),
			    element_list);
}



static void
object_weak_ref_notify (gpointer  data,
                        GObject  *where_the_object_was)
{
  GObject *object;
  GtkListStore *list_store;
  GtkTreeIter tree_iter;
  gboolean r;

  object = where_the_object_was;
  list_store = GTK_LIST_STORE (data);

  r = g_inspector_element_list_get_iter (list_store,
                                         &tree_iter,
                                         G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
                                         object);
  if (r == TRUE)
    {
      gtk_list_store_remove (list_store,
                             &tree_iter);
    }
}

void
g_inspector_element_list_set_row_element_gobject (GtkListStore *list_store,
						  GtkTreeIter  *tree_iter,
						  GObject      *object)
{
  g_return_if_fail (list_store != NULL);
  g_return_if_fail (tree_iter != NULL);
  g_return_if_fail (object != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (list_store));
  g_return_if_fail (G_IS_OBJECT (object));


  g_inspector_element_list_set_row_element (list_store, tree_iter,
                                            G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
                                            object);

  g_object_weak_xref (object,                object_weak_ref_notify,
		      G_OBJECT (list_store), NULL);
}
