/*  Copyright (C) 2002 yvind Hagen */

/*  This file is part of gkleds. */

/*  gkleds is free software; you can redistribute it and/or modify */
/*  it under the terms of the GNU General Public License Version 2 as */ 
/*  published by the Free Software Foundation */

/*  gkleds is distributed in the hope that it will be useful, */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the */
/*  GNU General Public License for more details.  */

/*  You should have received a copy of the GNU General Public License */
/*  along with gkleds; if not, write to the Free Software */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */


#define GKLEDS_PLACEMENT (MON_UPTIME | GRAVITY(3))
#define	GKLEDS_NAME "gkleds"
#define GKLEDS_VERSION "0.8.0"
#define GKLEDS_CONFIG "gkleds_plugin"

/*  #define NUM 0 */
/*  #define CAPS 1 */
/*  #define SCROLL 2 */
#define GKLEDS_NUM_IND 3
#define GKLEDS_NUM_IMG 12
#define GKLEDS_CONF_LENGTH 64

struct struct_gkleds_user_conf{
  int margin[4]; /* margin adjustment: left, right, top, bottom*/
  int size[2]; /* image size: width, height */
  /* NUM, CAPS, SCROLL: bg_off, fg_off, bg_on, fg_on - -1 is none*/
  int pm_idx[GKLEDS_NUM_IND*4];  
  int order[GKLEDS_NUM_IND]; /* NUM, CAPS, SCROLL: 1, 2, 3 - 0 is off */
  int mb_panel; /* mb click -> indicator state (-1 - none, 0 - all, 1-5 )*/
  int num_img; /* number of subimages in led_img, set in gkrellmrc/NUM_IMG */
};
typedef struct struct_gkleds_user_conf gkleds_user_conf;

struct struct_gkleds_indicator_conf{
  int w; /* actual width and height of leds */
  int h;
  int y; /* leds y position in panel == user_conf.margin[2](top) */
  int led_x[GKLEDS_NUM_IND]; /* actual leds x position in panel */
  Display *dpy; /* the display */
  KeyCode keys[GKLEDS_NUM_IND]; /* NUM, CAPS, SCROLL: keycode of the lock keys */
  int masks[GKLEDS_NUM_IND]; /* NUM, CAPS, SCROLL: indicator mask, for XKB*/
  int idx[GKLEDS_NUM_IND];/* NUM, CAPS, SCROLL: indicator index, for XKB */
};
typedef struct struct_gkleds_indicator_conf gkleds_indicator_conf;

/* plugin functions */
extern GkrellmMonitor *gkrellm_init_plugin(void);
static void create_plugin(GtkWidget *vbox, gint first_create);
static void create_plugin_config(GtkWidget *conf_vbox);
static void apply_plugin_config(void);
static void save_plugin_config(FILE *f);
static void load_plugin_config(gchar *arg);
static void get_indicators(void); /* update_plugin */
/* configuration callbacks */
static void spin_misc_changed(GtkWidget *spin, gpointer data);
static void spin_order_changed(GtkWidget *spin, gpointer data);
static void combo_mb_panel_changed(GtkWidget *mc_entry, gpointer data);
static void pm_idx_altered(GtkWidget *widget, gpointer data);
/* misc */
static gint panel_expose_event(GtkWidget *widget, GdkEventExpose *ev);
static inline void copy_config(gkleds_user_conf *from, gkleds_user_conf *to);
static void set_indicators(GtkWidget *widget, GdkEventButton *ev);
static void configure_indicators(gkleds_indicator_conf *ind);
