/* test the top_three functionality
 * will print in the cmdline every second a list of
 * three best processes 
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <dirent.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <math.h>
#include <limits.h>
#include <errno.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <regex.h>
#include "gkrelltop.h"

int gkrelltop_process_find_top_three (struct process **);
int show_nice_processes;

struct process *best[3] = { 0, 0, 0 };

int main ()
{
  int n=0, i;
  char str [256];

  show_nice_processes=1;
  printf("start of the program, show_nice_processes=%d (%p)\n", show_nice_processes, &show_nice_processes);

  while (1) { //sorry
    for (i = 0; i < n; i++) {
        best[i]=0;
    }
    /*
     * Find the top three!
     */
    n = gkrelltop_process_find_top_three (best);

    if (n > 3) {
        /* cant have more than 3, some error occured */
        return 0;
    }

    if(n>0) {
        printf("N(%d): ", n);
        for (i = 0; i < n; i++) {
            snprintf(str, sizeof(str), "%d - %-10.10s(%c %.2f %5d)", i+1, best[i]->name,'%',best[i]->amount,best[i]->pid);
            printf("%s\t",str);
        }
        for(; i < 3; i++) 
          if (best[i]) {
            snprintf(str, sizeof(str), "%d - %-10.10s(%c %.2f %5d)", i+1, best[i]->name,'%',best[i]->amount,best[i]->pid);
            printf("%s\t",str);
          }
        printf("\n"); //15 CR, 12 linefeed
    }
    usleep(500000); /* microsleep in microseeconds */
  }
  return 0;
}
