// $Id: gnome_app.cc,v 1.14 2002/11/18 11:46:09 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999 Rick L. Vinyard, Jr.
 *  Copyright (C) 2000-2002 Adolf Petig GmbH & Co. KG (by Christof Petig)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome_app.hh"

static Gnome_App Gnome_App(false);

const std::string Gnome_App::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"App";
}

const std::string Gnome_App::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"app.h";
}

Gnome_App::Gnome_App(bool base_class_init)
{  if (!base_class_init) Writer["GnomeApp"]=this;
}

void Gnome_App::ConstructionArgs(const Widget &w, CxxFile &f) const
{
  f.FunctionArg() << Configuration.CString_WithQuotes(Configuration.InstanceName(w.Name()));
  f.FunctionArg() << Configuration.Translatable(w.getProperty("label"));
}

bool Gnome_App::NeedExplicitCtor(const Widget &w) const
{  return true;
}

void Gnome_App::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
}

void Gnome_App::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  if (w.begin()==w.end()) return;

   Widget::const_iterator i=w.begin();
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  Widget ch(*i);
      if (GNOME2) {
	 // FIXME: Required actions may be different for GNOME2
	 if (ch.ChildName()=="dock")
	    ; // ignore
	 else if (ch.ChildName()=="appbar")
	    f.Statement() << instance << "set_statusbar(" << Reference(ch) << ")";
	 else
	    std::cerr << "Gnome App: strange child " << ch.Name() << '/' 
		      << ch.ChildName() << '\n';
      }
      else {
	 if (ch.ChildName()=="GnomeApp:dock")
	    ; // ignore
	 else if (ch.ChildName()=="GnomeApp:appbar")
	    f.Statement() << instance << "set_statusbar(" << Reference(ch) << ")";
	 else
	    std::cerr << "Gnome App: strange child " << ch.Name() << '/' 
		      << ch.ChildName() << '\n';
      }
   }
}

// GnomeApp:dock is internal [Gnome::Dock* get_dock()]
// GnomeApp:appbar to be added as set_statusbar

// perhaps distinguish by band and position?
// band0   set_menus(Gtk::MenuBar& menubar)
// band1   set_toolbar(Gtk::Toolbar& toolbar)
// ??? set_statusbar(Gtk::Widget& statusbar);
// ??? set_statusbar_custom(Gtk::Container& container,Gtk::Widget& statusbar);
// <GnomeDock:contents> set_contents(Gtk::Widget& contents);
// ??? enable_layout_config(gboolean enable)

Subwidget Gnome_App::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (GNOME2) {
      if (ch.ChildName()=="dock") return is_Subwidget_only;
      if (ch.ChildName()=="appbar") return not_Subwidget;
   }
   else {
      if (ch.ChildName()=="GnomeApp:dock") return is_Subwidget_only;
      if (ch.ChildName()=="GnomeApp:appbar") return not_Subwidget;
   }
   if (!ch.ChildName().empty()) {  std::cerr << "Child name '" << ch.ChildName() << "'\n"; }
   return not_Subwidget;
}

const std::string Gnome_App::InternalInstance(const Widget &parent,const Widget &w2) const
{  const std::string chn(w2.ChildName());
   if (GNOME2) {
      if (chn=="dock") return "get_dock()->";
   }
   else {
      if (chn=="GnomeApp:dock") return "get_dock()->";
   }
   return Parent::InternalInstance(parent,w2);
}
                   
