// $Id: libglademm.cc,v 1.10 2003/04/01 07:31:25 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "misc.hh"

class LibGlademm : public WriterBase
{public:
	typedef WriterBase Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	LibGlademm();
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual Subwidget IsSubwidget(const Widget &w,const Widget &ch) const
	{  return ch.getBoolProperty(CXX_SEPERATE_CLASS)?not_Subwidget:is_Subwidget; }
	virtual void GHInclude(const Widget &w, CxxFile &f) const;
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual void Configure_show(const Widget &w, CxxFile &f,const std::string &instance) const
	{}
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const
	{}
	virtual bool CantMemberConstruct(const Widget &w) const
	{  return !w.getBoolProperty(CXX_SEPERATE_CLASS); }
	virtual void CreatePointer(const Widget &w, CxxFile &f) const;
	virtual void ClassConstructor(const Widget &w, CxxFile &f) const;
	virtual void ClassDestructor(const Widget &w, CxxFile &f) const;
	virtual void AdditionalMemberVars(const Widget &w,CxxFile &f,bool container) const;
	virtual void Derivation(const Widget &w, CxxFile &f) const;
	virtual bool needDataArg(const Widget &w) const
	{  return false; }
	virtual void DestroyPointer(const Widget &w, CxxFile &f) const;
	virtual void GHDeclaration(const Widget &w, CxxFile &f) const;
	virtual const std::string Instance(const Widget &parent,const Widget &w2,Subwidget sw) const;
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const;
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;

	
private:
	void CreatePointer2(const Widget &w,CxxFile &f) const;
};

static LibGlademm LibGlademm;

void LibGlademm::CreatePointer2(const Widget &w,CxxFile &f) const
{  std::cout << __FUNCTION__ << '(' << w.Name() << ")\n";
   if (w.getProperty("cxx_visibility","private")=="private" && CanBeManaged(w))
     f.Declaration() << TypeName(w) << " *";
   else 
     f.Statement();
   f << Configuration.InstanceName(w.Name());
   f.Assignment();
   f << "Glib::wrap(" << GtkCast(w) <<
   	"(glade_xml_get_widget(gmm_xml,"
   	<< Configuration.CString_WithQuotes(w.Name()) << ")))";
}

void LibGlademm::CreatePointer(const Widget &w,CxxFile &f) const
{  
}

const std::string LibGlademm::TypeName(const Widget &w) const
{  return LookupWriter(w.Class(),false).TypeName(w);
}

const std::string LibGlademm::IncludeName(const Widget &w) const
{  return LookupWriter(w.Class(),false).IncludeName(w);
//   return "glade/glade.h";
}

LibGlademm::LibGlademm()
{  Writer["LibGlademm"]=this;
}

void LibGlademm::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

void LibGlademm::GHInclude(const Widget &w, CxxFile &f) const
{  Parent::GHInclude(w,f);
   if (w.getProperty("cxx_visibility","private")=="private") return;
   // hier bin ich mir gar nicht so sicher ...
   LookupWriter(w.Class(),false)/*w.getBoolProperty(CXX_SEPERATE_CLASS))*/.GHInclude(w,f);
   f.Include("sigc++/object.h");
}

void LibGlademm::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   f.Include("glib-object.h");

   // try to guess Gtk+ include name, this should go into WriterBase
   std::string incname=LookupWriter(w.Class(),false).IncludeName(w);
   if (incname.substr(0,6)=="gtkmm/") 
      incname="gtk/gtk"+incname.substr(6);
   f.Include(incname);
}

void LibGlademm::AdditionalMemberVars(const Widget &w,CxxFile &f,bool container) const
{  if (container)
   {  f.Private();
      f.Declaration("GladeXML *gmm_xml");
   }
   // ignore accel group passing (GlademmData) for now ...
   Parent::AdditionalMemberVars(w,f,container);
}

void LibGlademm::ClassConstructor(const Widget &w, CxxFile &f) const
{  f.Statement("gmm_xml").Assignment().FunctionName("glade_xml_new");
   std::string dir("../");
   if (Configuration.source_directory.empty() || Configuration.source_directory==".") 
      dir="";
   f.FunctionArg(Configuration.CString_WithQuotes(dir+Configuration.in_filename));
   f.FunctionArg(Configuration.CString_WithQuotes(w.Name()));
   f.FunctionArg("NULL");

   // Parent::ClassConstructor(w,f);
   CreatePointer2(w,f);
   std::cout << __FUNCTION__ << '(' << w.Name() << ")\n";
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
			i!=w.end_contained();++i)
   CreatePointer2(*i,f);
}

void LibGlademm::ClassDestructor(const Widget &w, CxxFile &f) const
{  // hmmm how does one do this in C?
   // f.Statement("delete gmm_xml");
   f.Statement("g_object_unref(G_OBJECT(gmm_xml))");
   Parent::ClassDestructor(w,f);
}

void LibGlademm::DestroyPointer(const Widget &w, CxxFile &f) const
{  DestroyPointer_Toplevel(w,f);
   // no delete 
}

void LibGlademm::GHDeclaration(const Widget &w, CxxFile &f) const
{  Parent::GHDeclaration(w,f);
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
			i!=w.end_contained();++i)
      LookupWriter((*i).Class(),false).GHDeclaration(*i,f);
}

const std::string LibGlademm::Instance(const Widget &parent,const Widget &w2,Subwidget sw) const
{  return Configuration.InstanceName(w2.Name())+"->";
}

const std::string LibGlademm::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const
{  return LookupWriter(w.Class(),false).SignalHandlerArgs(w,signal,rettype,scope);
}

bool LibGlademm::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  return LookupWriter(w.Class(),false).isInternalMethod(w,method,args,scope,is_signal);
}

void LibGlademm::Derivation(const Widget &w, CxxFile &f) const
{  f.Derivation() << "public SigC::Object";
}

