// $Id: paned.cc,v 1.33 2003/03/31 14:09:27 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Paned : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Paned();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
private:
	static std::string AttachOptions(bool resize,bool shrink);
};

static Gtk_Paned Gtk_Paned;

const std::string Gtk_Paned::TypeName(const Widget &w) const
{  return GtkPrefix()+(w.Class()[3]=='H' ?"HPaned":"VPaned");
}

const std::string Gtk_Paned::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"paned.h";
}

Gtk_Paned::Gtk_Paned()
{  Writer["GtkHPaned"]=this;
   Writer["GtkVPaned"]=this;
}

void Gtk_Paned::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   if (GTKMM1) WriteIntProperty(w,f,instance, "handle_size");
   if (GTKMM1 && Configuration.gtk_version<Pkg_Version(1,3,0))
      WriteIntProperty(w,f,instance, "gutter_size");
   WriteIntProperty(w,f,instance, "position");
}

std::string Gtk_Paned::AttachOptions(bool resize,bool shrink)
{  std::string attach_options="0";
   if (resize) attach_options+="|Gtk::EXPAND";
   if (shrink) attach_options+="|Gtk::SHRINK";
   if (attach_options!="0") return attach_options.substr(2);
   else return "Gtk::AttachOptions(0)";
}

void Gtk_Paned::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  Widget::const_iterator i=w.begin();
   if (i!=w.end() && (*i).Class()!="Placeholder")
   {  const ChildParamList ch((*i).get_Child_params());
      bool resize(ch.getBoolProperty("resize",false));
      bool shrink(ch.getBoolProperty("shrink",true));
      f.Statement() << instance << "pack1(" << Reference(*i) << ", ";
      if (GTKMM1) f << PRINT_BOOL(resize) << ", " << PRINT_BOOL(shrink);
      else f << AttachOptions(resize,shrink);
      f << ')';
   }
   ++i;
   if (i!=w.end() && (*i).Class()!="Placeholder")
   {  const ChildParamList ch((*i).get_Child_params());
      bool resize(ch.getBoolProperty("resize",true));
      bool shrink(ch.getBoolProperty("shrink",true));
      f.Statement() << instance << "pack2(" << Reference(*i) << ", ";
      if (GTKMM1) f << PRINT_BOOL(resize) << ", " << PRINT_BOOL(shrink);
      else f << AttachOptions(resize,shrink);
      f << ')';
   }
   ++i;
   if (i!=w.end()) 
      std::cerr << "Paned Window " << w.Name() << " has more than 2 children\n";
}
