// $Id: table.cc,v 1.33 2002/12/19 09:01:18 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"
#include "stringtok.h"

class Gtk_Table : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Table();
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_Table Gtk_Table;

const std::string Gtk_Table::TypeName(const Widget &w) const
{  return GtkPrefix()+"Table";
}

const std::string Gtk_Table::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"table.h";
}

Gtk_Table::Gtk_Table()
{  Writer["GtkTable"]=this;
}

void Gtk_Table::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg() << w.getIntProperty("rows",2);
   f.FunctionArg() << w.getIntProperty("columns",2);
   f.FunctionArg() << PRINT_BOOL(w.getBoolProperty("homogeneous",true));
}

std::string getAttachOptions(const ChildParamList& ch, const std::string which)
{  std::string options = "0";

   // glade2 style
   if (ch.hasProperty(which+"_options"))
   {  std::list<std::string> list;

      stringtok(list, ch.getProperty(which+"_options"), "|");
      for (std::list<std::string>::iterator i = list.begin();
           i != list.end();
           ++i)
         if (*i == "fill") options += "|GTK_FILL";
         else if (*i == "expand") options += "|GTK_EXPAND";
         else if (*i == "shrink") options += "|GTK_SHRINK";
   }
   else // glade1 style
   {  if (ch.getBoolProperty(which+"expand",true)) options+="|GTK_EXPAND";
      if (ch.getBoolProperty(which+"shrink",false)) options+="|GTK_SHRINK";
      if (ch.getBoolProperty(which+"fill",true)) options+="|GTK_FILL";
   }

   // strip leading '0|'
   if (options.size()>1)
      options=options.substr(2);
   else
      if (GTKMM2) options="Gtk::AttachOptions()";

   return options;
}

void Gtk_Table::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  const ChildParamList ch=w.get_Child_params();
   int left_attach=ch.getIntProperty("left_attach",-1);
   int right_attach=ch.getIntProperty("right_attach",-1);
   int top_attach=ch.getIntProperty("top_attach",-1);
   int bottom_attach=ch.getIntProperty("bottom_attach",-1);

   std::string xoptions = getAttachOptions(ch, "x");
   std::string yoptions = getAttachOptions(ch, "y");

   int xpad=ch.getIntProperty("xpad",ch.getIntProperty("x_padding",0));
   int ypad=ch.getIntProperty("ypad",ch.getIntProperty("y_padding",0));

   if (xoptions=="GTK_FILL|GTK_EXPAND" 
       && yoptions=="GTK_FILL|GTK_EXPAND" && !xpad && !ypad)
         f.Statement() << instance << "attach(" << Reference(w) << ", "
   	      << left_attach << ", " << right_attach << ", " << top_attach << ", " 
   	      << bottom_attach << ')';
   else
      f.Statement() << instance << "attach(" 
        << Reference(w) << ", " << left_attach << ", " << right_attach 
        << ", " << top_attach << ", " << bottom_attach << ", " 
        << Gtkmm2Namespace(xoptions) << ", " << Gtkmm2Namespace(yoptions)
        << ", " << xpad << ", " << ypad << ')';
}

void Gtk_Table::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteIntProperty(w,f,instance, "row_spacing", false, "row_spacings");
   WriteIntProperty(w,f,instance, "column_spacing", false, "col_spacings");
}

