/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __GTK_TREE_CONTAINER_H__
#define __GTK_TREE_CONTAINER_H__


#include <gtk/gtkcontainer.h>


G_BEGIN_DECLS



#define GTK_TYPE_TREE_CONTAINER			(gtk_tree_container_get_type ())
#define GTK_TREE_CONTAINER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TREE_CONTAINER, GtkTreeContainer))
#define GTK_TREE_CONTAINER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TREE_CONTAINER, GtkTreeContainerClass))
#define GTK_IS_TREE_CONTAINER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TREE_CONTAINER))
#define GTK_IS_TREE_CONTAINER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TREE_CONTAINER))
#define GTK_TREE_CONTAINER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_TREE_CONTAINER, GtkTreeContainerClass))

#define GTK_TREE_CONTAINER_NODE_IS_ROOT(node)     (G_NODE_IS_ROOT ((node)->gnode))
#define GTK_TREE_CONTAINER_NODE_IS_LEAF(node)     (G_NODE_IS_LEAF ((node)->gnode))
#define GTK_TREE_CONTAINER_NODE_IS_EXPANDED(node) ((node)->expanded)



typedef struct _GtkTreeContainer       GtkTreeContainer;
typedef struct _GtkTreeContainerClass  GtkTreeContainerClass;
typedef struct _GtkTreeContainerNode   GtkTreeContainerNode;

typedef enum
{
  GTK_TREE_STYLE_STEPWISE,
  GTK_TREE_STYLE_SPRAY,
} GtkTreeStyle;

struct _GtkTreeContainer
{
  GtkContainer  container;

  GtkTreeStyle  tree_style;
  guint         indent;
  gfloat        align;

  guint         depth_align : 1;

  guint         tree_pad;
  guint         node_pad;

  GList        *root_nodes;

  GHashTable   *node_ht;
};

struct _GtkTreeContainerClass
{
  GtkContainerClass parent_class;
};

struct _GtkTreeContainerNode
{
  GNode *gnode;

  GtkWidget *widget;

  GtkRequisition node_requisition;
  GtkRequisition children_requisition;
  GtkRequisition descendants_requisition;
  guint          children_requisition_is_valid    : 1;
  guint          descendants_requisition_is_valid : 1;

  guint resized  : 1;
  guint expanded : 1;
};


GType      gtk_tree_container_get_type (void) G_GNUC_CONST;

GtkWidget* gtk_tree_container_new                    (void);
void       gtk_tree_container_set_style              (GtkTreeContainer *tree_container,
						      GtkTreeStyle      tree_style);
void       gtk_tree_container_set_indent             (GtkTreeContainer *tree_container,
						      guint             indent);
void       gtk_tree_container_set_align              (GtkTreeContainer *tree_container,
						      gfloat            align);
void       gtk_tree_container_set_depth_align        (GtkTreeContainer *tree_container,
						      gboolean          depth_align);
void       gtk_tree_container_set_tree_pad           (GtkTreeContainer *tree_container,
						      guint             tree_pad);
void       gtk_tree_container_set_node_pad           (GtkTreeContainer *tree_container,
						      guint             node_pad);

void       gtk_tree_container_append_node_widget     (GtkTreeContainer *tree_container,
						      GtkWidget        *widget,
						      GtkWidget        *parent);
void       gtk_tree_container_remove_node_widget     (GtkTreeContainer *tree_container,
						      GtkWidget        *widget);

GtkWidget* gtk_tree_container_get_node_widget_at_pos (GtkTreeContainer *tree_container,
						      gint              x,
						      gint              y);



G_END_DECLS


#endif /* __GTK_TREE_CONTAINER_H__ */
