/*
  gmorgan - a ryhthm station software

  main.c  -  Main file of the organ
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#include <locale.h>
#include <getopt.h>
#include <sched.h>
#include <unistd.h>
#include <sys/mman.h>
#include "GMorgan.h"
#include "GMORGAN.h"



GMO gmo;
SPLASH splh;

void pon_realtime()

{
    sched_param scprior;

    scprior.sched_priority=50;
    int prior=sched_setscheduler(0,SCHED_FIFO,&scprior);
    if (prior==0) printf("SCHED_FIFO\n");

};




int main(int argc, char *argv[])

{

  setlocale(LC_ALL, "");
  bindtextdomain("gmorgan", LOCALEDIR);
  textdomain("gmorgan");


  fprintf (stderr,
	   gettext("gmorgan v0.25 - Copyright (c) 2003-2004 Josep Andreu (Holborn)\n"));
  if (argc == 1)
    fprintf (stderr, gettext("Try 'gmorgan --help' for command-line options.\n"));


  struct option opts[] = {
    {"drump",2,NULL, 'd'}, 
    {"preset", 2,NULL, 'p'},
    {"load", 1, NULL, 'l'},
    {"bank", 1, NULL, 'b'},
    {"rhyt", 1, NULL, 'r'},
    {"help", 0, NULL, 'h'},
    {0, 0, 0, 0}
  };

  
  Pexitprogram = 0;



   opterr = 0;
  int option_index = 0, opt, exitwithhelp = 0;
  while (1)
    {
      opt = getopt_long (argc, argv, "d:p:l:b:r:h", opts, &option_index);
      char *optarguments = optarg;
      
      if (opt == -1)
	break;


      switch (opt)
	{
	case 'h':
	  exitwithhelp = 1;
	  break;
        case 'd':
           if (optarguments != NULL)
           {
              gmo.loaddrumset(optarguments);
              break; 
           }

        case 'p':
          if (optarguments != NULL)
           {
              gmo.loadpreset(optarguments);
              break; 
           }                                 
	case 'l':
	  if (optarguments != NULL)
	    {
              gmo.prime=1;
              gmo.ulti=100;
              gmo.loadstyl(optarguments);
	      break;
	    }
        case 'r' :
            if (optarguments != NULL)
            {
              gmo.prime=1;
              gmo.ulti=500;
              gmo.loadpatt (optarguments);
              break;
            }

	case 'b':
	  if (optarguments != NULL)
	    {
              gmo.prime=1;
              gmo.ulti=100;
	      gmo.loadfile(optarguments);
              break;
	    }


	};
    };

  if (exitwithhelp != 0)
    {
      fprintf (stderr, gettext("Usage: gmorgan [OPTION]\n\n"));
      fprintf (stderr, gettext("  -h       --help \t\t\t display command-line help and exit\n"));
      fprintf (stderr, gettext("  -d File, --drump=File \t\t loads the drum map file list\n"));
      fprintf (stderr, gettext("  -p File, --preset=File \t\t loads the preset file list\n"));
      fprintf (stderr, gettext("  -l File, --load=File \t\t\t loads the Styles\n"));
      fprintf (stderr, gettext("  -b File, --bank=File \t\t\t loads the Sound Bank\n"));
      fprintf (stderr, gettext("  -r File, --rhyt=File \t\t\t loads the Patterns\n"));

      fprintf (stderr, "\n\n");
      return (0);
    };




  SPLASH   *splhUI = new SPLASH();
  splhUI->splashwin->show();
  GMORGAN *gmoUI = new GMORGAN(&gmo);


mlockall(MCL_CURRENT | MCL_FUTURE);
pon_realtime();

  while (Pexitprogram == 0)
    {  

      Fl::wait();
      gmo.miramidi();
      gmo.organo();
      if (gmo.reproduccion) gmo.EPlay();

  
     if (splash == 1) 
     {
            splashcounter++;
     
            if ((clicksplash == 1 ) || (splashcounter > 2500)) 
                {
                  splhUI->splashwin->hide();
                  gmoUI->gmorganwin->show();
                  splhUI->splashwin->clear();
                  splash = 0;
                  Fl::focus(gmoUI->StartStop);
                  delete splhUI;
                }
     }

 


 if (vumvum != vum) gmoUI->VUI1->value(vum);
      



  if ((gmo.stst) && (ulcount != count))
     {
      ulcount = count;
      switch(count)
      {
         case 1:
                gmoUI->N1->setonly();
                gmoUI->DispBlack->label(gmo.elbart);
                if (gmo.bplay == 1)
                 {
                 gmoUI->BDispBlack->label(gmo.elbart);
                 gmoUI->Dispnb->label(gmo.elnb);
                 gmoUI->LaBarra->value(gmo.nb);
                 }
                if (gmo.BPW) gmoUI->BPN1->setonly();
                 break;
         case 2:
                gmoUI->N2->setonly();
                if (gmo.BPW) gmoUI->BPN2->setonly();
                break;
         case 3:  
                gmoUI->N3->setonly();
                if (gmo.BPW) gmoUI->BPN3->setonly();
                break;
         case 4:
                gmoUI->N4->setonly();
                if (gmo.BPW) gmoUI->BPN4->setonly();       
                break;
       }
      }

      if (actunex == 1)
       {
       gmoUI->ApagaNex();
       actunex = 0;
       }

      if (ponfin ==1)
       {
       gmoUI->ApagaSt();
       gmo.bplay = 0;
       ponfin=0;
       }

      if (cambialo == 1) 
      {
       gmoUI->ACI->label(NombreAcorde);
       if (gmo.KeybON) gmo.GeneraChord();

       cambialo = 0;
      }

      if (programa != 0)
	{ 
      	  gmoUI->PutCombi (programa);
	  programa = 0;
	}

      if (ttnp != 0) gmoUI->prepsig();

      if (cambiapat !=0)
          {
           gmoUI->metemixerpat();
           cambiapat = 0;
          }
   
     if (tocadrum != 0)
  {
     gmo.suenaev(9,tocadrum,127);
     tocadrum = 0;
  }

    if (paraplay) gmoUI->StopPlay();

    if ((gmo.bplay) && (gmo.cambiaacorde))
        {
         gmo.cambiaacorde = 0;
         gmoUI->NomElacorde->value(gmo.Delacorde);
        }

    if (cambiacasdr)
        {
         cambiacasdr = 0;
         gmoUI->PonColores(lastcasdr);
        }

    if (cambiacascr)
        {
         cambiacascr = 0;
         gmoUI->PonColores2(lastcascr);
        }

         
    }

  delete gmoUI;

};

