.TH GRDPASTE l "1 Jan 2004"
.SH NAME
grdpaste \- Paste together two \fI.grd\fP files along a common edge.
.SH SYNOPSIS
\fBgrdpaste\fP \fIfile_a.grd file_b.grd\fP \fB\-G\fP\fIoutfile.grd\fP [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdpaste\fP will combine \fIfile_a.grd\fP and \fIfile_b.grd\fP into \fIoutfile.grd\fP by pasting
them together along their common edge. Files \fIfile_a.grd\fP and \fIfile_b.grd\fP must have the same dx, dy and have one edge
in common. If in doubt, check with \fBgrdinfo\fP and use \fBgrdcut\fP and/or \fBgrdsample\fP
if necessary to prepare the edge joint.
.TP
\fIfile_a.grd\fP
One of two files to be pasted together.
.TP
\fIfile_b.grd\fP
The other of two files to be pasted together.
.TP
\fB\-G\fP\fIoutfile.grd\fP
The name for the combined output.
.SH OPTIONS
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
Suppose file_a.grd is 150E - 180E and 0 - 30N, and file_b.grd is 150E - 180E, -30S - 0, then you can
make outfile.grd which will be 150 - 180 and -30S - 30N by:
.sp
grdpaste file_a.grd file_b.grd \fB\-G\fPoutfile.grd \fB\-V\fP
.SH "SEE ALSO"
.IR gmt (l),
.IR grdcut (l),
.IR grdinfo (l),
.IR grdsample (l)
