.TH GMTCONVERT l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
gmtconvert \- Converts, Pastes, and/or Extracts columns from ASCII and binary 1-D tables
.SH SYNOPSIS
\fBgmtconvert\fP [ \fIinputfiles\fP ] [ \fB\-A\fP ] [ \fB\-D\fP[\fItemplate\fP] ] [ \fB\-E\fP[\fBf\fP|\fBl\fP] ] 
[ \fB\-F\fP\fIcols\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-L\fP ] [ \fB\-I\fP ] [ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] [ \fB\-N\fP ] 
[ \fB\-S\fP\fI"search string"\fP) ] [ \fB\-V\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] 
[ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgmtconvert\fP reads its standard input [or inputfiles] and writes out
the desired information to standard output.  It can do a combination of
three things: (1) convert between binary and ASCII data tables, (2) paste
corresponding records from multiple files into a single file, (3)
extract a subset of the columns, (4) only extract segments whose header
matches a text pattern search, (5) just list all multisegment headers and no data
records, and (6) extract first and last data record for each segment.  Input (and hence output) may have multiple
subheaders if \fB\-M\fP is selected, and ASCII tables may have regular headers as well.
.TP
\fIdatafile(s)\fP
ASCII (or binary, see \fB\-bi\fP) file(s) holding a number of data columns. 
.SH OPTIONS
.TP
.B \-A
The records from the input files should be pAsted horizontally, not appended vertically.  [Default
processes one file at the time].  Note for binary input, all the files you want to paste must
have the same number of columns (as set with \fB\-bi\fP).
.TP
.B \-D
For multiple segment data, dump each segment to a separate output file [Default writes a multiple segment
file to stdout].  Append a format template for the individual file names; this template \fBmust\fP contain a
C format specifier that can format an integer argument (the segment number); this is usually %d but could
be %8.8d which gives leading zeros, etc. [Default is gmtconvert_segment_%d.d].
.TP
.B \-E
Only extract the first and last record for each segment of interest [Default extracts
all records].  Optionally, append \fBf\fP or \fBl\fP to only extract the first or last
record of each segment, respectively.
.TP
.B \-F
Give a comma-separated list of desired columns or ranges (0 is first column) [Default outputs all columns].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Invert the order of rows, i.e., output the final records in reverse order, starting with the last and ending
up with the first input row [Default goes forward].
.TP
.B \-L
Only output a listing of all multisegment header records and no data records (requires \fB\-M\fP and ASCII data).
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-N
Do not write records that only contain NaNs in every field [Default writes all records].
.TP
.B \-S
Only output those segments whose header record contains the specified text string [Default output all segments].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
To convert the binary file test.b (single precision) with 4 columns to ASCII:
.br
.sp
\fBgmtconvert\fP test.b \fB\-bis\fP4 > test.dat
.br
.sp
To convert the multiple segment ASCII table test.d to a double precision binary file:
.br
.sp
\fBgmtconvert\fP test.d \fB\-M \-bo\fP > test.b
.br
.sp
You have an ASCII table with 6 columns and you want to plot column 5 versus column 0.  Try
.br
.sp
\fBgmtconvert\fP table.d \fB\-F\fP5,0 | psxy ...
.br
.sp
If the file instead is the binary file results.b which has 9 single-precision values per record,
we extract the last column and columns 4-6 and write ASCII with the command
.br
.sp
\fBgmtconvert\fP results.b \fB\-F\fP8,4-6 -bi9s | psxy ...
.br
.sp
You want to plot the 2nd column of the file left.d versus the first column of file right.d:
.br
.sp
\fBgmtconvert\fP left.d right.d \fB\-S \-F\fP1,2 | psxy ...
.br
.sp
To extract all segments in the file big_file.d whose headers contain the string "RIDGE AXIS", try
.br
.sp
\fBgmtconvert\fP big_file.d \fB\-M \-S\fP"RIDGE AXIS" > subset.d
.br
.SH "SEE ALSO"
.IR GMT (l),
.IR minmax (l)
