/*
 *  Copyright 2004-2006 Michael Terry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __MULT_PUZZLE_H__
#define __MULT_PUZZLE_H__

#include <sigc++/signal.h>

class MultPuzzle
{
	public:
	
	MultPuzzle (int numXDigits, int numYDigits);
	~MultPuzzle (void);
	
	int guess (char digit, char letter);
	
	int getTotalGuesses (void) const;
	int getWrongGuesses (void) const;
	int getCorrectGuesses (void) const;
	
	/* these returned strings must be free'd */
	char *getMultiplicand (void) const;
	char *getMultiplier (void) const;
	char *getAnswer (void) const;
	
	int getNumAddends (void) const;
	/* returned string must be free'd */
	char *getAddend (int n) const;
	
	bool isDone (void) const;
	
	void solve (void);
	
	bool *getUnknownDigits (void) const;
	bool *getLetterGuesses (char letter) const;
	
	sigc::signal <void, char, char, int> signal_guessed (void) const;
	sigc::signal <void> signal_changed (void) const;
	
	/* guess responses */
	static const int WRONG = -1;
	static const int CORRECT = 0;
	static const int ALREADY_KNOWN = 1;
	static const int INVALID_INPUT = 2;
	
	static const char STARTING_LETTER = 'A';
	static const char *LETTERS[10];
	
	private:
	
	char symbols [10];	/* the character for each digit 0-9 */
	
	/* if a digit has yet to be guessed, its value is true
	 else, if a digit has been guessed, or does not appear on the board, 
	 its value is false */
	bool needed [10];
	
	/* if a digit has yet to be guessed, its value is true, else false */
	bool unknown [10];
	
	/* if a guess has been made for a digit, the value for the digit will be true */
	/* rows are letters, columns are digits */
	bool have_guessed [10][10];
	
	/**
	 * X is the multiplicand, Y the multiplier, and Z the answer.
	 */
	char *x, *y, *z;
	
	/**
	 * This is a list of the addends resulting from the list of X and Y.
	 */
	int numAddends;
	char **addends;
	
	int totalGuesses;
	int wrongGuesses;
	
	static bool seeded;
	
	sigc::signal <void, char, char, int> m_signal_guessed;
	sigc::signal <void> m_signal_changed;
	
	/* helper functions */
	void expandNumString (char **n, int minimum);
	void solve (int digit);
	void shuffle (void);
	char *replace (char *n, int digit);
	char *interpret (char *n);
	void noteNeeded (char *n);
	static int numWithNDigits (int n);
	static char *numToString (int n);
};

#endif /* __MULT_PUZZLE_H__ */
