/* Target-dependent code for GDB, the GNU debugger.

   Copyright 2000, 2001, 2002, 2003, 2004 Free Software Foundation,
   Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef REMOTE_DFW_H
#define REMOTE_DFW_H

struct dfw_register_desc
{
  int regno;
  int group;
};

enum dfw_ppc_groups
  {
    dfw_ppc_general_group = 0,
    dfw_ppc_floating_point_group = 1,
    dfw_ppc_vector_group = 2
  };

enum dfw_ppc_general_regnos
  {
    dfw_ppc_r0_regnum = 0,
    dfw_ppc_msr_regnum = 32,
    dfw_ppc_lr_regnum = 33,
    dfw_ppc_ctr_regnum = 34,
    dfw_ppc_pc_regnum = 35,
    dfw_ppc_cr_regnum = 36,
    dfw_ppc_xer_regnum = 37
  };

enum dfw_ppc_floating_point_regnos
  {
    dfw_ppc_f0_regnum = 0,
    dfw_ppc_fpscr_regnum = 32
  };

enum dfw_ppc_vector_regnos
  {
    dfw_ppc_vr0_regnum = 0,
    dfw_ppc_vscr_regnum = 32
  };

enum dfw_i386_groups
  {
    dfw_i386_general_group = 0,
    dfw_i386_floating_point_group = 1
  };

enum dfw_i386_general_regnos
  {
    dfw_i386_eax_regnum = 0,
    dfw_i386_ebx_regnum = 3,
    dfw_i386_ecx_regnum = 1,
    dfw_i386_edx_regnum = 2,
    dfw_i386_esp_regnum = 4,
    dfw_i386_ebp_regnum = 5,
    dfw_i386_esi_regnum = 6,
    dfw_i386_edi_regnum = 7,
    dfw_i386_eflags_regnum = 8,
    dfw_i386_eip_regnum = 9
  };

enum dfw_i386_floating_point_regnos
  {
    dfw_i386_st0_regnum = 0,
    dfw_i386_fctrl_regnum = 8,
    dfw_i386_fpsr_regnum = 9,
    dfw_i386_ftag_regnum = 10
  };

#define DFW_REGNO_IGNORE -1
#define DFW_REGGROUP_IGNORE -1

#endif
