-----------------------------------------------------------------------
--               GtkAda - Ada95 binding for Gtk+/Gnome               --
--                                                                   --
--                   Copyright (C) 2005                              --
--                           AdaCore                                 --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------

with Gdk.Pixbuf;           use Gdk.Pixbuf;
with Gtk;                  use Gtk;
with Gtk.Main;
with Gtkada.File_Selector; use Gtkada.File_Selector;
with Gtkada.Handlers;      use Gtkada.Handlers;

with Histories;            use Histories;
with Pixmaps_IDE;          use Pixmaps_IDE;
with Test_File_Selector;   use Test_File_Selector;

procedure Run_Test_File_Selector is
   File_Selector_Window : File_Selector_Window_Access;

   Filter_A             : constant Filter_Show_All_Access :=
                            new Filter_Show_All;
   Filter_B             : constant Filter_Show_Ada_Access :=
                            new Filter_Show_Ada;

begin
   Gtk.Main.Set_Locale;
   Gtk.Main.Init;
   Gtk_New
     (File_Selector_Window,
      Root              => "/",
      Initial_Directory => "",
      Dialog_Title      => "File Selector Test",
      Show_Files        => True,
      History           => null);

   Filter_B.Spec_Pixbuf := Gdk_New_From_Xpm_Data (box_xpm);
   Filter_B.Body_Pixbuf := Gdk_New_From_Xpm_Data (package_xpm);

   Filter_A.Label := new String'("without info");
   Filter_B.Label := new String'("with info");

   Register_Filter (File_Selector_Window, Filter_A);
   Register_Filter (File_Selector_Window, Filter_B);

   Show_All (File_Selector_Window);
   Widget_Callback.Connect
     (Get_Ok_Button (File_Selector_Window), "clicked",
      Widget_Callback.To_Marshaller (On_Ok_Button_Clicked'Access));
   Widget_Callback.Connect
     (Get_Cancel_Button (File_Selector_Window), "clicked",
      Widget_Callback.To_Marshaller (On_Cancel_Button_Clicked'Access));
   Gtk.Main.Main;

end Run_Test_File_Selector;
