/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt package details pane
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003, 2004 Filip Van Raemdonck <mechanix@debian.org>
 *
 * Bits taken from Synaptic
 *
 * 	(C) 2000-2003 Conectiva S/A 
 * 	    2002 Michael Vogt <mvo@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/


#include "infopanes.h"
#include "pkgutil.h"
#include <apt-pkg/strutl.h>
#include <fstream>

GAptInfoPanes::GAptInfoPanes()
  : gd_(_("GNOME Apt")), pkg_(0), cache_(0)
{

  set_selection(0);
}

GAptInfoPanes::~GAptInfoPanes()
{

}

void
GAptInfoPanes::set_selection(pkgCache::Package* pkg)
{
  if (cache_ == 0) return;

  pkg_ = pkg;

  if (pkg != 0)
    {
      // causes an update in GDeb
      gd_.set_package(this); 
    }
  else 
    {
      gd_.set_package(0);
    }
}

void 
GAptInfoPanes::set_cache    (GAptCache* cache)
{
  cache_ = cache;
  set_selection(0);
}

  // Stuff to display
string 
GAptInfoPanes::Name() 
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);

  return i.Name();
}


string 
GAptInfoPanes::Version() 
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);
  pkgCache::VerIterator vi = Util::display_version(i,cache_);

  const char* s = 0;
  if (vi.end()) s = _("(no version)");
  else s = vi.VerStr();

  return string(s);
}

string
GAptInfoPanes::Description_Short (void) {
	g_return_val_if_fail (pkg_, "");
	/* gcc is unhappy if we do not explicitly instanciate a pkgCache::PkgIterator to pass on */
	pkgCache::PkgIterator i (*cache_, pkg_);
	pkgRecords::Parser* p = cache_->pkgParser (i);

  string s;

  if (p != 0) s = p->ShortDesc();
  if (s.empty()) s= _("No description available");
  return s;
}

string
GAptInfoPanes::Description_Long (void) {
	g_return_val_if_fail (pkg_, "");
	pkgCache::PkgIterator i (*cache_, pkg_);
	pkgRecords::Parser* p = cache_->pkgParser (i);

  string s;
  if (p != 0) s = p->LongDesc();
  if (s.empty()) s = _("No description available");
  return s;
}

string  
GAptInfoPanes::Section()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  const char* s = i.Section();
  
  if (s == 0) return _("Unknown");
  else return s;
}

string
GAptInfoPanes::Priority (void)  {
	g_return_val_if_fail (pkg_, "");

	pkgCache::PkgIterator i(*cache_, pkg_);
	/* FIXME: improve dealing with virtual packages */
	if (!i.VersionList()) {
		return "";
	}

	return cache_->priorityString (i, 0);
}

string
GAptInfoPanes::Size()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);
  pkgCache::VerIterator vi = Util::display_version(i,cache_);
  
  if (vi.end()) return "";

  if (!vi.Downloadable()) return _("N/A");
  else return SizeToStr(vi->Size);
}

string
GAptInfoPanes::Installed_Size()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);

  pkgCache::VerIterator vi = Util::display_version(i,cache_);

	if (vi.end()) return _("Unknown");
  else return SizeToStr(vi->InstalledSize);
}

string
GAptInfoPanes::Maintainer (void) {
	g_return_val_if_fail (pkg_, "");
	pkgCache::PkgIterator i (*cache_, pkg_);
	pkgRecords::Parser* p = cache_->pkgParser (i);

  string s;
  if (p != 0) s = p->Maintainer();
  if (s.empty()) s = _("Unknown");
  return s;
}

string
GAptInfoPanes::PackageStatus()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");
  
  pkgCache::PkgIterator i(*cache_,pkg_);

	return GAptCache::statusText (cache_->pkgStatus (i));
}

string
GAptInfoPanes::Current_Version()  { return ""; }

string
GAptInfoPanes::Architecture()  { return ""; }

string
GAptInfoPanes::Source()  { return ""; }

string
GAptInfoPanes::Filename()  { return ""; }

/* Stolen from Synaptic */
string
GAptInfoPanes::Filelist (void) {
	static string filelist;
	string s;

	filelist.erase (filelist.begin(), filelist.end());

	string f = "/var/lib/dpkg/info/" + string (Name()) + ".list";
	if (FileExists (f)) {
		ifstream in (f.c_str());
		if (!in.good()) return "";
		while (!in.eof()) {
			getline (in, s);
			filelist += s + "\n";
		}

		in >> filelist;
		return filelist.c_str();
	}
	filelist = _("The list of installed files is only available for installed packages");

	return filelist.c_str();
}

string
GAptInfoPanes::Author (void) { return _("Unknown"); }

string
GAptInfoPanes::Homepage (void) {
	g_return_val_if_fail (pkg_, _("Unknown"));
	pkgCache::PkgIterator i (*cache_, pkg_);
	pkgRecords::Parser* p = cache_->pkgParser (i);

	string s;
	//if (p) s = p->Homepage();
	if (s.empty()) s = _("Unknown");
	return s;
}

bool    
GAptInfoPanes::Essential() 
{ 
  g_return_val_if_fail(pkg_ != 0, false);
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  return ((i->Flags & pkgCache::Flag::Essential) == pkgCache::Flag::Essential);
}

bool   
GAptInfoPanes::Downloadable()
{
  g_return_val_if_fail(pkg_ != 0, false);
  
  pkgCache::PkgIterator i(*cache_,pkg_);
  
  pkgCache::VerIterator vi = Util::display_version(i,cache_);
  
  if (vi.end()) return false;  
  else return vi.Downloadable();
}

bool   
GAptInfoPanes::Automatic()
{
  g_return_val_if_fail(pkg_ != 0, false);
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  pkgCache::VerIterator vi = Util::display_version(i,cache_);
  
  if (vi.end()) return false;  
  else return vi.Automatic();
}

vector<string>  
GAptInfoPanes::Provides() { return vector<string>(0); }

vector<string>  
GAptInfoPanes::PreDepends()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Depends()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Recommends()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Suggests()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Conflicts()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Replaces()  { return vector<string>(0); }
  
void 
GAptInfoPanes::Install() { g_warning(__FUNCTION__); }

void 
GAptInfoPanes::Delete() { g_warning(__FUNCTION__); }

void  
GAptInfoPanes::Keep() { g_warning(__FUNCTION__); }



//////////////////////////////// Hack alert
#include "gdeb/gdeb.cc" // since automake gets confused about doing this
