#!/usr/bin/python

# Hearts - hearts.py
# Copyright 2006 Sander Marechal
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# This is an attempted translation of hearts.lua
# Cards are defined as tuples, so card = (suit, rank)
# Multiple cards are passed around as lists of tuples.

import os
import sys
import string

sys.path.append("/usr/local/lib/python2.4/site-packages/gnome-hearts");
sys.path.append("/usr/local/lib/python2.4/site-packages/gnome-hearts/players");

from definitions import *
from stock_ai import *

# Load all the available player AI's
for script in os.listdir(os.path.abspath("/usr/local/lib/python2.4/site-packages/gnome-hearts/players")):
	module_name, ext = os.path.splitext(script)
	if ext == '.py':
		module = __import__(module_name)
		for method in dir(module):
			if method.startswith('PlayerAI'):
				# Make the AI class a global
				globals()[method] = getattr(module, method)
				# Register the AI in C
				ai = globals()[method](None, None)
				register_ai(ai.name, method)

# The Trick class
class Trick:
	"""A trick of cards, equal to the C version"""
	
	def __init__(self):
		self.card = []
		self.trump = None
		self.num_played = 0
		self.first_played = None
	
	def set(self, list, trump, num_played, first_played):
		self.card = list
		self.trump = trump
		self.num_played = num_played
		self.first_played = first_played
	
	def winner():
		"""Return who played the highest card on the trick"""
		max, winner = 0, None		
		if self.num_played:
			return None
		for i in range(4):
			if card[i][0] == self.trump and card[i][1] > max:
				max = card[i][1]
				winner = i
		return winner
	
	def get_highest_card(trick):
		"""Return the highest trump card in the list"""
		highest_card = (0, 0)
		for card in trick.card:
			if card != None and card[0] == trick.trump and card[1] > highest_card[1]:
				highest_card = card
		return highest_card

trick = Trick()

# General setting functions used by C
def player_set(object, direction):
	player[direction] = object

def score_set(list):
	score = list

# The list of players
player = [None, None, None, None]

# The score table
score = [[0, 0], [0, 0], [0, 0], [0, 0]]

