#include "common.h"
#include "changenick.h"
#include "detach.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "history.h"
#include "icons.h"
#include "msg.h"
#include "personal_info.h"
#include "response.h"
#include "sendcontact.h"
#include "showlist.h"
#include "tcp.h"
#include "user_popup.h"
#include "v7send.h"
#include "v7snac13.h"
#include "groups.h"
#include "grpmgr.h"
#include "auth.h"

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <string.h>

static void icq_sendmessage_window_from_menu( GtkWidget *widget, gpointer data );
static void send_url_window_default( GtkWidget *widget, gpointer data );
static void get_contact_list (GtkWidget *widget, gpointer data);
static void request_file_from_menu (GtkWidget *widget, gpointer data);
static void retrieve_away_message( GtkWidget *widget, gpointer data );
static void add_user_to_list( GtkWidget *widget, gpointer data );
static void request_auth (GtkWidget *widget, Contact_Member *data);
static void remove_user_question( GtkWidget *widget, gpointer data );
static void lists_change_list_ignore (GtkWidget *widget, gpointer data);
static void lists_change_list_visible (GtkWidget *widget, gpointer data);
static void lists_change_list_invisible (GtkWidget *widget, gpointer data);
static void lists_change_list_notify (GtkWidget *widget, gpointer data);
static void lists_change_list( GtkWidget *widget, gpointer data, gint type );
static void add_files( GtkWidget *widget, gpointer data);
static void remove_files( GtkWidget *widget, gpointer data);
static void add_files_final( GtkWidget *button, gpointer data );
static void remove_user (GtkDialog *dialog, int response, gpointer data);
static void user_change_group (GtkWidget *widget, GroupInfo *data);

enum {
        ICQ_RESPONSE_SEND = 1
};

GtkWidget *user_popup (Contact_Member *contact)
{
	GtkWidget *personal_menu, *lists_menu;
	GtkWidget *item, *image;
	GSList *ginfo;

	g_assert (contact != NULL);

	personal_menu = gtk_menu_new ();

	item = gtk_image_menu_item_new_with_label (contact->uin);
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
	/*	g_signal_connect (G_OBJECT (item), "activate",
	                    G_CALLBACK (dump_contact_details),
	                    contact); */

	item = gtk_separator_menu_item_new ();
	gtk_container_add (GTK_CONTAINER (personal_menu), item);

	item = gtk_image_menu_item_new_with_mnemonic (_("_Message..."));
	image = gtk_image_new_from_pixbuf (icon_message_pixbuf);
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_sendmessage_window_from_menu),
	                  contact);

	item = gtk_image_menu_item_new_with_mnemonic (_("_URL..."));
	image = gtk_image_new_from_pixbuf (icon_url_pixbuf);
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (send_url_window_default), contact);

	item = gtk_image_menu_item_new_with_mnemonic (_("_Contact List..."));
	image = gtk_image_new_from_pixbuf (icon_contact_pixbuf);
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (get_contact_list), contact);

#if 1 /* FXFER */
        /* file transfer */
	if (contact->used_version >= 8) {
		item = gtk_image_menu_item_new_with_mnemonic (_("Send _File..."));
		image = gtk_image_new_from_pixbuf (icon_file_pixbuf);
		gtk_container_add (GTK_CONTAINER (personal_menu), item);
		gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
		gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
		g_signal_connect (G_OBJECT (item), "activate",
		                  G_CALLBACK (request_file_from_menu), contact);
	}

	item = gtk_separator_menu_item_new ();
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
#endif

        /* user info */
	item = gtk_image_menu_item_new_with_mnemonic (_("User _Info"));
	image = gtk_image_new_from_pixbuf (icon_info_pixbuf);
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (show_personal_info), contact);

	if ((contact->status & 0xffff) != STATUS_ONLINE &&
	    contact->status != STATUS_OFFLINE &&
	    (contact->status & 0xffff) != STATUS_INVISIBLE &&
	    (contact->status & 0xffff) != STATUS_FREE_CHAT) {

		switch (contact->status & 0xffff) {
		case STATUS_AWAY:
			item = gtk_image_menu_item_new_with_mnemonic (_("_Read Away Message"));
			break;
		case STATUS_NA:
			item = gtk_image_menu_item_new_with_mnemonic (_("_Read Not Available Message"));
			break;
		case STATUS_OCCUPIED:
			item = gtk_image_menu_item_new_with_mnemonic (_("_Read Occupied Message"));
			break;
		case STATUS_DND:
			item = gtk_image_menu_item_new_with_mnemonic (_("_Read Do Not Disturb Message"));
			break;
		default:
			item = gtk_image_menu_item_new_with_mnemonic (_("_Read Message for Unknown Status"));
			break;
		}

		image = gtk_image_new_from_pixbuf (get_pixbuf_for_status (contact->status));
		gtk_container_add (GTK_CONTAINER (personal_menu), item);
		gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
		g_signal_connect (G_OBJECT (item), "activate",
		                  G_CALLBACK (retrieve_away_message),
		                  contact);
	}

        /* history */
	item = gtk_image_menu_item_new_with_mnemonic (_("_History"));
	image = gtk_image_new_from_pixbuf (icon_hist_pixbuf);
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (history_display), contact);

	/* Lists menu */
	lists_menu = gtk_menu_new ();

	/* On ignore list... */
	item = gtk_check_menu_item_new_with_mnemonic (_("On _Ignore List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->ignore_list);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_container_add (GTK_CONTAINER (lists_menu), item);
	gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	g_signal_connect (G_OBJECT (item), "toggled",
	                  G_CALLBACK (lists_change_list_ignore),
	                  contact);

	/* On visible list... */
	item = gtk_check_menu_item_new_with_mnemonic (_("On _Visible List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->vis_list);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_container_add (GTK_CONTAINER (lists_menu), item);
	gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	g_signal_connect (G_OBJECT (item), "toggled",
	                  G_CALLBACK (lists_change_list_visible),
	                  contact);

	/* On invisible list... */
	item = gtk_check_menu_item_new_with_mnemonic (_("On Invi_sible List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->invis_list);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_container_add (GTK_CONTAINER (lists_menu), item);
	gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	g_signal_connect (G_OBJECT (item), "toggled",
	                  G_CALLBACK (lists_change_list_invisible),
	                  contact);

	/* On online notify list... */
	item = gtk_check_menu_item_new_with_mnemonic (_("On _Notify List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->online_notify);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_container_add (GTK_CONTAINER (lists_menu), item);
	g_signal_connect (G_OBJECT (item), "toggled",
	                  G_CALLBACK (lists_change_list_notify),
	                  contact);

	/* End Lists Menu */

	item = gtk_image_menu_item_new_with_mnemonic (_("_Lists"));
	image = gtk_image_new_from_pixbuf (icon_lists_pixbuf);
	gtk_container_add (GTK_CONTAINER (personal_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), lists_menu);
	gtk_widget_show_all (lists_menu);

	item = gtk_separator_menu_item_new ();
	gtk_container_add (GTK_CONTAINER (personal_menu), item);

	/* Detach/Attach user */
	item = gtk_check_menu_item_new_with_mnemonic (_("Show _Shortcut"));

	if (GTK_IS_WIDGET (contact->detached_window)
	    && GTK_WIDGET_VISIBLE (contact->detached_window))
		gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
	else
		gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), FALSE);

	gtk_container_add (GTK_CONTAINER (personal_menu), item);

	if (GTK_IS_WIDGET (contact->detached_window))
		g_signal_connect (G_OBJECT (item), "activate",
		                  G_CALLBACK (detach_contact_hide),
		                  contact);
	else
		g_signal_connect (G_OBJECT (item), "activate",
		                  G_CALLBACK (detach_contact), contact);


	/* Separator */
	item = gtk_separator_menu_item_new ();
	gtk_container_add (GTK_CONTAINER (personal_menu), item);

	if (contact->inlist == FALSE) {
          /* Add to group menu */
	  lists_menu = gtk_menu_new ();

	  for (ginfo = Groups; ginfo != NULL; ginfo = ginfo->next) {
	    
	    item = gtk_menu_item_new_with_label (((GroupInfo *)ginfo->data)->name);
	    g_object_set_data(G_OBJECT(item), "contact", contact);
	    gtk_container_add (GTK_CONTAINER (lists_menu), item);
	    g_signal_connect (G_OBJECT (item), "activate",
			      G_CALLBACK (add_user_to_list),
			      GUINT_TO_POINTER((guint)((GroupInfo *)ginfo->data)->gid));
	    g_object_set_data (G_OBJECT (item), "contact", contact);
	  }

	  item = gtk_image_menu_item_new_with_mnemonic (_("_Add to Group"));
	  image = gtk_image_new_from_pixbuf (icon_groups_pixbuf);
	  gtk_container_add (GTK_CONTAINER (personal_menu), item);
	  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	  gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), lists_menu);

	} else {
	  
	  /* Change to group menu */
	  lists_menu = gtk_menu_new ();

	  for (ginfo = Groups; ginfo != NULL; ginfo = ginfo->next) {
	    if (contact->gid == ((GroupInfo *)(ginfo->data))->gid)
	      continue;

	    item = gtk_menu_item_new_with_label (((GroupInfo *)(ginfo->data))->name);
	    gtk_container_add (GTK_CONTAINER (lists_menu), item);
	    g_signal_connect (G_OBJECT (item), "activate",
			      G_CALLBACK (user_change_group), ginfo->data);
	    g_object_set_data (G_OBJECT (item), "contact", contact);
	  }

	  /* seperator */
	  item = gtk_separator_menu_item_new ();
	  gtk_container_add (GTK_CONTAINER (lists_menu), item);

	  item = gtk_menu_item_new_with_mnemonic (_("_New Group..."));
	  gtk_container_add (GTK_CONTAINER (lists_menu), item);
	  g_signal_connect (G_OBJECT (item), "activate",
			    G_CALLBACK (grpmgr_window), contact);

	  item = gtk_image_menu_item_new_with_mnemonic (_("Change to _Group"));
	  image = gtk_image_new_from_pixbuf (icon_groups_pixbuf);
	  gtk_container_add (GTK_CONTAINER (personal_menu), item);
	  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	  gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
	  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), lists_menu);

	}

	/* seperator */
        if (contact->inlist || contact->wait_auth) {
          item = gtk_separator_menu_item_new ();
          gtk_container_add (GTK_CONTAINER (personal_menu), item);
        }

        if (contact->wait_auth) {
          item = gtk_image_menu_item_new_with_mnemonic (_("Re-request a_uthorization"));
          image = gtk_image_new_from_pixbuf (icon_auth_pixbuf);
          gtk_container_add (GTK_CONTAINER (personal_menu), item);
          gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
          gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
          g_signal_connect (G_OBJECT (item), "activate",
                            G_CALLBACK (request_auth), contact);
        }

        if (contact->inlist) {
          item = gtk_image_menu_item_new_with_mnemonic (_("Re_name User..."));
          image = gtk_image_new_from_pixbuf (icon_rename_pixbuf);
          gtk_container_add (GTK_CONTAINER (personal_menu), item);
          gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
          gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
          g_signal_connect (G_OBJECT (item), "activate",
                            G_CALLBACK (change_nick_window), contact);

          item = gtk_image_menu_item_new_with_mnemonic (_("Re_move User"));
          image = gtk_image_new_from_pixbuf (icon_cancel_pixbuf);
          gtk_container_add (GTK_CONTAINER (personal_menu), item);
          gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
          gtk_widget_set_sensitive(item, Current_Status != STATUS_OFFLINE);
          g_signal_connect (G_OBJECT (item), "activate",
                            G_CALLBACK (remove_user_question), contact);
        }

	gtk_widget_show_all (personal_menu);

	return personal_menu;
}

static void icq_sendmessage_window_from_menu( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage_window_from_menu\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	if (g_slist_length (kontakt->stored_messages))
		show_contact_message (kontakt);
	else
		open_message_dlg_with_message (kontakt, NULL);
}

static void send_url_window_default( GtkWidget *widget, gpointer data )
{
	g_object_set_data (G_OBJECT (widget), "contact", data);
	send_url_window( widget, "" );
}

static void get_contact_list( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "get_contact_list\n" );
#endif

	if( data == NULL )
		return;

	contact_list_window( data );
}

static void request_file_from_menu (GtkWidget *widget, gpointer data)
{
	request_file (widget, NULL, data);
}

void request_file( GtkWidget *widget, GList *files, gpointer data )
{
	GSList *contact;

        GList *file;

	GtkWidget *window;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label3;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *filelist;
	GtkWidget *label2;
	GtkWidget *scrolledwindow2;
	GtkWidget *scrolledwindow1;
	GtkWidget *text1;
	GtkWidget *button1;
	GtkWidget *addbutton;
	GtkWidget *removebutton;

	gchar *str, *filenames[1];

#ifdef TRACE_FUNCTION
	g_print( "request_file\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	window = gtk_dialog_new_with_buttons (_("Send File"),
                                              GTK_WINDOW (MainData->window),
                                              GTK_DIALOG_DESTROY_WITH_PARENT,
                                              NULL);

	gtk_window_set_role (GTK_WINDOW (window), "GnomeICU_SendFile");
	gtk_window_set_default_size( GTK_WINDOW( window ), 350, 250 );
	gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);

        set_window_icon( window, "gnomeicu-file.png" );

	dialog_vbox1 = GTK_DIALOG (window)->vbox;

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	str = g_strdup_printf( _("Send File to %s:"), kontakt->nick );

	label3 = gtk_label_new ( str );
	g_free( str );
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox1), label3, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);

	label1 = gtk_label_new (_("Files:"));
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	filelist = gtk_clist_new(1);

	gtk_clist_set_selection_mode(GTK_CLIST(filelist), GTK_SELECTION_EXTENDED);
        for ( file = files; file; file = file->next )
        {
            char *data = file->data;

            /* Since its a file, we can strip the protocol type */
            if (strncmp (data, "file:", 5) == 0)
                data += 5;

            filenames[0] = data;
            gtk_clist_append(GTK_CLIST(filelist), filenames);
        }
	gtk_widget_show (filelist);

	gtk_container_add (GTK_CONTAINER (scrolledwindow2), filelist);

	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);

	addbutton = gtk_button_new_with_label(_("Add files..."));
	gtk_widget_show (addbutton);
	gtk_box_pack_end (GTK_BOX (hbox1), addbutton, FALSE, FALSE, 3);
	g_signal_connect (G_OBJECT (addbutton), "clicked",
			  G_CALLBACK (add_files), filelist);

	removebutton = gtk_button_new_with_label(_("Remove files"));
	gtk_widget_show (removebutton);
	gtk_box_pack_end (GTK_BOX (hbox1), removebutton, FALSE, FALSE, 3);
	g_signal_connect (G_OBJECT (removebutton), "clicked",
			  G_CALLBACK (remove_files), filelist);

	label2 = gtk_label_new (_("Reason:"));
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text1 = gtk_text_view_new ();
	gtk_widget_show (text1);
	gtk_text_view_set_wrap_mode( GTK_TEXT_VIEW( text1 ), GTK_WRAP_WORD);
	gtk_text_view_set_editable( GTK_TEXT_VIEW( text1 ), TRUE );
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

	gtk_dialog_add_button (GTK_DIALOG (window),
					 GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE);
	button1 = make_button_with_pixmap (_("Send"), GTK_STOCK_JUMP_TO);
	gtk_dialog_add_action_widget (GTK_DIALOG (window), button1, ICQ_RESPONSE_SEND);

	g_object_set_data (G_OBJECT (window), "reason", text1);
	g_object_set_data (G_OBJECT (window), "uin",
			     kontakt->uin);
	g_object_set_data (G_OBJECT (window), "filelist", filelist);


	gtk_dialog_set_default_response (GTK_DIALOG (window), ICQ_RESPONSE_SEND);

	g_signal_connect (G_OBJECT (window), "response", 
	                  G_CALLBACK (send_file_request), NULL);

	g_signal_connect_swapped (G_OBJECT (window), "response", 
	                          G_CALLBACK (gtk_widget_destroy), window);


	gtk_widget_show (window);
}

static void retrieve_away_message( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "retrieve_away_message\n" );
#endif

	if (!is_connected(GTK_WINDOW(MainData->window), _("You can not retrieve away messages while disconnected.")))
		return;

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

        /* trillian reports version 0, does it do away messages?*/
        if (kontakt->version >= 8 || kontakt->version == 0)
          v7_request_away_msg(mainconnection, kontakt->uin, kontakt->status);
        else
          TCPRetrieveAwayMessage( contact, NULL );
}

static void add_user_to_list( GtkWidget *widget, gpointer data )
{

        CONTACT_PTR contact;

#ifdef TRACE_FUNCTION
	g_print( "add_user_to_list\n" );
#endif

	if (!is_connected(GTK_WINDOW(MainData->window), _("You can not add a user to a list while disconnected.")))
		return;

	contact = g_object_get_data(G_OBJECT(widget), "contact");
	if( contact == NULL)
		return;

	v7_try_add_uin (mainconnection, contact->uin, contact->nick, GPOINTER_TO_INT(data), FALSE);
  
	Save_RC();
}

static void
request_auth (GtkWidget *widget, Contact_Member *contact)
{
  g_assert (contact != NULL);

  if (!is_connected(GTK_WINDOW(MainData->window),
                    _("You can not authorize a contact while disconnected.")))
    return;

  auth_request_msg_box (contact->nick, contact->uin);
}

static void remove_user_question( GtkWidget *widget, gpointer data )
{
	GtkWidget *dialog;
	GtkWidget *vbox;
	GtkWidget *hbox;	
	GtkWidget *label;
	GtkWidget *image;
	GtkWidget *remhist_button;
	gchar *string, *message;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "remove_user_question\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	dialog = gtk_dialog_new_with_buttons ("",
	                                      GTK_WINDOW (MainData->window),
	                                      GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_NO_SEPARATOR,
	                                      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                                      _("_Remove"), GTK_RESPONSE_YES,
	                                      NULL);

	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_YES);
	gtk_window_set_wmclass (GTK_WINDOW (dialog), "Remove_Contact", "GnomeICU");
	gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 6);

	hbox = gtk_hbox_new (FALSE, 12);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), hbox);

	image = gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION, GTK_ICON_SIZE_DIALOG);
	gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (image), 0.5, 0);

	vbox = gtk_vbox_new (FALSE, 6);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);
	gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);

	message = g_strdup_printf (_("Are you sure you wish to remove %s from your contact list?"),kontakt->nick);
	string = g_strdup_printf ("<span weight=\"bold\" size=\"larger\">%s</span>\n\n%s",
	                          _("Remove User?"), message);

	label = gtk_label_new (NULL);
	gtk_label_set_markup (GTK_LABEL (label), string);
	g_free (message);
	g_free (string);
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_label_set_selectable (GTK_LABEL (label), TRUE);
	gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0);

	remhist_button = gtk_check_button_new_with_mnemonic (_("Remove User's _History file"));
	gtk_box_pack_start (GTK_BOX (vbox), remhist_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( remhist_button ), TRUE );

	g_object_set_data (G_OBJECT (dialog), "contact", contact);

	g_signal_connect (G_OBJECT (dialog), "response",
	                  G_CALLBACK (remove_user),
	                  remhist_button);

	gtk_widget_show_all (dialog);
}

static void lists_change_list_ignore (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 0);
}

static void lists_change_list_visible (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 1);
}

static void lists_change_list_invisible (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 2);
}

static void lists_change_list_notify (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 3);
}

static void lists_change_list( GtkWidget *widget, gpointer data, gint type )
{
    CONTACT_PTR contact;
    /*gint method = 0;
    GtkWidget *dialog;
    gchar *msg;*/

#ifdef TRACE_FUNCTION
    g_print( "lists_change_lists" );
#endif

    if (!is_connected(GTK_WINDOW(MainData->window), _("You can not change a list while disconnected.")))
        return;
    contact = data;

    switch(type)
    {
    case 0: /* ignore list */
      if ( contact->ignore_list != GTK_CHECK_MENU_ITEM( widget )->active) {
        contact->ignore_list = GTK_CHECK_MENU_ITEM( widget )->active;
        if (contact->ignore_list) {
          v7_ignore (mainconnection, contact->uin,
                     contact->ignorelist_uid = contact_gen_uid (),
                     TRUE); /* add */
        } else {
          v7_ignore (mainconnection, contact->uin, contact->ignorelist_uid,
                     FALSE); /* remove */
        }
      }
      break;
    case 1: /* visible list */
      if ( contact->vis_list != GTK_CHECK_MENU_ITEM( widget )->active) {
        contact->vis_list = GTK_CHECK_MENU_ITEM( widget )->active;
        if (contact->vis_list) {
          v7_visible (mainconnection, contact->uin,
                      contact->vislist_uid = contact_gen_uid (),
                      TRUE); /* add */
        } else {
          v7_visible (mainconnection, contact->uin, contact->vislist_uid,
                      FALSE); /* remove */
        }
      }
      break;
    case 2: /* invisible list */
      if ( contact->invis_list != GTK_CHECK_MENU_ITEM( widget )->active) {
        contact->invis_list = GTK_CHECK_MENU_ITEM( widget )->active;
        if (contact->invis_list) {
          v7_invisible (mainconnection, contact->uin,
                        contact->invlist_uid = contact_gen_uid (),
                        TRUE); /* add */
        } else {
          v7_invisible (mainconnection, contact->uin, contact->invlist_uid,
                        FALSE); /* remove */
        }
      }
      break;
    case 3: /* notify */
        contact->online_notify = GTK_CHECK_MENU_ITEM( widget )->active;
        break;
	 default:
		  g_warning("Unknown list: %d\n", type);
    }
}

static void add_files( GtkWidget *widget, gpointer data)
{
  GtkWidget *filebrowser;

  filebrowser = gtk_file_selection_new("Send Files...");
  gtk_file_selection_set_select_multiple(GTK_FILE_SELECTION(filebrowser),
				 TRUE);
  g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (filebrowser)->ok_button),
		    "clicked",
		    G_CALLBACK (add_files_final),
		    filebrowser);

  g_object_set_data(G_OBJECT(filebrowser), "gtkclist", data);

  g_signal_connect_swapped (G_OBJECT (GTK_FILE_SELECTION (filebrowser)->ok_button),
			    "clicked",
			    G_CALLBACK (gtk_widget_destroy), 
			    filebrowser); 

   g_signal_connect_swapped (G_OBJECT (GTK_FILE_SELECTION (filebrowser)->cancel_button),
                             "clicked",
                             G_CALLBACK (gtk_widget_destroy),
                             filebrowser); 


   gtk_widget_show_all(filebrowser);
  
}

static void remove_files( GtkWidget *widget, gpointer data)
{
	GList *selected;

	while ((selected = GTK_CLIST(data)->selection))
		gtk_clist_remove(GTK_CLIST(data), GPOINTER_TO_INT(selected->data) );
}

static void add_files_final( GtkWidget *button, gpointer data )
{
  GtkWidget *filesel = data;
  GtkWidget *clist = g_object_get_data(G_OBJECT(filesel), "gtkclist");
  gchar **files;

  files = gtk_file_selection_get_selections(GTK_FILE_SELECTION(filesel));

  gtk_clist_append(GTK_CLIST(clist), files);
  
}

void remove_user (GtkDialog *dialog, int response, gpointer data)
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "remove_user\n" );
#endif

	if (response == GTK_RESPONSE_YES)
	{
		if (!is_connected(GTK_WINDOW(dialog), _("You can not remove a contact while disconnected.")))
			return;

		contact = g_object_get_data (G_OBJECT (dialog), "contact");
		if( contact == NULL )
			return;

                /* remove from status list, if she is on any of them */
                if (kontakt->vis_list)
                  v7_visible (mainconnection, kontakt->uin,
                              kontakt->vislist_uid, FALSE);
                if (kontakt->invis_list)
                  v7_invisible (mainconnection, kontakt->uin,
                                kontakt->invlist_uid, FALSE);
                if (kontakt->ignore_list)
                  v7_ignore (mainconnection, kontakt->uin,
                             kontakt->ignorelist_uid, FALSE);

                /* remove the contact */
		if (kontakt->inlist == TRUE)
			v7_remove_contact (mainconnection, kontakt->uin,
                                           kontakt->nick, kontakt->gid,
                                           kontakt->uid, kontakt->wait_auth);

		remove_contact (contact, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data)));
		Save_RC();
	}

	gtk_widget_destroy (GTK_WIDGET (dialog));
}

static void
user_change_group (GtkWidget *widget, GroupInfo *d)
{
	Contact_Member *contact;
	guint uid;

	contact = g_object_get_data (G_OBJECT (widget), "contact");

	if (contact) {
		if (!is_connected (GTK_WINDOW (MainData->window), _("You can not change the group of a user while disconnected.")))
			return;

		uid = v7_user_change_group (mainconnection, contact, d->gid, d->name);

		gnomeicu_tree_user_remove (contact);
		contact->gid = d->gid;
		contact->uid = uid;
		gnomeicu_tree_user_add (contact);
                if (contact->status != STATUS_OFFLINE)
                  gnomeicu_tree_user_online (contact);
	}
}
