// -*- c++ -*-

//  Gnomoradio - gnomoradio/song-info.h
//  Copyright (C) 2003  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __SONG_INFO_H
#define __SONG_INFO_H

#include <gtkmm.h>
#include "song-rater.h"
#include "wraporadio/wraporadio.h"

namespace Gnomoradio
{
	class SongInfoBox : public Gtk::Window
	{
	public:
		SongInfoBox (const Wraporadio::Song &song);
		virtual ~SongInfoBox ();
		
	protected:
		Wraporadio::Song box_song;

		std::vector<Gtk::Entry *> entries;
		std::vector<Gtk::Label *> labels;
		Gtk::Button ok_button, cancel_button;

		SongRater rating;
		
		void on_hide_signal ();
		void on_ok_clicked ();
		void on_cancel_clicked ();
		void ok_button_set_sensitive ();
        };
}


#endif
