//  Gnomoradio - roboradio/audio/audio.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "audio.h"
#include "mp3.h"
#if USE_VORBIS
#include "ogg.h"
#endif

using namespace std;
using namespace Roboradio::Audio;

Audio *Roboradio::Audio::Audio::create (const Glib::ustring &filename)
{
#if USE_VORBIS
	// do the ogg test
	bool ogg = false;
	FILE *file = fopen(filename.c_str(), "rb");
	if (file) {
		OggVorbis_File vf;
		if (ov_test(file, &vf, 0, 0) == 0) {
			ogg = true;
			ov_clear(&vf);
		} else
			fclose(file);
	}

	if (ogg)
		return new Ogg(filename);
	else
		return new Mp3(filename);
#else
	return new Mp3(filename);
#endif
}

Roboradio::Audio::Audio::~Audio ()
{
}
