// -*- c++ -*-

//  Gnomoradio - roboradio/init.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_INIT_H
#define __ROBORADIO_INIT_H

#include <sigc++/sigc++.h>
#include <glibmm.h>
#include "roboradio/state.h"
#include "rainbow/init.h"
#include "roboradio/song-list.h"
#include "roboradio/player.h"
#include "roboradio/recommendation.h"

namespace Roboradio
{
	class Init
	{
	public:
		Init ();
		~Init ();

		Player *player () { return &default_player; }

		static Rainbow::Init& get_rainbow () { return *rainbow; }
		static State& get_state () { return *session; }
		static Recommendation& get_recommendation () { return *recommend; }

	private:
		static void on_rainbow_enabled_changed (bool enabled);
		static void on_rainbow_hub_changed (Glib::ustring hub);
		static void on_rainbow_cache_size_changed (unsigned int megabytes);

		static int refcnt;
		static Rainbow::Init *rainbow;
		static State *session;
		static Recommendation *recommend;
		static Player default_player;
	};
}

#endif
