/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave File splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"
#include <gnome.h>

#include "prefs.h"

GnoWavCutPreferences *settings = NULL;

void prefs_load(void) {
	if(settings == NULL) {
		settings = g_new0(GnoWavCutPreferences, 1);
	} else {
		g_free(settings->wave_dsp_dev);
		g_free(settings->suffix);
		g_free(settings->filter_command);
	}
	
	gnome_config_push_prefix ("/gnowavcut/Wave/");
	
	settings->wave_dsp_dev = g_strdup(gnome_config_get_string("dsp_dev=/dev/dsp"));

	settings->wave_mini_preview_play = gnome_config_get_bool("mini_preview_play=TRUE");
	settings->wave_mini_play_sec = gnome_config_get_int("mini_play_sec=2");
	
	settings->wave_move_sec = gnome_config_get_int("move_sec=4");
	
	settings->wave_use_volume_bar = gnome_config_get_bool("use_volume_bar=FALSE");

	gnome_config_pop_prefix();


	gnome_config_push_prefix("/gnowavcut/Filter/");

	settings->suffix = g_strdup(gnome_config_get_string("suffix=.mp3"));
	settings->filter_command = g_strdup(gnome_config_get_string("filter_command=gogo stdin %s"));

	gnome_config_pop_prefix();

	gnome_config_sync();
}

void prefs_save(void) {
	g_return_if_fail(settings != NULL);

	gnome_config_push_prefix("/gnowavcut/Wave/");

	gnome_config_set_string("dsp_dev", settings->wave_dsp_dev);
	gnome_config_set_bool("mini_preview_play", settings->wave_mini_preview_play);
	gnome_config_set_int("mini_play_sec", settings->wave_mini_play_sec);
	gnome_config_set_int("move_sec", settings->wave_move_sec);
	gnome_config_set_bool("use_volume_bar", settings->wave_use_volume_bar);

	gnome_config_pop_prefix();

	gnome_config_push_prefix("/gnowavcut/Filter/");

	gnome_config_set_string("suffix", settings->suffix);
	gnome_config_set_string("filter_command", settings->filter_command);

	gnome_config_pop_prefix();

	gnome_config_sync();
}
gchar *prefs_get_suffix(void) {
	if(settings->suffix[0] == '.')
		return g_strdup(settings->suffix + 1);
	
	return g_strdup(settings->suffix);
}

