/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/collection.c
 * @brief code for operations with collections
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "fs.h"
#include "helper.h"
#include "meta.h"
#include "collection.h"
#include <GNUnet/gnunet_collection_lib.h>
#include <extractor.h>

static GladeXML *metaXML;

void
on_collectionDialogMetaDataAddButton_clicked_fs (gpointer dummy,
                                                 GtkWidget * uploadButton)
{
  handleMetaDataListUpdate (metaXML,
                            "collectionMetaDataTypeComboBox",
                            "collectionMetaDataValueEntry",
                            "collectionMetaDataTreeView");
}


void
createCollection_clicked_fs (GtkWidget * dummy1, GtkWidget * dummy2)
{
  const char *collectionName;
  const char *updateIntervalString;
  GtkWidget *w;
  GtkWidget *nameLine;
  GtkWidget *dialog;
  GtkWidget *spin;
  struct ECRS_MetaData *meta;
  struct ECRS_URI *root;
  TIME_T updateInterval;

  metaXML
    = glade_xml_new (getGladeFileName (),
                     "createCollectionDialog", PACKAGE_NAME);
  connectGladeWithPlugins (metaXML);
  dialog = glade_xml_get_widget (metaXML, "createCollectionDialog");
  createMetaDataListTreeView (metaXML,
                              "collectionMetaDataTreeView", NULL, NULL);
  createMetaTypeComboBox (metaXML, "collectionMetaDataTypeComboBox");
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      updateIntervalString
        = getEntryLineValue (metaXML,
                             "collectionUpdateIntervalComboBoxEntry");
      if (0 == strcmp (_("--sporadic update--"), updateIntervalString))
        updateInterval = ECRS_SBLOCK_UPDATE_SPORADIC;
      else if (0 == strcmp (_("--no update--"), updateIntervalString))
        updateInterval = ECRS_SBLOCK_UPDATE_NONE;
      else if (OK != parseTime (updateIntervalString, &updateInterval))
        {
          gtk_widget_destroy (dialog);
          UNREF (metaXML);
          metaXML = NULL;
          dialog = gtk_message_dialog_new
            (NULL,
             GTK_DIALOG_MODAL,
             GTK_MESSAGE_ERROR,
             GTK_BUTTONS_CLOSE, _("Failed to parse given time interval!"));
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
          return;
        }
      meta = getMetaDataFromList (metaXML,
                                  "collectionMetaDataTreeView", NULL);
      spin = glade_xml_get_widget (metaXML, "collectionAnonymityLevel");
      nameLine = glade_xml_get_widget (metaXML, "collectionIdentifierEntry");
      collectionName = gtk_entry_get_text (GTK_ENTRY (nameLine));
      root = NULL;
      if (OK == CO_startCollection (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin)), 1000,    /* priority */
                                    updateInterval, collectionName, meta))
        {
          w = glade_xml_get_widget (getMainXML (), "createCollection");
          gtk_widget_set_sensitive (w, FALSE);
          w = glade_xml_get_widget (getMainXML (), "deleteCollection");
          gtk_widget_set_sensitive (w, TRUE);
        }
      else
        {
          GtkWidget *dialog;

          dialog = gtk_message_dialog_new
            (NULL,
             GTK_DIALOG_MODAL,
             GTK_MESSAGE_ERROR,
             GTK_BUTTONS_CLOSE,
             _("Failed to start collection `%s' (consult logs)."),
             collectionName);
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
        }
      ECRS_freeMetaData (meta);
    }
  gtk_widget_destroy (dialog);
  UNREF (metaXML);
  metaXML = NULL;
}

void
deleteCollection_clicked_fs (GtkWidget * dummy1, GtkWidget * dummy2)
{
  GtkWidget *w;

  if (OK == CO_stopCollection ())
    {
      w = glade_xml_get_widget (getMainXML (), "createCollection");
      gtk_widget_set_sensitive (w, TRUE);
      w = glade_xml_get_widget (getMainXML (), "deleteCollection");
      gtk_widget_set_sensitive (w, FALSE);
      infoMessage (NO, _("Collection stopped.\n"));
    }
  else
    {
      infoMessage (YES, _("Failed to stop collection (consult logs).\n"));
    }
}

void
fs_collection_start ()
{
  GtkWidget *w;
  char *h;

  h = CO_getCollection ();
  if (NULL != h)
    {
      w = glade_xml_get_widget (getMainXML (), "createCollection");
      FREE (h);
    }
  else
    w = glade_xml_get_widget (getMainXML (), "deleteCollection");
  gtk_widget_set_sensitive (w, FALSE);
}

/* end of collection.c */
