# web/quotes.py
#
#

""" show all quotes """

__copyright__ = 'this file is in the public domain'


from gozerbot.config import config
if config['dbenable']:
    from gozerbot.db import db
else:
    from gozerplugs.plugs.quote import quotes
from gozerplugs.plugs.webserver import httpd

def handle_quotes(event):
    """ show all pickled quotes """
    result = []
    for i in quotes.data:
        result.append("[%s] %s" % (i.id, i.txt))
    if not result:
        return ['no quotes', ]
    return result

def handle_quotesdb(event):
    """ show all database quotes """
    result = []
    dbresult = db.execute(""" SELECT indx, quote FROM quotes """)
    if not dbresult:
        return ['no quotes', ]
    for i in dbresult:
        result.append("[%s] %s" % (i[0], i[1]))
    return result

if httpd:
    if not config['dbenable']:
        httpd.addhandler('quotes', handle_quotes)
    else:
        httpd.addhandler('quotes', handle_quotesdb)
