# gozerbot/ircevent.py
#
#
# http://www.irchelp.org/irchelp/rfc/rfc2812.txt

""" an ircevent is extracted from the IRC string received from the server """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, stripident, fix_format, todefenc
import time, re, types

def makeargrest(ievent):
    """ create ievent.args and ievent.rest .. this is needed because \
        ircevents might be created outside the parse() function """
    try:
        ievent.args = ievent.txt.split()[1:]
    except ValueError:
        ievent.args = []
    try:
        cmnd, ievent.rest = ievent.txt.split(' ', 1)
    except ValueError:
        ievent.rest = ""
    ievent.command = ievent.txt.split(' ')[0]

class Ircevent(object):

    """ represents an IRC event """
    
    def __init__(self, ievent=None):
        self.jabber = False
        self.groupchat = False
        self.cmnd = None
        self.prefix = ""
        self.postfix = ""
        self.target = ""
        self.arguments = []
        self.nick = ""
        self.user = ""
        self.ruserhost = ""
        self.userhost = ""
        self.stripped = ""
        self.resource = ""
        self.channel = ""
        self.origtxt = ""
        self.txt = ""
        self.command = ""
        self.alias = ""
        self.aliased = ""
        self.time = time.time()
        self.msg = False
        self.args = []
        self.rest = ""
        self.usercmnd = 0
        self.bot = None
        self.sock = None
        self.inqueue = None
        self.queues = []
        self.printto = None
        self.speed = 5
        self.options = []
        self.groups = None
        self.cc = ""
        self.jid = None
        self.jidchange = None
        self.conn = None
        self.to = None
        self.denied = False
        if ievent:
            self.copyin(ievent)

    def copyin(self, ievent):
        """ copy ievent """
        self.cmnd = str(ievent.cmnd)
        self.prefix = str(ievent.prefix)
        self.postfix = str(ievent.postfix)
        self.target = str(ievent.target)
        self.arguments = list(ievent.arguments)
        self.nick = str(ievent.nick)
        self.user = str(ievent.user)
        self.ruserhost = str(ievent.ruserhost)
        self.userhost = str(ievent.userhost)
        self.stripped = str(ievent.stripped)
        self.resource = str(ievent.resource)
        self.channel = str(ievent.channel)
        self.origtxt = str(ievent.origtxt)
        self.txt = str(ievent.txt)
        self.command = str(ievent.command)
        self.alias = str(ievent.alias)
        self.aliased = str(ievent.aliased)
        self.time = ievent.time
        self.msg = ievent.msg
        self.args = list(ievent.args)
        self.rest = str(ievent.rest)
        self.usercmnd = ievent.usercmnd
        self.bot = ievent.bot
        self.sock = ievent.sock
        self.printto = ievent.printto
        self.speed = int(ievent.speed)
        self.inqueue = ievent.inqueue
        self.queues = list(ievent.queues)
        self.options = list(ievent.options)
        self.cc = str(ievent.cc)
        self.jid = ievent.jid
        self.jidchange = ievent.jidchange
        self.conn = ievent.conn
        self.to = ievent.to
        self.denied = ievent.denied

    def __str__(self):
        return "cmnd=%s prefix=%s postfix=%s arguments=%s nick=%s user=%s \
userhost=%s channel=%s txt=%s command=%s args=%s rest=%s speed=%s" % \
(self.cmnd, self.prefix, self.postfix, self.arguments, self.nick, self.user, \
self.userhost, self.channel, self.txt, self.command, self.args, self.rest, \
self.speed)

    def parse(self, bot, rawstr):
        """ parse raw string into ircevent """
        rawstr = todefenc(rawstr.rstrip())
        splitted = re.split('\s+', rawstr)
        # check if there is a prefix (: in front)
        if rawstr[0] == ':':
            self.prefix = splitted[0][1:]
            self.cmnd = splitted[1]
            # get nick/userhost
            nickuser = self.prefix.split('!')
            if len(nickuser) == 2:
                self.nick = nickuser[0]
                self.userhost = nickuser[1]
        else:
            # no prefix .. 1st word is command
            self.cmnd = splitted[0]
            # rest is arguments
            self.arguments = splitted[1:]
            go = False
            for i in self.arguments:
                if i.startswith(':'):
                    go = True
                    self.txt += "%s " % i[1:]
                    continue
                if go:
                    self.txt += "%s " % i
            # check if argument is txt
            #if self.arguments and self.arguments[0].startswith(':'):
            #    self.txt = ' '.join(self.arguments)[1:]
            rlog(0, 'ircevent',"%s %s %s" % (self.cmnd, self.arguments, \
self.txt))
            return self
        # get argument count so we can determine arguments and possible txt
        if pfc.has_key(self.cmnd):
            self.arguments = splitted[2:pfc[self.cmnd]+2]
            txtsplit = re.split('\s+', rawstr, pfc[self.cmnd]+2)
            self.txt = txtsplit[-1]
            #self.txt = ' '.join(splitted[pfc[self.cmnd]+2:])
        else:
            self.arguments = splitted[2:]
        # 1st argument is target
        if self.arguments:
            self.target = self.arguments[0]
        self.postfix = ' '.join(self.arguments)
        # check if target is text
        if self.target and self.target.startswith(':'):
            self.txt = ' '.join(self.arguments)
        # strip strarting ':' from txt
        if self.txt:
            if self.txt[0] == ":":
                self.txt = self.txt[1:]
        rlog(0, 'ircevent',"%s %s %s" % (self.cmnd, self.arguments, self.txt))
        # determine channel
        if self.cmnd == 'PRIVMSG':
            self.channel = self.arguments[0]
        elif self.cmnd == 'JOIN' or self.cmnd == 'PART':
            if self.txt:
                self.channel = self.txt
            else:
                self.channel = self.arguments[0]
        elif self.cmnd == 'MODE':
            self.channel = self.arguments[0]
        elif self.cmnd == 'TOPIC':
            self.channel = self.arguments[0]
        elif self.cmnd == 'KICK':
            self.channel = self.arguments[0]
        elif self.cmnd == '353':
            self.channel = self.arguments[2]
        elif self.cmnd == '324':
            self.channel = self.arguments[1]
        self.channel = self.channel.lower()
        if self.userhost:
            # userhost before possible stripident
            self.ruserhost = self.userhost
            self.userhost = stripident(self.userhost)
            # jabber compat .. this is userhost on irc
            self.stripped = self.userhost
            # determine user
            self.user = self.userhost.split('@')[0]
        self.origtxt = str(self.txt)
        self.channel = self.channel.strip()
        rlog(-1, 'ircevent', str(self))
        return self

    def reply(self, txt, result=None, nick=None, dot=False, nritems=False, \
nr=False):
        """ reply txt .. first check if queue then if DCC then /msg 
            otherwise assume channel
        """
        if result == []:
            return
        lt = False
        if type(txt) == types.ListType and not result:
            result = txt
            origtxt = ""
            lt = True
        else:
            origtxt = txt
        if result:
            lt = True
        if self.queues:
            for i in self.queues:
                if lt:
                    for j in result:
                        i.put_nowait(j)
                else:
                    i.put_nowait(txt)
            return
        if not self.bot:
            rlog(10, 'irc', 'no bot defined in ircevent')
            return
        pretxt = origtxt
        restxt = ""
        if lt:
            if nritems:
                if len(result) > 1:
                    pretxt += "(%s items) .. " % len(result)
            txtlist = [fix_format(str(i)) for i in result]
            if not nr is False:
                try:
                    start = int(nr)
                except ValueError:
                    start = 0
                txtlist2 = []
                teller = start
                for i in txtlist:
                    txtlist2.append("%s) %s" % (teller, i))
                    teller += 1
                txtlist = txtlist2
            if dot == True:
                restxt = ' .. '.join(txtlist)
            elif dot:
                restxt = dot.join(txtlist)
            else:
                restxt = ' '.join(txtlist)
        if pretxt:
            restxt = todefenc(pretxt) + todefenc(restxt)
        if self.cmnd == 'DCC' and self.sock:
            self.bot.say(self.sock, restxt, speed=self.speed)
            return
        if nick:
            self.bot.say(nick, restxt, fromm=nick, speed=self.speed)
            return
        if self.msg:
            self.bot.say(self.nick, restxt, fromm=self.nick, speed=self.speed)
            return
        if self.printto:
            self.bot.say(self.printto, restxt, fromm=self.nick, \
speed=self.speed)
            return
        else:
            # check if bot is in silent mode .. if so use /msg 
            try:
                silent = self.bot.channels[self.channel]['silent']
                if silent:
                    self.bot.say(self.nick, restxt, fromm=self.nick, speed=\
self.speed)
                    return
            except KeyError:
                pass
            self.bot.say(self.channel, restxt, fromm=self.nick, \
speed=self.speed)

    def missing(self, txt):
        """ show what arguments are missing """
        if self.origtxt:
            splitted = self.origtxt.split()
            if self.bot.nick in splitted[0]:
                try:
                    cmnd = splitted[1]
                except IndexError:
                    cmnd = splitted[0]
            elif 'cmnd' in splitted[0]:
                try:
                    cmnd = splitted[2]
                except IndexError:
                    cmnd = splitted[0]
            else:
                if self.msg:
                    cmnd = splitted[0]
                else:
                    if self.aliased:
                        cmnd = self.aliased
                    else:
                        cmnd = splitted[0][1:]
            self.reply(cmnd + ' ' + txt)
        else:
            self.reply('missing origtxt: %s' % txt)

# postfix count aka how many arguments

pfc = {}
pfc['NICK'] = 0
pfc['QUIT'] = 0
pfc['SQUIT'] = 1
pfc['JOIN'] = 0
pfc['PART'] = 1
pfc['TOPIC'] = 1
pfc['KICK'] = 2
pfc['PRIVMSG'] = 1
pfc['NOTICE'] = 1
pfc['SQUERY'] = 1
pfc['PING'] = 0
pfc['ERROR'] = 0
pfc['AWAY'] = 0
pfc['WALLOPS'] = 0
pfc['INVITE'] = 1
pfc['001'] = 1
pfc['002'] = 1
pfc['003'] = 1
pfc['004'] = 4
pfc['005'] = 15
pfc['302'] = 1
pfc['303'] = 1
pfc['301'] = 2
pfc['305'] = 1
pfc['306'] = 1
pfc['311'] = 5
pfc['312'] = 3
pfc['313'] = 2
pfc['317'] = 3
pfc['318'] = 2
pfc['319'] = 2
pfc['314'] = 5
pfc['369'] = 2
pfc['322'] = 3
pfc['323'] = 1
pfc['325'] = 3
pfc['324'] = 4
pfc['331'] = 2
pfc['332'] = 2
pfc['341'] = 3
pfc['342'] = 2
pfc['346'] = 3
pfc['347'] = 2
pfc['348'] = 3
pfc['349'] = 2
pfc['351'] = 3
pfc['352'] = 7
pfc['315'] = 2
pfc['353'] = 3
pfc['366'] = 2
pfc['364'] = 3
pfc['365'] = 2
pfc['367'] = 2
pfc['368'] = 2
pfc['371'] = 1
pfc['374'] = 1
pfc['375'] = 1
pfc['372'] = 1
pfc['376'] = 1
pfc['381'] = 1
pfc['382'] = 2
pfc['383'] = 5
pfc['391'] = 2
pfc['392'] = 1
pfc['393'] = 1
pfc['394'] = 1
pfc['395'] = 1
pfc['262'] = 3
pfc['242'] = 1
pfc['235'] = 3
pfc['250'] = 1
pfc['251'] = 1
pfc['252'] = 2
pfc['253'] = 2
pfc['254'] = 2
pfc['255'] = 1
pfc['256'] = 2
pfc['257'] = 1
pfc['258'] = 1
pfc['259'] = 1
pfc['263'] = 2
pfc['265'] = 1
pfc['266'] = 1
pfc['401'] = 2
pfc['402'] = 2
pfc['403'] = 2
pfc['404'] = 2
pfc['405'] = 2
pfc['406'] = 2
pfc['407'] = 2
pfc['408'] = 2
pfc['409'] = 1
pfc['411'] = 1
pfc['412'] = 1
pfc['413'] = 2
pfc['414'] = 2
pfc['415'] = 2
pfc['421'] = 2
pfc['422'] = 1
pfc['423'] = 2
pfc['424'] = 1
pfc['431'] = 1
pfc['432'] = 2
pfc['433'] = 2
pfc['436'] = 2
pfc['437'] = 2
pfc['441'] = 3
pfc['442'] = 2
pfc['443'] = 3
pfc['444'] = 2
pfc['445'] = 1
pfc['446'] = 1
pfc['451'] = 1
pfc['461'] = 2
pfc['462'] = 1
pfc['463'] = 1
pfc['464'] = 1
pfc['465'] = 1
pfc['467'] = 2
pfc['471'] = 2
pfc['472'] = 2
pfc['473'] = 2
pfc['474'] = 2
pfc['475'] = 2
pfc['476'] = 2
pfc['477'] = 2
pfc['478'] = 3
pfc['481'] = 1
pfc['482'] = 2
pfc['483'] = 1
pfc['484'] = 1
pfc['485'] = 1
pfc['491'] = 1
pfc['501'] = 1
pfc['502'] = 1
