# tests/test_dig.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
import unittest

plugins.reload('gozerplugs.plugs', 'dig')

class test_dig(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.channels['#test'] = {}
    
    def test_dig(self):
        result = self.b.test('dig')
        self.assert_(stringinlist('<domain>', result))

    def test_dig2(self):
        result = self.b.test('dig casccac MX')
        self.assert_(stringinlist('no result', result))

    def test_dig3(self):
        result = self.b.test('dig gozerbot.org A')
        self.assert_(stringinlist('213.196.7.59', result))
