
/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * interface for create_display
 * $Log: display_interface.c,v $
 * Revision 1.10  2006/01/31 14:28:12  gerber
 * version 0.3.0
 *
 * Revision 1.9  2005/06/15 15:03:54  gerber
 * Optional Anti Aliased canvas for viewer
 *
 * Revision 1.8  2005/06/15 09:40:40  gerber
 * debugged, optimized
 *
 * Revision 1.7  2005/01/19 15:53:41  gerber
 * Initiation of Data Acquisition (DAC); trigerring of lasers and camera
 * by using RTAI and Realtime Linux, recording images from IEEE1394
 * (Firewire) IIDC compliant camera's
 *
 * Revision 1.6  2004/10/15 19:24:05  gerber
 * GPIV_ and Gpiv prefix to defines and structure names of libgpiv
 *
 * Revision 1.5  2004/06/14 21:19:23  gerber
 * Image depth up to 16 bits.
 * Improvement "single int" and "drag int" in Eval tab.
 * Viewer's pop-up menu.
 * Adaption for gpiv_matrix_* and gpiv_vector_*.
 * Resizing console.
 * See Changelog for further info.
 *
 * Revision 1.4  2003/09/01 11:17:14  gerber
 * improved monitoring of interrogation process
 *
 * Revision 1.3  2003/07/04 10:47:01  gerber
 * cleaning up
 *
 * Revision 1.2  2003/06/27 13:47:26  gerber
 * display ruler, line/point evaluation
 *
 * Revision 1.1.1.1  2003/06/17 17:10:52  gerber
 * Imported gpiv
 *
 */

#include "gpiv_gui.h"
#include "utils.h"
#include "display_interface.h"
#include "display_menus.h"
#include "display.h"

/* #define RULERS */
#ifdef RULERS
#define EVENT_METHOD(i, x) GTK_WIDGET_GET_CLASS(i)->x
#endif


Display *
create_display(gchar * fname, 
	       gint display_id,
	       GpivConsole * gpiv
	       )
/*-----------------------------------------------------------------------------
 */
{

    Display *disp = g_new0 (Display,
			   1);
    static gint width = 0, height = 0;
    static gchar title[GPIV_MAX_CHARS];

    snprintf (title,
	     GPIV_MAX_CHARS,
	     "gpiv display #%d",
	     display_id);

    snprintf (disp->msg_display_default,
	     GPIV_MAX_CHARS,
	     "%s",
	     fname);

    disp->id = display_id;
    disp->zoom_index = gpiv_par.zoom_index;
    disp->zoom_factor = zfactor[disp->zoom_index];
    disp->vector_scale = gpiv_par.vector_scale;
    disp->vector_color = gpiv_par.vector_color;
    disp->display_img1 = gpiv_par.display_img1;
    disp->display_img2 = gpiv_par.display_img2;
    disp->display_intregs = gpiv_par.display_intregs;
    disp->display_piv = gpiv_par.display_piv;
    disp->display_vor = gpiv_par.display_vor;
    disp->display_sstrain = gpiv_par.display_sstrain;
    disp->display_nstrain = gpiv_par.display_nstrain;

    disp->img.exist_img = FALSE;
    disp->img.rgb_img_width = 0;
    disp->img.img_mean = 0.0;

/*
 * PIV data and related do not exist, yet. 'Saved' is set TRUE to avoid
 * message of unsaved data while deleting display or console
 * Values of these boolean variables are updated in the 'exec_' functions.
 */ 
    disp->intreg.exist_int = FALSE;
    disp->gpd.exist_piv = FALSE;
    disp->gpd.saved_piv = TRUE;
    disp->gpd.scaled_piv = FALSE;
    disp->gpd.exist_histo = FALSE;
    disp->gpd.saved_histo = TRUE;
    disp->gpd.exist_valid = FALSE;
    disp->gpd.exist_vor = FALSE;
    disp->gpd.exist_vor_scaled = FALSE;
    disp->gpd.saved_vor = TRUE;
    disp->gpd.exist_sstrain = FALSE;
    disp->gpd.exist_sstrain_scaled = FALSE;
    disp->gpd.saved_sstrain = TRUE;
    disp->gpd.exist_nstrain = FALSE;
    disp->gpd.exist_nstrain_scaled = FALSE;
    disp->gpd.saved_nstrain = TRUE;



    width = (gint) (disp->zoom_factor * gpiv_par.img_width + VIEW_HMARGE);
    height = (gint) (disp->zoom_factor * gpiv_par.img_height + VIEW_VMARGE);
/*     disp->mwin = g_object_new (GTK_TYPE_WINDOW, */
/* 			       "default-height", height, */
/* 			       "default-width", width, */
/* 			       "title", title, */
/* 			       NULL */
/* 			       ); */

    disp->mwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (disp->mwin), title);
/*     gtk_window_set_default_size (GTK_WINDOW (disp->mwin), width, height); */
    gtk_window_set_default_size (GTK_WINDOW (disp->mwin), 20, 20);
    gtk_object_set_data (GTK_OBJECT (disp->mwin), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (disp->mwin), 
			"gpiv", 
			gpiv);

/*
 * DESTROING ITEM
 */
    g_signal_connect (GTK_OBJECT (disp->mwin), 
			"delete_event" ,
			G_CALLBACK (delete_display),
			NULL);

/*
 * focussing the actual display
 */
    g_signal_connect (GTK_OBJECT (disp->mwin),
		       "focus_in_event",
		       G_CALLBACK (on_display_set_focus),
		       NULL);
    gtk_window_set_resizable (GTK_WINDOW (disp->mwin), FALSE);



    disp->vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (disp->vbox);
    gtk_container_add (GTK_CONTAINER (disp->mwin), disp->vbox);
    
/*
 * table
 */
    disp->table = gtk_table_new (2,
				 3,
				 FALSE);
    gtk_widget_ref (disp->table);
    gtk_object_set_data_full (GTK_OBJECT (disp->mwin),
			     "table",
			     disp->table,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (disp->table);
/*     gtk_container_add (GTK_CONTAINER (disp->mwin), */
/* 		      disp->table); */
    gtk_box_pack_start (GTK_BOX (disp->vbox),
		       disp->table,
		       TRUE,
		       TRUE,
		       0);
/*
 * rulers
 */
#undef RULERS
#ifdef RULERS
/* #define EVENT_METHOD(i, x) GTK_WIDGET_CLASS(GTK_OBJECT(i)->klass)->x */

    disp->hruler = gtk_hruler_new();
    gtk_widget_ref(disp->hruler);
    gtk_object_set_data_full(GTK_OBJECT(disp->mwin),
			     "hruler",
			     disp->hruler,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (disp->hruler);
    gtk_table_attach (GTK_TABLE (disp->table),
		     disp->hruler,
		     1,
		     2,
		     0,
		     1,
		     (GtkAttachOptions) (GTK_EXPAND/*  | GTK_FILL */),
		     (GtkAttachOptions) (GTK_FILL),
		     0,
		     0);

    gtk_ruler_set_range (GTK_RULER (disp->hruler),
			0.0,
			 (gfloat) (gpiv_par.img_width - 1),
			0.0,
			 (gfloat) (gpiv_par.img_width - 1));
    gtk_widget_set_size_request (disp->hruler,
				 (gint) (disp->zoom_factor * 
					 gpiv_par.img_width),
				 RULER_WIDTH);
    gtk_widget_set_uposition (disp->hruler, RULER_WIDTH, 0);



    disp->vruler = gtk_vruler_new ();
    gtk_widget_ref (disp->vruler);
    gtk_object_set_data_full (GTK_OBJECT (disp->mwin),
			     "vruler",
			     disp->vruler,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (disp->vruler);
    gtk_table_attach (GTK_TABLE (disp->table),
		     disp->vruler,
		     0,
		     1,
		     1,
		     2,
		     (GtkAttachOptions) (GTK_EXPAND /* GTK_FILL */),
		     (GtkAttachOptions) (GTK_EXPAND /* | GTK_FILL */),
		     0,
		     0);

   gtk_ruler_set_range (GTK_RULER (disp->vruler),
			0.0,
			 (gfloat) (gpiv_par.img_height - 1),
			0.0,
			 (gfloat) (gpiv_par.img_height - 1));
   gtk_widget_set_size_request (disp->vruler,
				RULER_WIDTH,
				(gint) (disp->zoom_factor * 
					gpiv_par.img_height));
   gtk_widget_set_uposition (disp->vruler, 0, RULER_WIDTH);

#endif /* RULERS */
/*
 * scrolledwindow
 */
    disp->scrolledwindow = gtk_scrolled_window_new (NULL,
						   NULL);
    gtk_widget_ref (disp->scrolledwindow);
    gtk_object_set_data_full (GTK_OBJECT (disp->mwin),
			     "scrolledwindow",
			     disp->scrolledwindow,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (disp->scrolledwindow);
    gtk_table_attach (GTK_TABLE (disp->table),
		     disp->scrolledwindow,
		     1,
		     2,
		     1,
		     2,
		     (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		     (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		     0,
		     0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
				   (disp->scrolledwindow),
				   GTK_POLICY_ALWAYS,
				   GTK_POLICY_ALWAYS);

/*     gtk_widget_set_size_request (disp->scrolledwindow,  */
/* 			  gpiv_par.img_width,  */
/* 			  gpiv_par.img_height); */


    disp->scrolledwindow_hadj =
	gtk_adjustment_new (0.0,
			   0.0,
			   (gfloat) gpiv_par.img_width, 
			   5.0, 
			   50.0,
			   50.0);
    gtk_scrolled_window_set_hadjustment (GTK_SCROLLED_WINDOW
					 (disp->scrolledwindow),
					GTK_ADJUSTMENT
					 (disp->scrolledwindow_hadj));
    gtk_object_set_data (GTK_OBJECT (disp->scrolledwindow_hadj),
			"var_type",
			"0");
    gtk_object_set_data (GTK_OBJECT (disp->scrolledwindow_hadj),
			"disp",
			disp);
#ifdef RULERS
    g_signal_connect (GTK_OBJECT (disp->scrolledwindow_hadj),
		       "value_changed",
		       G_CALLBACK
		       (on_scrolledwindow_display_adj_changed),
		       NULL);
#endif

    disp->scrolledwindow_vadj =
	gtk_adjustment_new (0.0,
			   0.0, 
			   (gfloat) gpiv_par.img_height,
			   5.0,
			   50.0,
			   50.0);
    gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW
					 (disp->scrolledwindow),
					GTK_ADJUSTMENT
					 (disp->scrolledwindow_vadj));
    gtk_object_set_data (GTK_OBJECT (disp->scrolledwindow_vadj),
			"var_type",
			"1");
    gtk_object_set_data (GTK_OBJECT (disp->scrolledwindow_vadj),
			"disp",
			disp);
#ifdef RULERS
    g_signal_connect (GTK_OBJECT (disp->scrolledwindow_vadj),
		       "value_changed",
		       G_CALLBACK
		       (on_scrolledwindow_display_adj_changed),
		       NULL);
#endif
/*
 * gnome canvas
 */
/* #define CANVAS_AA */
#ifdef CANVAS_AA
    gtk_widget_push_visual (gdk_rgb_get_visual ());
    gtk_widget_push_colormap (gdk_rgb_get_cmap ());
    disp->canvas = gnome_canvas_new_aa ();

#else
    gtk_widget_push_visual (gdk_imlib_get_visual ());
    gtk_widget_push_colormap (NULL);
    disp->canvas = gnome_canvas_new ();

#endif
    gtk_widget_pop_colormap ();
    gtk_widget_pop_visual ();
    gtk_widget_ref (disp->canvas);
    gtk_widget_set_events (GTK_WIDGET (disp->canvas),
			  GDK_LEAVE_NOTIFY_MASK |
			  GDK_BUTTON_PRESS_MASK | 
/* 			  GDK_2BUTTON_PRESS_MASK |  */
			  GDK_BUTTON_RELEASE_MASK |
			  GDK_POINTER_MOTION_MASK |
			  GDK_POINTER_MOTION_HINT_MASK |
			  GDK_SHIFT_MASK);

    gtk_object_set_data_full (GTK_OBJECT (disp->mwin), 
			     "canvas",
			     disp->canvas,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (disp->canvas);
    gnome_canvas_set_scroll_region (GNOME_CANVAS (disp->canvas), 
				   0, 
				   0,
				   gpiv_par.img_width - 1, 
				   gpiv_par.img_height - 1);
    gtk_container_add (GTK_CONTAINER (disp->scrolledwindow), 
		      disp->canvas);


    gtk_object_set_data (GTK_OBJECT (disp->canvas), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (disp->canvas), 
			"gpiv", 
			gpiv);


    g_signal_connect (G_OBJECT (disp->canvas), 
		       "enter_notify_event",
		       G_CALLBACK (canvas_display_enter_notify), 
		       NULL);
    g_signal_connect (G_OBJECT (disp->canvas), 
		       "motion_notify_event",
		       G_CALLBACK (canvas_display_motion_notify), 
		       NULL);    
    g_signal_connect (G_OBJECT (disp->canvas), 
		       "button_press_event",
		       G_CALLBACK (canvas_display_button_press), 
		       NULL);    
    g_signal_connect (G_OBJECT (disp->canvas), 
		       "button_release_event",
		       G_CALLBACK (canvas_display_button_release),
		       NULL);
    g_signal_connect (G_OBJECT (disp->canvas), 
		       "leave_notify_event",
		       G_CALLBACK (canvas_display_leave_notify), 
		       NULL);

#ifdef RULERS
/*
 * connect rulers to gnome_canvas drawing area
 */
    g_signal_connect_swapped (disp->canvas, 
			      "motion_notify_event",
			      G_CALLBACK (GTK_WIDGET_GET_CLASS (disp->hruler)->motion_notify_event),
			      disp->hruler);
    g_signal_connect_swapped (G_OBJECT (disp->canvas),
			      "motion_notify_event",
			      G_CALLBACK (GTK_WIDGET_GET_CLASS (disp->vruler)->motion_notify_event),
			      G_OBJECT (disp->vruler));
#endif /* RULERS */

/* 
 * application/status bar
 */
    disp->appbar = gnome_appbar_new (FALSE,
				    TRUE,
				    GNOME_PREFERENCES_NEVER);
    gtk_widget_ref (disp->appbar);
    gtk_object_set_data_full (GTK_OBJECT (disp->mwin),
			     "appbar",
			     disp->appbar,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (disp->appbar);
    gtk_table_attach (GTK_TABLE (disp->table),
		     disp->appbar,
		     0,
		     2, 
		     2, 
		     3,
		     (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		     (GtkAttachOptions) (GTK_FILL),
		     0,
		     0);
    gnome_appbar_set_default (GNOME_APPBAR (disp->appbar),
			     disp->msg_display_default);

    return disp;
}



GtkWidget  *
create_display_menu (Display * disp
		    )
/*-----------------------------------------------------------------------------
 */
{
    GtkWidget *display_menu = NULL;

    display_menu = gtk_menu_new ();
    gtk_object_set_data (GTK_OBJECT (disp->mwin), 
			"display_menu",
			display_menu);
    gnome_app_fill_menu (GTK_MENU_SHELL (display_menu), 
			display_menu_uiinfo,
			NULL,
			FALSE,
			0);


/*
 * background menu widgets
 */
    gtk_widget_ref (view_background_display[0].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_blue",
			     view_background_display[0].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_BG_DARKBLUE) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_background_display[0].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_background_display[0].widget), 
			"disp", 
			disp);



    gtk_widget_ref (view_background_display[1].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_black",
			     view_background_display[1].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_BG_BLACK) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_background_display[1].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_background_display[1].widget), 
			"disp", 
			disp);



    gtk_widget_ref (view_background_display[2].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_img1",
			     view_background_display[2].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_BG_IMG1) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_background_display[2].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_background_display[2].widget), 
			"disp", 
			disp);



    gtk_widget_ref (view_background_display[3].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_img2",
			     view_background_display[3].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_BG_IMG2) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_background_display[3].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_background_display[3].widget), 
			"disp", 
			disp);


/*
 * view menu widgets to display PIV data and interrrogation area's
 */
    gtk_widget_ref (view_piv_display[0].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_intreg",
			     view_piv_display[0].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_object_set_data (GTK_OBJECT (disp->mwin),
			"view_piv_display0",
                        view_piv_display[0].widget);
    if (disp->display_intregs) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_piv_display[0].widget),
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_piv_display[0].widget),
			"disp",
                        disp);


   gtk_widget_ref (view_piv_display[1].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_piv",
			     view_piv_display[1].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (disp->display_piv) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_piv_display[1].widget),
				       TRUE);
    } else {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_piv_display[1].widget),
				       FALSE);
    }
    gtk_object_set_data (GTK_OBJECT (disp->mwin),
			"view_piv_display1",
                        view_piv_display[1].widget);

/*
 * Display scalar data
 */
    gtk_widget_ref (view_scalardata_display[0].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_none",
			     view_scalardata_display[0].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_SC_NONE) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_scalardata_display[0].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_scalardata_display[0].widget), 
			"disp", 
			disp);



    gtk_widget_ref (view_scalardata_display[1].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_vor",
			     view_scalardata_display[1].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_SC_VORTICITY) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_scalardata_display[1].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_scalardata_display[1].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (disp->mwin),
			"view_scalardata_display1",
                        view_scalardata_display[1].widget);



    gtk_widget_ref (view_scalardata_display[2].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_sstrain",
			     view_scalardata_display[2].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_SC_SSTRAIN) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_scalardata_display[2].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_scalardata_display[2].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (disp->mwin),
			"view_scalardata_display2",
                        view_scalardata_display[2].widget);



    gtk_widget_ref (view_scalardata_display[3].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "view_nstrain",
			     view_scalardata_display[3].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.background == SHOW_SC_NSTRAIN) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (view_scalardata_display[3].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (view_scalardata_display[3].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (disp->mwin),
			"view_scalardata_display3",
                        view_scalardata_display[3].widget);

/*
 * zoom menu widgets
 */
    gtk_widget_ref (zoomscale_menu_display[0].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "zmv_0",
			     zoomscale_menu_display[0].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (disp->zoom_index == ZOOM_0) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (zoomscale_menu_display[0].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[0].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[0].widget), 
			"zoom_index",
			"0");



    gtk_widget_ref (zoomscale_menu_display[1].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "zmv_1",
			     zoomscale_menu_display[1].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (disp->zoom_index == ZOOM_1) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (zoomscale_menu_display[1].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[1].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[1].widget), 
			"zoom_index",
			"1");



    gtk_widget_ref (zoomscale_menu_display[2].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "zmv_2",
			     zoomscale_menu_display[2].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (disp->zoom_index == ZOOM_2) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (zoomscale_menu_display[2].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[2].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[2].widget), 
			"zoom_index",
			"2");



    gtk_widget_ref (zoomscale_menu_display[3].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "zmv_3",
			     zoomscale_menu_display[3].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (disp->zoom_index == ZOOM_3) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (zoomscale_menu_display[3].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[3].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[3].widget), 
			"zoom_index",
			"3");



    gtk_widget_ref (zoomscale_menu_display[4].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "zmv_4",
			     zoomscale_menu_display[4].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (disp->zoom_index == ZOOM_4) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (zoomscale_menu_display[4].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[4].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[4].widget), 
			"zoom_index",
			"4");



    gtk_widget_ref (zoomscale_menu_display[5].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "zmv_5",
			     zoomscale_menu_display[5].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (disp->zoom_index == ZOOM_5) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (zoomscale_menu_display[5].widget), 
				       TRUE);
    }
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[5].widget), 
			"disp", 
			disp);
    gtk_object_set_data (GTK_OBJECT (zoomscale_menu_display[5].widget),
			"zoom_index",
			"5");


/*
 * vectorscale menu widgets
 */
    gtk_widget_ref (vectorscale_menu_display[0].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_0",
			     vectorscale_menu_display[0].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 1) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[0].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[1].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_1",
			     vectorscale_menu_display[1].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 2) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[1].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[2].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_2",
			     vectorscale_menu_display[2].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 4) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[2].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[3].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_3",
			     vectorscale_menu_display[3].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 8) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[3].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[4].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_4",
			     vectorscale_menu_display[0].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 16) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[4].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[5].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_0",
			     vectorscale_menu_display[5].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 32) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[5].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[6].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_6",
			     vectorscale_menu_display[6].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 64) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[6].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[7].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_7",
			     vectorscale_menu_display[7].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 128) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[7].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorscale_menu_display[8].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vs_mv_8",
			     vectorscale_menu_display[8].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_scale == 256) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorscale_menu_display[8].widget), 
				       TRUE);
    }


/*
 * vectorcolor menu widgets
 */
    gtk_widget_ref (vectorcolor_menu_display[0].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vc_mv_0",
			     vectorcolor_menu_display[0].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_color == SHOW_PEAKNR) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorcolor_menu_display[0].widget), 
				       TRUE);
    }



     gtk_widget_ref (vectorcolor_menu_display[1].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vc_mv_1",
			     vectorcolor_menu_display[1].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_color == SHOW_SNR) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorcolor_menu_display[1].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorcolor_menu_display[2].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vc_mv_2",
			     vectorcolor_menu_display[2].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_color == SHOW_MAGNITUDE_GRAY) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorcolor_menu_display[2].widget), 
				       TRUE);
    }



    gtk_widget_ref (vectorcolor_menu_display[3].widget);
    gtk_object_set_data_full (GTK_OBJECT (display_menu),
			     "vc_mv_3",
			     vectorcolor_menu_display[3].widget,
			     (GtkDestroyNotify) gtk_widget_unref);
    if (gpiv_par.vector_color == SHOW_MAGNITUDE) {
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				       (vectorcolor_menu_display[3].widget), 
				       TRUE);
    }



   return display_menu;
}
