/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001 - 2006 Magnus Loef (Magnus-swe) <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_progressbars.h"
#include "make_settings_labels.h"
#include "make_settings_hseparators.h"
#include "generate_cert.h"
#include "create_server_settings.h"

extern int use_tls;
extern int use_ratio;



void create_server_settings(struct w *widgets)
{
    GtkTooltips *tooltips;
    GtkWidget *gen_cert_button;
    gchar *utf8 = NULL;
    gdouble progress_val = 1.0;
    gchar *combo_text;

    /* Counters for the widgets and positions in the table */
    int a = 0;
    int b = 1;
    int ent  = 0;
    int spin = 0;
    int comb = 0;

    /* Max lengths and input */
    int entry_size = 100;
    int combo_size = 100;

    tooltips = gtk_tooltips_new();


    /* The servers hostname or IP-Address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The servers IP-address or hostname: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("ftp.mydomain.org, 192.168.0.100 or 0.0.0.0 which means listen to all network interfaces"), NULL);
    a++; b++; ent++;

    /* Alternative server ident Label+Entry+Combo */
    widgets->server_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Alternative server identity: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("My FTP server or set it to off to have the server use its own name and version"), NULL);

    widgets->server_set_combo[comb] = make_combo(GTK_TABLE(widgets->srv_set_table), 1,2,a,b,combo_size);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; ent++; comb++;

    /* Nat router Label+Entry+Combo */
    widgets->server_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Configure NAT routing: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The public IP or DNS name of the NAT router, IE: router.mydomain.org or 192.168.0.100"), NULL);

    widgets->server_set_combo[comb] = make_combo(GTK_TABLE(widgets->srv_set_table), 1,2,a,b,combo_size);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; ent++; comb++;

    /* Email */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The administrators email address: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The administrators email address"), NULL);
    a++; b++; ent++;

    /* Identity lookups */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Use identity lookups: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Reverse lookups */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Use reverse lookups: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Time standard */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),_(" Time standard: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_combo[comb], _("GMT or local time"), NULL);
    combo_text = g_strdup_printf(_("GMT"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Local time"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Port */    
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Port: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The port the server listens on. 21 is the standard port. 0 means deactivated"), NULL);
    a++; b++; spin++;

    /* Passive ports */
    widgets->server_set_spinbutton[spin] = make_padded_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table), _(" Passive port range: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("From this port"), NULL);
    spin++;
    widgets->server_set_spinbutton[spin] = make_spinbutton(GTK_TABLE(widgets->srv_set_table), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("To this port"), NULL);
    a++; b++; spin++;

    /* Max connections */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Maximum connections: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The maximum simoultaneous connections for this server"), NULL);
    a++; b++; spin++;

    /* Maximum logins */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Maximum login tries: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The maximum number of logins a user can fail before disconnected"), NULL);
    a++; b++; spin++;

    /* Login timeout */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Login timeout: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The maximum time a user can spend authenticating"), NULL);
    a++; b++; spin++;

    /* Idle timeout */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Idle timeout: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The time it takes before an idle user is thrown out in seconds"), NULL);
    a++; b++; spin++;

    /* Transfer mode */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Transfer mode: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("Binary"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Ascii"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* FXP transfers */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" FXP transfers: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;



// The following should be added to a settings window....

    /* Randomized username length */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Randomized username length: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The length of the randomized usernames"), NULL);
    a++; b++; spin++;

    /* Randomized password length */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Randomized password length: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("The length of the randomized passwords"), NULL);
    a++; b++; spin++;

    /* Randomize case */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Randomize case: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("Upper"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Lower"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Default home directory */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Default home directory: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("This will be set as the users default home directory"), NULL);
    a++; b++; ent++;

    /* Default upload directory */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Default upload directory: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("This will be set as the users default upload directory"), NULL);
    a++; b++; ent++;

    /* Default statistics file */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Default HTML statistics filepath: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("This will be set as the default HTML statistics filepath, IE: /var/www/ftp.htm"), NULL);
    a++; b++; ent++;
// End should be added to a settings window.


    ent++; // Leave this, deleted the welcome entry


    /* The systems security logfile */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The systems security logfile: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("IE: /var/log/secure"), NULL);
    a++; b++; ent++;

    /* The server runs as this user */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this user: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The server drops its privileges and runs as this user, nobody is often used"), NULL);
    a++; b++; ent++;

    /* The server runs as this group */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this group: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The server drops its privileges and runs as this group, nobody is often used"), NULL);
    a++; b++; ent++;

    /* This fake user owns all files Label+Entry+Combo */
    widgets->server_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" This fake user owns all files: "),     0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("Doesnt have to be an existing user"), NULL);

    widgets->server_set_combo[comb] = make_combo(GTK_TABLE(widgets->srv_set_table), 1,2,a,b,combo_size);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; ent++; comb++;

    /* This fake group owns all files Label+Entry+Combo */
    widgets->server_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" This fake group owns all files: "),     0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("Doesnt have to be an existing group"), NULL);

    widgets->server_set_combo[comb] = make_combo(GTK_TABLE(widgets->srv_set_table), 1,2,a,b,combo_size);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; ent++; comb++;

    /* Upload speed */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Upload speed: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Total upload speed shared by all clients"), NULL);
    a++; b++; spin++;

    /* Download speed */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Download speed: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Total download speed shared by all clients"), NULL);
    a++; b++; spin++;

    /* Resume broken uploads */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Allow Resume of broken uploads: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Resume broken downloads */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Allow Resume of broken downloads: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Automatically remove aborted uploads */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Automatically remove aborted uploads: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* TLS Module settings begins here */
    if( use_tls )
    {
	/* A hseparator */
	make_3columns_hseparator(GTK_TABLE(widgets->srv_set_table), 0,1,a,b);
	a++; b++;
	
	/* FTP-TLS label */
	make_3columns_label(GTK_TABLE(widgets->srv_set_table), _(" FTP-TLS secure communications: "), 0,1,a,b);
	a++; b++;

	/* Use FTP-TLS secure communication */
	widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Use FTP-TLS secure communications: "), 0,1,a,b,50);
	combo_text = g_strdup_printf(_("On"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	combo_text = g_strdup_printf(_("Off"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	g_free(combo_text); g_free(utf8);
	a++; b++; comb++;

	/* Require encryption on channels */
	widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Require encryption on channels: "), 0,1,a,b,50);
	combo_text = g_strdup_printf(_("Both"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	combo_text = g_strdup_printf(_("Off"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	combo_text = g_strdup_printf(_("Data"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	combo_text = g_strdup_printf(_("Control"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	g_free(combo_text); g_free(utf8);
	a++; b++; comb++;

	/* Verify clients */
	widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Verify clients: "), 0,1,a,b,50);
	combo_text = g_strdup_printf(_("On"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	combo_text = g_strdup_printf(_("Off"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	g_free(combo_text); g_free(utf8);
	a++; b++; comb++;

	/* Use these protocols */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Use these protocols: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("IE: TLSv1"), NULL);
	a++; b++; ent++;

	/* The TLS logfile */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The TLS logfile: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("IE: /var/log/gproftpd_tls_site1.log"), NULL);
	a++; b++; ent++;

	/* A hseparator */
	make_3columns_hseparator(GTK_TABLE(widgets->srv_set_table), 0,1,a,b);
	a++; b++;
	
	/* The selfsigned certificate settings */
	make_3columns_label(GTK_TABLE(widgets->srv_set_table), _(" The selfsigned certificate settings: "), 0,1,a,b);
	a++; b++;

	/* The RSA certificate file */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The RSA certificate file: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("IE: /etc/gproftpd/gproftpd_site1.pem"), NULL);
	a++; b++; ent++;


	/* This servers DNS name or IP-Address */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" This servers DNS name or IP-Address: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("This servers DNS name or IP address"), NULL);
	a++; b++; ent++;

	/* Email address */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Email address: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The administrators email address"), NULL);
	a++; b++; ent++;

	/* State or province */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" State or province: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A state or a province"), NULL);
	a++; b++; ent++;

	/* City or town */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" City or town: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A city or a town"), NULL);
	a++; b++; ent++;

	/* Organization */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Organization: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("Some organization"), NULL);
	a++; b++; ent++;

	/* Organizational unit */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Organizational unit: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("Accounting"), NULL);
	a++; b++; ent++;

	/* Password */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Password: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A password"), NULL);
	a++; b++; ent++;

	/* Challenge password */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Challenge password: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("A challenge password"), NULL);
	a++; b++; ent++;

	/* Number of encryption bits (Min value = 384) */
	widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Number of encryption bits: "), 0,1,a,b,50);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Number of bits in the generated certificate"), NULL);
	gtk_spin_button_set_range(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[spin]), 384, 999999);
	a++; b++; spin++;

	/* Number of days the certificate is valid */
	widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Number of days the certificate is valid: "), 0,1,a,b,50);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin], _("Number of days the certificate is valid"), NULL);
	a++; b++; spin++;

	/* Countrycode */
	widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Country code IE: SV, DK, EN, US: "), 0,1,a,b,200);
	gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The country code"), NULL);
	a++; b++; ent++;

	/* A progress bar */
	widgets->gen_cert_progressbar = make_progressbar_with_label(GTK_TABLE(widgets->srv_set_table), _(" Generate a new selfsigned certificate: "), 0,1,a,b,200);
	gtk_widget_set_sensitive(widgets->gen_cert_progressbar, FALSE);

	/* The progress bar looks nicer if its blue from start */
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_cert_progressbar), progress_val);

	/* An apply button for the progress bar (make_button is in make_settings_progressbars.c) */
	gen_cert_button = make_button(GTK_TABLE(widgets->srv_set_table), 0,1,a,b,200);
	a++; b++;

	g_signal_connect_swapped(G_OBJECT(gen_cert_button), "clicked",
			 G_CALLBACK(generate_cert), widgets);	
    }




    /* RATIO Module settings begins here */
    if( use_ratio )
    {
	/* A hseparator */
	make_3columns_hseparator(GTK_TABLE(widgets->srv_set_table), 0,1,a,b);
	a++; b++;
	
	/* Ratio label */
	make_3columns_label(GTK_TABLE(widgets->srv_set_table), _(" Ratios for uploads and downloads: "), 0,1,a,b);
	a++; b++;

	/* Use Ratios */
	widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Use Ratios: "), 0,1,a,b,50);
	combo_text = g_strdup_printf(_("On"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	combo_text = g_strdup_printf(_("Off"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	g_free(combo_text); g_free(utf8);
	a++; b++; comb++;

	/* Save Ratios */
	widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Save Ratios: "), 0,1,a,b,50);
	combo_text = g_strdup_printf(_("On"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	combo_text = g_strdup_printf(_("Off"));
	utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
	gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
	g_free(combo_text); g_free(utf8);
	a++; b++; comb++;
    }


    gtk_widget_show_all(widgets->main_window);
}
