//====================================================
// Grande
// Copyright (C) 2002-2003, kacchan
// E-M@il address   ml@kxl.hn.org
// Homepage address http://kxl.hn.org
//====================================================
#include "grande.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>

struct {
  Sint16  ch; // ߤʸ
  Uint8  *cp; // ʸؤΥݥ
} CalcData;

struct {
  Uint8 c;    // ʸ
  Sint16 v;   // 
} chk[7] = {
  {'w', 0},
  {'h', 0},
  {'l', UP_LEFT},
  {'t', UP_TOP},
  {'r', UP_RIGHT},
  {'b', UP_BOTTOM},
  {'c', UP_LEFT + WIDTH / 2}
};

//========================================
// 
//========================================
Sint16 CalcNumber(void)
{
  Sint16 x, s;

  // ʸʤ
  if (CalcData.ch == '+' || CalcData.ch == '-') {
    s = CalcData.ch;
    CalcData.ch = *CalcData.cp ++;
  }
  // ʸͲ
  x = CalcData.ch - '0';
  while ((CalcData.ch = *CalcData.cp ++), isdigit(CalcData.ch))
    x = 10 * x + CalcData.ch - '0';
  // Ͳͤդ
  return (s == '-') ? -x : x;
}
//========================================
// 
//========================================
Sint16 CalcTerm(void)
{
  Sint16 x;

  // ʸͲ
  x = CalcNumber();
  // 軻ʸĤ֤ϼʸͲ軻
  for (;;) {
    if (CalcData.ch == '*') {
      CalcData.ch = *CalcData.cp ++;
      x *= CalcNumber();
    } else if (CalcData.ch == '/') {
      CalcData.ch = *CalcData.cp ++;
      x /= CalcNumber();
    } else break;
  }
  return x;
}

//========================================
// ɾ
//========================================
Sint16 CalcExpression(Uint8 *p)
{
  Sint16 x;
  
  CalcData.cp = p;
  CalcData.ch = *CalcData.cp ++;
  // ޤϤ˾軻뤫Ĵ٤
  x = CalcTerm();
  for (;;) {
    if (CalcData.ch == '+') {
      // ûʸʤ鼡ʸͲû
      CalcData.ch = *CalcData.cp ++;
      x += CalcTerm();
    } else if (CalcData.ch == '-') {
      // ʸʤ鼡ʸͲ
      CalcData.ch = *CalcData.cp ++;
      x -= CalcTerm();
    } else break;
  }
  return x;
}
//========================================
// Ѵ׻
//========================================
Sint16 Calc(KXL_Image *img, Uint8 *p)
{
  Uint8 buff[256] = "";
  Uint8 buff2[256] = "";
  Uint8 i;

  chk[0].v = img->Width;
  chk[1].v = img->Height;
  
  // ʸѴʤʸ
  while (*p) {
    for (i = 0; i < 7; i ++)
      if (*p == chk[i].c) {
        sprintf(buff, "%s%d", buff2, chk[i].v);
        break;
      }
    if (i == 7)
      sprintf(buff, "%s%c", buff2, *p);
    p ++;
    strcpy(buff2, buff);
  }
  // ׻ʸ׻
  return CalcExpression(buff);
}
