//====================================================
// Grande
// Copyright (C) 2002-2003, kacchan
// E-M@il address   ml@kxl.hn.org
// Homepage address http://kxl.hn.org
//====================================================
#include "grande.h"
#define _EXTERN_DEF_
#include "extern.h"

#define JS_DEV     "/dev/js0"
Bool gJoyok;

//========================================
// KXL
//========================================
void KXL(void)
{
  static KXL_Image *tmp;
  static Sint16 y, ay, max;
  static Uint16 w, h;
  static Bool flag = False;
  
  KXL_ClearFrameImm(UP_TOP, UP_LEFT, WIDTH, HEIGHT);
  if (Root->Cnt == 0) { // 
    // KXLɹ
    tmp = KXL_LoadBitmap(INST_PATH "/bmp/kxl.bmp", 0);
    // 襵
    w = tmp->Width;
    h = tmp->Height;
    // 
    y = UP_TOP - h;
    ay = 0;
    max = 19;
  }
  // ΥХɽ
  if (max) {
    if (flag == False) { // ˰ư
      ay ++;
      if (ay > max) { // ˰ư
        max /= 1.5;
        ay = -max;
        flag = True;
      }
    } else { // ˰ư
      if (ay) ay ++;
      else    flag = False;
    }
    y += ay;
  } else {
    if (Root->Cnt >= 110 && Root->Cnt <= 115) {
      // KXLΥХɤߤ礹
      if (Root->Cnt == 110)
        KXL_PlaySound(SE_MBOMB, KXL_SOUND_PLAY);
      w *= 1.13;
      h *= 1.13;
    } else if (Root->Cnt == 140) {
      // 礬ߤ齪λ
      KXL_DeleteImage(tmp);
      Root->MainFlag = MainOpening;
      return;
    }
  }
  // 
  if (Root->Cnt < 110)
    // Х
    KXL_PutStretchImage(tmp, w, h, UP_LEFT + (WIDTH - w) / 2, y);
  else
    // 
    KXL_PutStretchImage(tmp, w, h, UP_LEFT + (WIDTH - w) / 2, 
                        UP_TOP + (HEIGHT - h) / 2);
}

//========================================
// ᥤ롼ס٥ȥå
//========================================
void MainLoop(void)
{
  MainEnum bak = -1;
  KXL_Joystick jsev, jsbak;

  while (1) {
    // ޳Ԥ
    while (KXL_GetTimer() == False);
    // ޳ߥꥹ
    KXL_ResetTimer();
    // joystick
    if (gJoyok == True) {
      if (KXL_ReadJoystick(&jsev) == False)
	continue;
      if (memcmp(&jsev, &jsbak, sizeof(KXL_Joystick))) {
	jsbak = jsev;
	JoyConfig = jsev;
	if (jsev.x < 128) Root->Key |= KLeft;
	else Root->Key &= KLeftMask;
	if (jsev.x > 128) Root->Key |= KRight;
	else Root->Key &= KRightMask;
	
	if (jsev.y < 128) Root->Key |= KUp;
	else Root->Key &= KUpMask;
	if (jsev.y > 128) Root->Key |= KDown;
	else Root->Key &= KDownMask;
	
	if (jsev.buttons & JoyMainShot) Root->Key |= KShot;
	else Root->Key &= KShotMask;
	if (jsev.buttons & JoySubShot) Root->Key |= KSShot;
	else Root->Key &= KSShotMask;
	if (jsev.buttons & JoyChargeShot) Root->Key |= KCShot;
	else Root->Key &= KCShotMask;
	if (jsev.buttons & JoyPause) Root->Key |= KPause;
	else Root->Key &= KPauseMask;
	
	if (jsev.buttons & JoyExit) {
	  if (Root->MainFlag == MainKXL) break;
	  if (Root->MainFlag != MainOpening && Root->MainFlag != MainJoystick) {
	    UnLoadStageData();
	    Root->MainFlag = MainOpening;
	    Root->Cnt = 0;
	  }
	}
      }
    }

    // ٥ȥå
    while (KXL_CheckEvents()) {
      // ٥Ȥ
      switch (KXL_GetEvents()) {
      case KXL_EVENT_KEY_PRESS: // 򲡤
        // ɼ
        switch (KXL_GetKey()) {
        case KeyShot:  Root->Key |= KShot;  break;
        case KeySShot: Root->Key |= KSShot; break;
        case KeyCShot: Root->Key |= KCShot; break;
        case KeyLeft:  Root->Key |= KLeft;  break;
        case KeyRight: Root->Key |= KRight; break;
        case KeyUp:    Root->Key |= KUp;    break;
        case KeyDown:  Root->Key |= KDown;  break;
        case KeyPause: Root->Key |= KPause; break;
        case KeyQuit:
          if (Root->MainFlag == MainKXL) break;
	  if (Root->MainFlag != MainOpening && Root->MainFlag != MainJoystick) {
            UnLoadStageData();
            Root->MainFlag = MainOpening;
            Root->Cnt = 0;
          }
          break;
        default: break;
        }
        break;
      case KXL_EVENT_KEY_RELEASE: // Υ
        // ɼ
        switch (KXL_GetKey()) {
        case KeyShot:  Root->Key &= KShotMask;  break;
        case KeySShot: Root->Key &= KSShotMask; break;
        case KeyCShot: Root->Key &= KCShotMask; break;
        case KeyLeft:  Root->Key &= KLeftMask;  break;
        case KeyRight: Root->Key &= KRightMask; break;
        case KeyUp:    Root->Key &= KUpMask;    break;
        case KeyDown:  Root->Key &= KDownMask;  break;
        case KeyPause: Root->Key &= KPauseMask; break;
        default:                                break;
        }
        break;
      }
    }

    bak = Root->MainFlag;
    // ե饰ˤƽ¹Ԥ
    switch (Root->MainFlag) {
    case MainKXL: // KXL
      KXL();
      break;
    case MainOpening: // ˥塼
      if (Opening() == True) return;
      break;
    case MainJoystick: // 祤ƥåե
      ConfigJoystick();
      break;
    case MainStart: // ೫
      Start();
      break;
    case MainGame: // 
      Game(True);
      // ݡå
      if (Root->Key & KPause) Root->MainFlag = MainPause;
      break;
    case MainPause: // 
      Game(False);
      // ݡå
      Root->MainFlag = (Root->Key & KShot) ? MainGame : MainPause;
      break;
    case MainClear: // ơꥢ
      Game(True);
      ClearAndGameOver();
      break;
    case MainGameOver: // ४С
      Game(True);
      ClearAndGameOver();
      break;
    case MainEnding: // ǥ
      break;
    }
    if (bak != Root->MainFlag) Root->Cnt = 0;
    else                       Root->Cnt ++;
    // ɥ
    KXL_UpDateImm(UP_LEFT, UP_TOP, WIDTH, HEIGHT);
  }
}

//========================================
// ΰ
//========================================
void CreateRoot(void)
{
  // δ
  Root = (RootData *)KXL_Malloc(sizeof(RootData));
  // ʬ饯
  Root->My = (CharacterObject *)KXL_Malloc(sizeof(CharacterObject) * MAX_MY);
  // Ũ饯
  Root->Your = (CharacterObject *)KXL_Malloc(sizeof(CharacterObject) * MAX_YOUR);
  // 󥭥󥰾
  Ranking = (RankingData *)KXL_Malloc(sizeof(RankingData) * 5);
  // ɥ
  KXL_CreateWindow(WIDTH, HEIGHT,
                   PACKAGE VERSION,
                   KXL_EVENT_KEY_PRESS_MASK | KXL_EVENT_KEY_RELEASE_MASK);
  KXL_ReSizeFrame(PIC_WIDTH, PIC_HEIGHT);
  // 
  ReadScore();
  Root->Key = KNone;
  Root->MainFlag = MainKXL;
  gJoyok = KXL_OpenJoystick(JS_DEV);
  // 祤ƥåѥܥ
  JoyMainShot   = (1 << 2L);
  JoySubShot    = (1 << 3L);
  JoyChargeShot = (1 << 7L);
  JoyPause      = (1 << 8L);
  JoyExit       = (1 << 9L);
}

//========================================
// ΰ
//========================================
void DeleteRoot(void)
{
  KXL_DeleteWindow();
  KXL_Free(Root->My);
  KXL_Free(Root->Your);
  KXL_Free(Root);
  KXL_Free(Ranking);
  KXL_CloseJoystick();
}

//========================================
// ץ
//========================================
void options(int argc, char **argv)
{
  Uint16 i;

  fprintf(stderr, "url   : http://kxl.hn.org\n");
  fprintf(stderr, "email : ml@kxl.hn.org\n\n");
  for (i = 1; i < argc; i ++) {
    if (!strcmp(argv[i], "-h") || !strcmp(argv[i], "--help")) {
      fprintf(stderr, "\nUsage: grande [--display display] [--version] [--help]\n");
      fprintf(stderr, "--display display : Use display as the target display\n");
      fprintf(stderr, "--version         : Show version number and exit\n");
      fprintf(stderr, "--help            : Show this message\n");
      exit(1);
    }
  }
  fprintf(stderr, "\"grande --help\" for command line parameters\n");
  for (i = 1; i < argc; i ++) {
    if (!strcmp(argv[i], "--display")) {
      fprintf(stderr, "Using display: %s\n", argv[i + 1]);
      KXL_DisplayName(argv[i + 1]);
    }
    if (!strcmp(argv[i], "--version")) {
      fprintf(stderr, "Version is " VERSION "\n");
      exit(1);
    }
  }
}

//========================================
// ᥤ
//========================================
int main(int argc, char **argv)
{
  Uint8 *sname[] = {
    "pow",
    "bomb",
    "shot",
    "go",
    "mbomb",
    ""
  };

  // ץ
  options(argc, argv);
  // 
  srand(time(NULL));
  // ΰ
  CreateRoot();
  // ᡼
  CreateImage();
  // ɽ
  KXL_InitSound(INST_PATH "/wav", sname);
  // ޳
  KXL_Timer(FRAME_RATE);
  // ᥤ롼
  MainLoop();
  // ɽλ
  KXL_EndSound();
  // ᡼
  DeleteImage();
  // ΰ
  DeleteRoot();
  return 0;
}
