// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: ButtonWithImageLabel.cpp,v 1.1 2004/04/04 05:33:14 vlg Exp $
//------------------------------------------------------------------------------
//                      ButtonWithImageLabel.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date : Sat Apr 3 12:59:14 EST 2004
//
//------------------------------------------------------------------------------

#include <gtkmm/alignment.h>
#include <gtkmm/box.h>
#include <gtkmm/label.h>

#include "ButtonWithImageLabel.h"

ButtonWithImageLabel::
ButtonWithImageLabel (const Gtk::StockID& id_, const string& l_)
{
	using namespace Gtk;

	Alignment* alignment = new Alignment (0.5, 0.5, 0.0, 0.0);

	add (*manage (alignment));

	HBox* hbox = new HBox (false, 3);
	alignment->add (*manage (hbox));

	hbox->pack_start (*manage (new Image (id_, ICON_SIZE_BUTTON)), PACK_SHRINK);
	hbox->pack_start (*manage (new Label (l_, ICON_SIZE_BUTTON)), PACK_SHRINK);

	show_all ();
}
