// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule.cpp,v 1.37 2007/01/15 04:09:08 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004-2006 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

#ifdef HAVE_CONFIG_H
#   include "config.h"
#endif

#include <iostream>
#include <fstream>
#include <unistd.h>				// access(2)
#include <stdlib.h>				// system(3)


#include <gtk/gtklabel.h>
#include <glibmm/ustring.h>
#include <gtkmm/main.h>
#include <gtkmm/rc.h>

#include <assa/CommonUtils.h>
#include <assa/Logger.h>
#include <assa/SigAction.h>
#include <assa/IniFile.h>

#include "Granule-main.h"
#include "Granule.h"
#include "GrappConf.h"
#include "MainWindow.h"

#ifdef IS_HILDON
#include <hildon-widgetsmm/appview.h>
#endif

// Static declarations

ASSA_DECL_SINGLETON(Granule);
static const int TIMEOUT = 500;

template <> xmlExternalEntityLoader Granule::m_default_entity_loader = 0;

/*******************************************************************************
                          Member Functions
*******************************************************************************/
Granule::
Granule () :
	m_timeout        (0.01),
	m_secs_in_day    (86400),
	m_secs_in_week   (604800),
	m_dump_cardboxes ("no"),
	m_kit            (NULL),
	m_main_window    (NULL)
{
    add_opt ('g', "gtk-options",    &m_gtk_options );
	add_opt (0,   "secs-in-day",    &m_secs_in_day );
	add_opt (0,   "secs-in-week",   &m_secs_in_week);
	add_opt (0,   "dump-cardboxes", &m_dump_cardboxes);

    // ---Configuration---
    rm_opt ('n', "instance"     );
    rm_opt ('p', "port"         );

    // ---Process bookkeeping---
    rm_opt ('b', "daemon"       );
    rm_opt ('l', "pidfile"      );
    rm_opt ('L', "ommit-pidfile");

	m_ommit_pidfile = "yes";	// don't lock up on PID 

    /* By defauil disable all debugging
     */
    /* m_mask = GRAPP | DECK | GUITRACE | ASSA::ASSAERR; */
	m_mask = 0;
    m_log_file = "granule.log";
}

/**
 * Description: 
 *
 *  Read configuration from [options] secion of the configuration
 *  file, ~/.granule, and populate command-line options. 
 *  They might be overwritten by command-line arguments supplied with argv_.
 *  Call GenServer::init() to start initialization.
 *
 *  If the application configuration file, ~/.granule,
 *  is missing, copy the default from $GRAPPDATDIR.
 *  Gtkmm hasn't been initialized yet.
 */
void 
Granule::
init (int* argc_, char* argv_[], const char* help_info_)
{
	string rcfile;
	std::string v;
	bool parse_default_rc = true;

#if !defined (WIN32)            /* POSIX systems */
	m_config_file = "none";		/* But note, GrappConf relies on this value! */
	parse_args ((const char**) argv_);

	if (m_config_file != "none") {
		rcfile = ASSA::Utils::strenv (m_config_file.c_str ());
	}
	else {
		string defaultrc (GRAPPDATDIR);	     /* /usr/share/granule/granule */
		defaultrc += "/granule";
		rcfile = ASSA::Utils::strenv ("~/.granule");

		if (::access (rcfile.c_str (), R_OK) < 0) {
			if (::access (defaultrc.c_str (), R_OK) == 0) {
				string cmd ("cp -p ");
				cmd += defaultrc + " " + rcfile;
				if (::system (cmd.c_str ()) < 0) {
					parse_default_rc = false;
				}
			}
			else {
				parse_default_rc = false;
			}
		}
	}
#else /* WIN32 */
	rcfile = "granule.ini"; // same place where the binary is.
#endif

	/**
	 * Load [options] section of the configuration file.
	 */
	if (parse_default_rc) 
	{
		m_default_config_file = rcfile;
		ASSA::IniFile cfg (rcfile);
		if (cfg.load () == 0) {
			if (parse_config_file (cfg) < 0) {
				std::cerr << "Failed to parse rcfile : "
						  << get_opt_error () << std::endl;
				return;
			}
		}
	}

	ASSA::GenServer::init (argc_, argv_, help_info_);

	/** Fix alternative config file name if specified on command-line.
	 *  On a command line it may look like --config-file=~/.granule.whatever.
	 *  This is libassa bug!
	 */
	if (m_config_file != "none") {
		m_config_file = rcfile;
	}
	
	/*
	  TRACE    = 0x00001
	  APP      = 0x00002 (GRAPP)
	  USR1     = 0x00004 (GUITRACE)
	  USR2     = 0x00008 (DECK)
	  USR3     = 0x00010
	  ALL_APPS = 0x0001F
	  ERROR    = 0x00020
	  FORK     = 0x40000
	*/

	if (m_log_level >= 0) 
	{
		switch (m_log_level) 
		{
		case 6:	 m_mask = ALL;     break;    // Log message flood!
		case 5:	 m_mask = 0x3F;    break;    // ALL_APPS+ERRORS
		case 4:  m_mask = 0x40026; break;    // +FORK
		case 3:  m_mask = 0x26;    break;    // GRAPP+GUITRACE+ERRORS
		case 2:  m_mask = 0x25;    break;    // TRACE+GUITRACE+ERRORS
		case 1:	 m_mask = 0x22;    break;    // GRAPP+ERRORS
		case 0:	 m_mask = 0x0;     break;
		default: m_mask = ALL;	// >6
		}
	}
	LOGGER->enable_groups (m_mask);

	/** Install my own entity loader. 
	 *  This will let me redefine DTD URLs and support backward compatability.
	 */
	m_default_entity_loader = xmlGetExternalEntityLoader();
	xmlSetExternalEntityLoader (my_xml_entity_loader);

	/** Initialize XML parser
	 */
	xmlInitParser ();
	xmlIndentTreeOutput = 1;
}

Granule::
~Granule ()
{
    trace_with_mask("Granule::~Granule",GUITRACE);

	/** Cleanup XML parser
	 */
	xmlCleanupParser ();

	/** First, disconnect from the timer callback.
		Failing to do so causes core dumps on exit from libsigc-2.0's
		sigc::trackable::remove_destroy_notify_callback ().
	*/
	m_tconn.disconnect ();
    delete m_main_window;

	if (m_mask == 0) {
		::unlink (m_log_file.c_str ());
	}
}

void
Granule::
dump_package_envs ()
{
	DL((APP,"\n= Environment variables set by automake: =\n"
		"\n"
		"\tGRAPPDATDIR..: \"%s\"\n"
		"\tGRAPPXMLDIR...: \"%s\"\n"
		"\tDATDIR.......: \"%s\"\n"
		"\tLOCALEDIR.....: \"%s\"\n"
		"\tPACKAGE.......: \"%s\"\n"
		"\tVERSION.......: \"%s\"\n"
#ifdef IS_HILDON
		"\tIS_HILDON.....: \"yes\"\n"
#else
		"\tIS_HILDON.....: \"no\"\n"
#endif
#ifdef IS_PDA
		"\tIS_PDA........: \"yes\"\n"
#else
		"\tIS_PDA........: \"no\"\n"
#endif
		"\n",
		GRAPPDATDIR, GRAPPXMLDIR, DATDIR, LOCALEDIR, PACKAGE, VERSION));
}

/* Rewrite the url of the granule DTDs to local files so we can
 * use the local DTDs instead of going out to the web.
 * 
 * Look for /etc/xml for backwards compatibility with old files for POSIX
 * systems and in the binary installation directories for Win32.
 */
xmlParserInputPtr
Granule::
my_xml_entity_loader (const char* url_, 
					  const char* id_,
					  xmlParserCtxtPtr ctxt_)
{
    trace_with_mask("Granule::my_xml_entity_loader",GUITRACE);

	if (url_) DL ((GRAPP,"URL requested: \"%s\"\n",   url_));
	if (id_ ) DL ((GRAPP,"ID  requested:= \"%s\"\n",  id_));

    if (strcmp (url_, "/etc/xml/granule/granule.dtd"              ) == 0 ||
		strcmp (url_, "file:///etc/xml/granule/granule.dtd"       ) == 0 ||
		strcmp (url_, "http://granule.sourceforge.net/granule.dtd") == 0) 
	{
		url_ = GRAPPXMLDIR "/granule.dtd";
    } 
	else 
		if (strcmp (url_, "/etc/xml/granule/cardfile.dtd"              ) == 0 ||
			strcmp (url_, "file:///etc/xml/granule/cardfile.dtd"       ) == 0 ||
			strcmp (url_, "http://granule.sourceforge.net/cardfile.dtd") == 0)
	{
        url_ = GRAPPXMLDIR "/cardfile.dtd";
    }

	DL ((GRAPP,"URL replaced: \"%s\"\n", url_));
    
    return m_default_entity_loader (url_, id_, ctxt_);
}

void
Granule::
init_service ()
{
    trace_with_mask("Granule::init_service",GUITRACE);

    ASSA::Log::disable_timestamp ();
    int gtk_argc = 0;
    char** gtk_argv = NULL;

	DL((ALL,"gtk_options = \"%s\"\n",     m_gtk_options.c_str ()));
	DL((ALL,"log_stdout  = %s\n",         m_log_stdout.c_str ()));
	DL((ALL,"log_file    = \"%s\"\n",     m_log_file.c_str ()));
	DL((ALL,"log_size    = %d\n",         m_log_size));
	DL((ALL,"log_level   = \"%d\"\n",     m_log_level));
	DL((ALL,"mask        = 0x%X\n",       m_mask));
	DL((ALL,"dump_cardboxes = %s\n",      m_dump_cardboxes.c_str ()));

	/**
	 * Block SIGCHLD for a moment
	 */
#if !defined(WIN32)
	ASSA::SigAction old_chld_act;
	struct sigaction* sa;
	old_chld_act.retrieve_action (SIGCHLD);
	sa = old_chld_act;
#endif
	
	/**
	 * ATTENTION:
	 *    Passing --g-fatal-warnings would kill Granule BEFORE
	 *    the first Gtk+ critical warning is written to stdout. 
     *    If you want to examine warnings, don't use this option.
	 */
    m_gtk_options = "granule " + m_gtk_options;
    CmdLineOpts::str_to_argv (m_gtk_options, gtk_argc, gtk_argv);

	DL ((ALL,"Cmd line args (%d):\n", gtk_argc));
	DL ((ALL,"-----------------------------\n"));
	for (int i=0; i<gtk_argc; i++) {
		DL ((ALL,"[%2d] = \"%s\"\n", i, gtk_argv[i]));
	}
	DL ((ALL,"-----------------------------\n"));

    m_kit = new Gtk::Main (&gtk_argc, &gtk_argv);

    CmdLineOpts::free_argv (gtk_argv);

	/** I suspect one of the Gnome libraries changes action of
	 *  SIGCHLD signal. Reset it to SIG_IGN.
	 */
#if !defined(WIN32)
	ASSA::SigAction ignore (SIG_IGN);
	ignore.register_action (SIGCHLD, &old_chld_act);
#endif

    /** Load history from ~/.granule configuration file
	 */
    CONFIG->load_config (m_secs_in_day, m_secs_in_week);
	dump_package_envs ();

	/** Put up the main window on the screen.
	 */
    m_main_window = new MainWindow;
	m_main_window->init ();

	/** Set theme font
	 */
	Gtk::RC::parse_string(
			"style \"resource\" { font_name = \""
			+ CONFIG->get_app_font ().to_string () +
			"\" } "
			"widget \"*\" style \"resource\"");

#ifdef IS_HILDON
	m_hildon_app = new Hildon::App;
	m_hildon_app->set_title ("Granule");
	register_appview (m_main_window, true);
	m_hildon_app->show_all ();
#endif /* IS_HILDON */

    /** Drains too much battery life from nokia770
	 */
/*
	sigc::slot0<bool> tslot = sigc::mem_fun (*this, &Granule::timer_cb);
    m_tconn = Glib::signal_timeout().connect (tslot, TIMEOUT);
*/

    DL((ASSA::APP,"Service has been initialized\n"));
}

void
Granule::
process_events ()
{
    trace_with_mask("Granule::process_events",GUITRACE);

#ifdef IS_HILDON
    m_kit->run (*m_hildon_app);
#else
    m_kit->run (*m_main_window);
#endif

	MAINWIN->close_cb ();
	REACTOR->stopReactor ();

    DL((ASSA::APP,"Service stopped!\n"));
}

void
Granule::
fatal_signal_hook ()
{
    trace_with_mask("Granule::fatal_signal_hook",GUITRACE);

	DL ((ASSA::ALL,"Application terminated with 'kill'\n"));
	gtk_exit (0);
}

/*******************************************************************************
 * Static utilities
 ******************************************************************************/
gchar* 
Granule::
strip_pango_markup (const char* src_)
{
	gchar* result;
	pango_parse_markup (src_, -1, 0, NULL, &result, NULL, NULL);
	return result;
}

bool
Granule::
check_markup (const Glib::ustring& str_)
{
	return (pango_parse_markup (str_.c_str (), -1, 0, NULL, NULL, NULL, NULL));
}

/**
 * For multiline entries (starting with v 1.1.5), 
 * remove part of the string following first newline character.
 * But first, strip possible Pango markup. Markup can span across
 * multiple lines and interpreting only first line might result
 * in invalid syntax.
 */
Glib::ustring
Granule::
trim_multiline (const Glib::ustring& orig_text_)
{
	gchar* pc = Granule::strip_pango_markup (orig_text_.c_str ());
	Glib::ustring text_ = pc;
	g_free (pc);
	Glib::ustring::size_type idx  = text_.find_first_of ("\n");
	Glib::ustring result (text_);
	if (idx != std::string::npos) {
		result.replace (idx, text_.size (), "");
	}
	return result;
}

void
Granule::
remove_common_prefixes (gchar*& src_)
{
	static const gchar* prefixes [] = { "to ", "a ", "an ", NULL };
	
	for (int i = 0; prefixes [i]; i++) {
		if (g_str_has_prefix (src_, prefixes [i])) {
			src_ = src_ + strlen (prefixes [i]);
		}
	}
}

xmlChar*
Granule::
get_node_by_xpath (xmlDocPtr parser_, const char* xpath_)
{
	xmlXPathContextPtr context = NULL;
	xmlXPathObjectPtr  result = NULL;
	xmlNodeSet* nodeset = NULL;
	xmlChar* keyword = NULL;

	context = xmlXPathNewContext (parser_);
	if (context == NULL) {
		DL ((ASSA::ASSAERR,"Failed to create context.\n"));
		goto done;
	}
	
	result = xmlXPathEval (BAD_CAST xpath_, context);

	if (xmlXPathNodeSetIsEmpty (result->nodesetval)) {

		DL ((ASSA::ASSAERR,"Empty nodeset for xpath \"%s\"\n", xpath_));
		goto done;
	}
	nodeset = result->nodesetval;

	/** We expect only one node
	 */
	keyword = xmlNodeListGetString (parser_, 
									nodeset->nodeTab[0]->xmlChildrenNode, 
									1);
  done:
	if (result) {
		xmlXPathFreeObject (result);
	}
	if (context) {
		xmlXPathFreeContext (context);
	}

	return keyword;
}

#ifdef IS_HILDON

void
Granule::
register_appview (Hildon::AppView* view_, bool start_)
{
	Hildon::AppView* old_view;

	if (view_ == NULL) {
		DL ((GRAPP,"register: NULL AppView pointer!\n"));
		return;
	}

	if (!start_) {
		old_view = HILDONAPPWIN->get_appview ();
		HILDONAPPWIN->unregister_view (old_view->gobj ());
		m_appview_stack.push (old_view);
	}

	HILDONAPPWIN->register_view (view_->gobj ());
	HILDONAPPWIN->set_appview (*view_);
}

void
Granule::
unregister_appview (Hildon::AppView* view_)
{
	Hildon::AppView* old_view;

	if (view_ == NULL) {
		DL ((GRAPP,"unregister: NULL AppView pointer!\n"));
		return;
	}

	HILDONAPPWIN->unregister_view (view_->gobj ());
	if (m_appview_stack.size ()) {
		old_view = m_appview_stack.top ();
		HILDONAPPWIN->register_view (old_view->gobj ());
		HILDONAPPWIN->set_appview   (*old_view);
		m_appview_stack.pop ();
	}
}

#endif	// IS_HILDON

void
Granule::
hide_fcd_gtk_labels (GtkContainer* container_, int& counter_)
{
#ifdef IS_PDA 
	const gchar* blabel;
	GList* child;
	GList* child2;

	if (counter_ > 2) {
		return;
	}
	child = gtk_container_get_children(container_);
	while (child != NULL) 
	{
		if (GTK_IS_LABEL (child->data)) {
			blabel = gtk_label_get_text (GTK_LABEL (child->data));
			if (blabel != NULL && (!strcmp (blabel, "Add") || 
								   !strcmp (blabel, "Remove")))
				{
					gtk_widget_hide (GTK_WIDGET (child->data));
					++counter_;
					return;
				}
		}
		if (GTK_IS_CONTAINER (child->data)) {
			hide_fcd_gtk_labels (GTK_CONTAINER (child->data), counter_);
		}
		child = g_list_next(child);
	}
#endif
}
