// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: TextAlignment.h,v 1.5 2006/12/18 03:33:15 vlg Exp $
//------------------------------------------------------------------------------
//                            TextAlignment.h
//------------------------------------------------------------------------------
//  Copyright (c) 2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Oct 25 20:49:21 EDT 2006
//
//------------------------------------------------------------------------------
#ifndef TEXT_ALIGNMENT_H
#define TEXT_ALIGNMENT_H

#include "PrefWindow.h"
#include "MyTextAlignmentsWidget.h"

class TextAlignment : public Gtk::VBox
{
public:
	TextAlignment (PrefWindow& grandpa_);

	void set_x_alignment   (SideSelection side_, const std::string& v_);
	void set_y_alignment   (SideSelection side_, const std::string& v_);
	void set_x_padding     (SideSelection side_, const std::string& v_);
	void set_y_padding     (SideSelection side_, const std::string& v_);
	void set_justification (SideSelection side_, const std::string& v_);

	std::string get_x_alignment   (SideSelection side_) const;
	std::string get_y_alignment   (SideSelection side_) const;
	std::string get_x_padding     (SideSelection side_) const;
	std::string get_y_padding     (SideSelection side_) const;
	std::string get_justification (SideSelection side_) const;

private:
	PrefWindow&      m_pref_window;
	Gtk::VBox*       m_vbox;			/* parent */

	MyTextAlignmentsWidget* m_front_widget;
	MyTextAlignmentsWidget* m_back_widget;
	MyTextAlignmentsWidget* m_example_widget;
};

#endif /* TEXT_ALIGNMENT_H */
