/* $Id: gvtextlayout_cairo.c,v 1.11 2005/11/28 20:51:52 ellson Exp $ $Revision: 1.11 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>

#ifdef HAVE_CAIRO
#include <cairo.h>
#endif

/* FIXME - shouldn't need this */
#include "types.h"

#include "gvplugin_textlayout.h"

extern void gv_cairo_select_font_face(cairo_t *cr, char *fontname);

#ifdef CAIRO_HAS_FT_FONT

void width(textline_t * textline, char *fontname, double fontsize, char *fontpath)
{
    static cairo_surface_t *surface;
    cairo_t *cr;
    cairo_text_extents_t extents;

    /* use a zero-sized surface to keep cairo happy */
    if (!surface)
	surface = cairo_image_surface_create(CAIRO_FORMAT_ARGB32,0,0);

    cr = cairo_create(surface);
    
    gv_cairo_select_font_face(cr, fontname);

    cairo_set_font_size(cr, fontsize);
    cairo_text_extents(cr, textline->str, &extents);
    cairo_destroy(cr);

    textline->width = extents.width;
    textline->xshow = NULL;
    fontpath = "[cairo]";
}

gvtextlayout_engine_t textlayout_engine = {
    width,
};
#endif

gvplugin_installed_t gvtextlayout_cairogen_types[] = {
#ifdef CAIRO_HAS_FT_FONT
    {0, "cairo", 10, &textlayout_engine, NULL},
#endif
    {0, NULL, 0, NULL, NULL}
};
