//*****************************************************************************
//                                PnlGnuCapFO.hpp                             *
//                               -----------------                            *
//  Description : This class derives from the Analysis Panel base class and   *
//                provides a GUI for a user to configure a Fourier Analysis   *
//                for GNU-Cap electronic circuit simulator.                   *
//  Started     : 26/04/2004                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLGNUCAPFO_HPP
#define PNLGNUCAPFO_HPP

// System Includes

#include <cfloat>

// wxWidgets Library Includes

#include <wx/config.h>

// Application Includes

#include "base/PnlAnaBase.hpp"
#include "gnucap/dialogs/DlgSigGenCfg.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlGnuCapFO : public PnlAnaBase
{
  public:

    // The various sub-parameters which may be output (FO analysis only)
    enum eCpxType
    {
      eOUT_ACT = 0, // The actual   magnitude value
      eOUT_REL,     // The relative magnitude value
      eOUT_PHASE,   // Phase of the actual or relative value
      eOUT_MAGDB,   // The actual or relative value should be in dBV

      eOUT_FST = eOUT_ACT,
      eOUT_LST = eOUT_MAGDB
    };

  private:

    // Output Parameters
    wxStaticBox   m_oSbxOutputs;
    wxCheckBox    m_oCbxAct;
    wxCheckBox    m_oCbxRel;
    wxCheckBox    m_oCbxPhase;
    wxCheckBox    m_oCbxDbMag;

    // Generator configuration
    wxButton      m_oBtnSetup;
    DlgSigGenCfg  m_oDlgSigGenCfg;

    void  Create( void );
    void  CreateOutputs( void );

    bool  bIsCreatedOutputs( void )
                 { return( m_oSbxOutputs.GetParent( )!=NULL ? TRUE : FALSE ); }

    bool  bSetInitC( eInitCType eInitC );

  public:

    PnlGnuCapFO( wxWindow * poWin );
   ~PnlGnuCapFO( );

    bool  bClear( void );

    bool  bLoad( Simulation & roSim );
    bool  bSave( Simulation & roSim );

    // Event handlers
    void  OnBtnSetup( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum ePnlItemID
    {
      ID_BTN_SETUP = PnlAnaBase::ID_LST+1,

      ID_CBX_ACT,
      ID_CBX_REL,
      ID_CBX_PHASE,
      ID_CBX_DBMAG,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_BTN_SETUP,
      ID_LST = ID_CBX_MAGDB
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLGNUCAPFO_HPP
