//*****************************************************************************
//                                PnlGnuCapTR.hpp                             *
//                               -----------------                            *
//  Description : This class derives from the Analysis Panel base class and   *
//                provides a GUI for a user to configure a Transient Analysis *
//                for GNU-Cap electronic circuit simulator.                   *
//  Started     : 22/02/2004                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLGNUCAPTR_HPP
#define PNLGNUCAPTR_HPP

// System Includes

#include <cfloat>

// wxWidgets Library Includes


// Application Includes

#include "base/PnlAnaBase.hpp"
#include "gnucap/dialogs/DlgSigGenCfg.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlGnuCapTR : public PnlAnaBase
{
  private:

    // Generator configuration
    wxButton       m_oBtnSetup;
    DlgSigGenCfg   m_oDlgSigGenCfg;

    void  Create( void );
    bool  bSetInitC( eInitCType eInitC );

  public:

    PnlGnuCapTR( wxWindow * poWin );
   ~PnlGnuCapTR( );

    bool  bClear( void );

    bool  bLoad( Simulation & roSim );
    bool  bSave( Simulation & roSim );

    // Event handlers
    void  OnBtnSetup( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum ePnlItemID
    {
      ID_BTN_SETUP = PnlAnaBase::ID_LST+1,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_BTN_SETUP,
      ID_LST = ID_BTN_SETUP
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLGNUCAPTR_HPP
