//*****************************************************************************
//                              CmdNgSpiceDC.cpp                              *
//                             ------------------                             *
//  Started     : 21/08/2007                                                  *
//  Last Update : 16/10/2007                                                  *
//  Copyright   : (C) 2007 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/commands/CmdNgSpiceDC.hpp"

//*****************************************************************************
// Constructor.

CmdNgSpiceDC::CmdNgSpiceDC( void )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdNgSpiceDC::~CmdNgSpiceDC( )
{
}

//*****************************************************************************
// Parse the command string.
//
// Eg.s : .DC Vin 0.00 200.00m 25.00m
//        .DC TEMP 0.00 200.00 25.00
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceDC::bParse( void )
{
  wxStringTokenizer  ostk1;
  wxString           os1;
  double             df1;

  // Tokenize the command string
  ostk1.SetString( *this );
  if( ostk1.CountTokens( ) != 5 ) return( FALSE );

  // Clear object attributes but keep the command string
  bClear( );
  (wxString &) *this = ostk1.GetString( );

  // Check command type
  os1 = ostk1.GetNextToken( ).Left( 3 ).Upper( );
  if( os1 != wxT(".DC") )         return( FALSE );
  m_osName = wxT("DC");

  m_bIsOk = TRUE;

  // Extract the sweep type: a signal source or temperature
  m_osSource = ostk1.GetNextToken( );

  // Extract the start value
  os1 = ostk1.GetNextToken( );
  if( ConvertType::bStrToFlt( os1, &df1 ) ) m_fStart = (float) df1;
  else m_bIsOk = FALSE;

  // Extract the stop value
  os1 = ostk1.GetNextToken( );
  if( ConvertType::bStrToFlt( os1, &df1 ) ) m_fStop  = (float) df1;
  else m_bIsOk = FALSE;

  // Extract the step increment
  os1 = ostk1.GetNextToken( );
  if( ConvertType::bStrToFlt( os1, &df1 ) ) m_fStep  = (float) df1;
  else m_bIsOk = FALSE;

  return( m_bIsOk );
}

//*****************************************************************************
// Format the command string.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceDC::bFormat( void )
{
  wxString  os1, os2;

  m_bIsOk = FALSE;

  os1 = wxT(".DC");

  os1 << wxT(' ') << m_osSource;

  if( ! ConvertType::bFltToStr( (double) m_fStart, os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  if( ! ConvertType::bFltToStr( (double) m_fStop,  os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  if( ! ConvertType::bFltToStr( (double) m_fStep,  os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  m_bIsOk = TRUE;
  (wxString) *this = os1;

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceDC::bClear( void )
{
  bool  bRtnValue;

  bRtnValue = CmdBase::bClear( );

  m_fStart = -FLT_MAX;
  m_fStop  = -FLT_MAX;
  m_fStep  = -FLT_MAX;

  m_osSource.Empty( );

  return( bRtnValue );
}

//*****************************************************************************
