//*****************************************************************************
//                              CmdNgSpiceDC.hpp                              *
//                             ------------------                             *
//  Description : This class contains values associated with the NG-Spice     *
//                DC command. It inherits from the class CmdBase.             *
//  Started     : 23/08/2006                                                  *
//  Last Update : 24/05/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICEDC_HPP
#define CMDNGSPICEDC_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and Constant Declarations

//*****************************************************************************

class CmdNgSpiceDC : public CmdBase
{
  protected:

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

  public:

    float     m_fStart;    // The sweep start value
    float     m_fStop;     // The sweep stop  value
    float     m_fStep;     // The sweep step  value
    wxString  m_osSource;  // The sweep source

              CmdNgSpiceDC( void );
    virtual  ~CmdNgSpiceDC( );

    bool  bClear( void );
};

//*****************************************************************************

#endif // CMDNGSPICEDC_HPP
