//*****************************************************************************
//                              CmdNgSpiceTR.cpp                              *
//                             ------------------                             *
//  Started     : 15/10/2007                                                  *
//  Last Update : 16/10/2007                                                  *
//  Copyright   : (C) 2007 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/commands/CmdNgSpiceTR.hpp"

//*****************************************************************************
// Constructor.

CmdNgSpiceTR::CmdNgSpiceTR( void )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdNgSpiceTR::~CmdNgSpiceTR( )
{
}

//*****************************************************************************
// Parse the command string.
//
// Eg.s : .TRAN 10.00m 100.00m 0.00 10.00m UIC
//        .TRAN 10.00m 100.00m 0.00 10.00m
//        .TRAN 10.00m 100.00m 0.00
//        .TRAN 10.00m 100.00m
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceTR::bParse( void )
{
  wxStringTokenizer  ostk1;
  wxString           os1;
  double             df1;
  int                i1;

  // Tokenize the command string
  ostk1.SetString( *this );
  i1 = ostk1.CountTokens( );
  if( i1<3 || i1>6 )             return( FALSE );

  // Clear object attributes but keep the command string
  bClear( );
  (wxString &) *this = ostk1.GetString( );

  // Check command type
  os1 = ostk1.GetNextToken( ).Left( 5 ).Upper( );
  if( os1 != wxT(".TRAN") )      return( FALSE );
  m_osName = wxT("TRAN");

  m_bIsOk = TRUE;

  // Extract the step increment
  os1 = ostk1.GetNextToken( );
  if( ConvertType::bStrToFlt( os1, &df1 ) )   m_fStep  = (float) df1;
  else m_bIsOk = FALSE;

  // Extract the stop value
  os1 = ostk1.GetNextToken( );
  if( ConvertType::bStrToFlt( os1, &df1 ) )   m_fStop  = (float) df1;
  else m_bIsOk = FALSE;

  // Extract the start value
  m_fStart = 0.0;
  if( ostk1.HasMoreTokens( ) )
  {
    os1 = ostk1.GetNextToken( );
    if( ConvertType::bStrToFlt( os1, &df1 ) ) m_fStart = (float) df1;
    else m_bIsOk = FALSE;
  }

  // Extract the initial conditions specifier
  m_eInitC = eINITC_WARM;
  while( ostk1.HasMoreTokens( ) )
  {
    os1 = ostk1.GetNextToken( ).Upper( );
    if( os1 == wxT("UIC") )
    {
      m_eInitC = eINITC_UICS;
      break;
    }
  }

  return( m_bIsOk );
}

//*****************************************************************************
// Format the command string.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceTR::bFormat( void )
{
  wxString  os1, os2;

  m_bIsOk = FALSE;

  os1 = wxT(".TRAN");

  if( ! ConvertType::bFltToStr( (double) m_fStep,  os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  if( ! ConvertType::bFltToStr( (double) m_fStop,  os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  if( ! ConvertType::bFltToStr( (double) m_fStart, os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  if( m_eInitC == eINITC_UICS ) os1 << wxT(" UIC");

  m_bIsOk = TRUE;
  (wxString) *this = os1;

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceTR::bClear( void )
{
  bool  bRtnValue;

  bRtnValue = CmdBase::bClear( );

  m_fStart = -FLT_MAX;
  m_fStop  = -FLT_MAX;
  m_fStep  = -FLT_MAX;

  m_eInitC = eINITC_NONE;

  return( bRtnValue );
}

//*****************************************************************************
