/* lighthouseblue.h -- LighthouseBlue style definition
 
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Author: Jan Rosczak <jan.rosczak@web.de>  
*/

#ifndef __LIGHTHOUSEBLUE_H__
#define __LIGHTHOUSEBLUE_H__

#define SCALE_SIZE 5

typedef struct
{
  guint refcount;
  gboolean has_notebook_patch;
  gboolean combine_treeview_select;
  gboolean wide;
}
LighthouseBlueRcData;

typedef struct
{
  GdkColor shade[8];
  GdkGC *shade_gc[8];
}
LighthouseBlueData;

void lighthouseblue_initialize_style (GtkStyleClass * klass,
				      GtkStyleClass * parent);
void lighthouseblue_shade (GdkColor * a, GdkColor * b, float k);

#endif /* __LIGHTHOUSEBLUE_H__ */
