/*  gtk-imonc - imond client for fli4l
 *  Copyright (C) 2001-2003 Stefan Strigler <steve@zeank.in-berlin.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "imonc.h"
#include "timer.h"
#include "news.h"
#include "docklet.h"

void
check_password													(GtkWidget *widget,
																				 gpointer user_data)
{
	GtkWidget *auth_dialog, *auth_hint, *auth_password;
	char buf[64];
	char *answer;
	
	auth_dialog = lookup_widget (widget, "auth_dialog");
	
	auth_password = lookup_widget (auth_dialog, "auth_password");
	if (salt) {
		gchar tmp[256];
		snprintf(tmp,256,"%s%s",gtk_entry_get_text (GTK_ENTRY (auth_password)),salt);
		sprintf (buf, "md5pass %s", hexmd5(tmp));
	} else
		snprintf (buf, 64, "pass %s", gtk_entry_get_text (GTK_ENTRY (auth_password)));

	send_command (fd, buf);
	answer = get_answer (fd);
	
	if (strlen(answer)) {

		gtk_widget_destroy (auth_dialog);
		
		gtk_widget_show (gtk_imonc);

		if (atoi(answer)>=4)
			is_admin = TRUE;

		imonc_init (gtk_imonc); /* initialize imonc functionality */
		imonc_update (gtk_imonc); /* init with current values */

		if (is_mini) {
			GtkWidget *mini_view;

			is_mini = FALSE;
			mini_view = lookup_widget (rightclick_menu,"mini_view");
			gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mini_view),TRUE);
		}
		timeout_tag = gtk_timeout_add (TIMEOUT_MSEC, imonc_update, gtk_imonc);
		
	} else {
		auth_hint = lookup_widget (auth_dialog, "auth_hint");

		gtk_label_set_text (GTK_LABEL (auth_hint), _("Password Incorrect"));
		gtk_entry_set_text (GTK_ENTRY (auth_password), "");
	}

}

void
check_admin_password										(GtkWidget *widget,
																				 gpointer user_data)
{
	char buf[64];
	int answer;
	GtkWidget *gtk_imonc, *admin_mode_dialog, *admin_mode_label, *admin_password;
	
	admin_mode_dialog = lookup_widget (widget, "admin_mode_dialog");

	strcpy (admin_passwd, gtk_entry_get_text (GTK_ENTRY (user_data)));

	if (salt) {
		gchar tmp[256];
		snprintf(tmp,256,"%s%s",gtk_entry_get_text (GTK_ENTRY (user_data)),salt);
		sprintf (buf, "md5pass %s", hexmd5(tmp));
	} else 
		snprintf (buf, 64, "pass %s", admin_passwd);

	send_command (fd, buf);
	answer = atoi (get_answer (fd));

	if (answer >= 4) {
			
		imonc_auth_update (gtk_imonc); /* reinitialize imonc functionality */

		gtk_widget_destroy (admin_mode_dialog);
	} else {
		admin_mode_label = lookup_widget (admin_mode_dialog, "admin_mode_label");
		admin_password = lookup_widget (admin_mode_dialog, "admin_passwd");

		gtk_label_set_text (GTK_LABEL (admin_mode_label), _("Password Incorrect"));
		gtk_entry_set_text (GTK_ENTRY (admin_password), "");
	}
}

/*----------------------------------------------------------------------------
 *  below are the "real" callback functions (mostly generated by glade)
 *----------------------------------------------------------------------------
 */

void
on_dial_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	send_command (fd, "dial");
	get_answer (fd);
/* 	g_print ("dailing: %s\n", get_answer (fd)); */
}


void
on_hangup_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	send_command (fd, "hangup");
	get_answer (fd);
/*	g_print ("hangup: %s\n", get_answer (fd)); */
}


void
on_addlink_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar buf[64];
	gchar *answer;

	send_command (fd, "route");
	answer = get_answer (fd);
	sprintf(buf, "addlink %s", answer);
	send_command (fd, buf);
	get_answer (fd);
/* 	g_print ("%s: %s\n", buf, get_answer (fd)); */
}

gboolean
on_dialmode_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	gtk_timeout_remove (timeout_tag);
  return FALSE;
}


void 
on_default_route_selected								(GtkMenuShell *menu_shell, 
																				 gpointer data)
{
	GtkWidget *active_item;
	gint item_index;
	char buf[64];

	active_item = gtk_menu_get_active (GTK_MENU (menu_shell));
	item_index = g_list_index (menu_shell->children, active_item);

	sprintf (buf, "route %i", item_index);
	send_command (fd, buf);
	get_answer (fd);
/* 	g_print ("Defaul route %i selected: %s\n", item_index, get_answer (fd)); */
	timeout_tag = gtk_timeout_add (TIMEOUT_MSEC, imonc_update, GTK_WIDGET (menu_shell));
}

void
on_dialmode_selected										(GtkMenuShell *menu_shell, 
																				 gpointer data)
{
	GtkWidget *active_item;
	gint item_index;

	active_item = gtk_menu_get_active (GTK_MENU (menu_shell));
	item_index = g_list_index (menu_shell->children, active_item);
	
	switch (item_index) {
	case 0:
		send_command (fd, "dialmode auto");
		get_answer (fd);
/* 		g_print ("dialmode auto selected: %s\n", get_answer (fd)); */
		break;
	case 1:
		send_command (fd, "dialmode manual");
		get_answer (fd);
/* 		g_print ("dialmode manual selected: %s\n", get_answer (fd)); */
		break;
	case 2:
		send_command (fd, "dialmode off");
		get_answer (fd);
/* 		g_print ("dialmode off selected: %s\n", get_answer (fd)); */
	}
	timeout_tag = gtk_timeout_add (TIMEOUT_MSEC, imonc_update, GTK_WIDGET (menu_shell));
}

gboolean
on_default_route_menu_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	gtk_timeout_remove (timeout_tag);

  return FALSE;
}

void
on_auth_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	check_password (GTK_WIDGET (button), user_data);
}



void
on_halt_warning_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	send_command (fd, "halt");
	get_answer (fd);
/* 	g_print ("halt: %s\n", get_answer (fd)); */
	gtk_main_quit ();
}


void
on_reboot_warning_ok_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	send_command (fd, "reboot");
	get_answer (fd);
/* 	g_print ("reboot: %s\n", get_answer (fd)); */
	gtk_main_quit ();
}


void
on_remlink_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar buf[64];
	gchar *answer;

	send_command (fd, "route");
	answer = get_answer (fd);
	sprintf(buf, "removelink %s", answer);
	send_command (fd, buf);
	get_answer (fd);
/* 	g_print ("%s: %s\n", buf, get_answer (fd)); */

}

void
on_admin_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	check_admin_password (GTK_WIDGET (button), user_data);
}


void
on_reconnect_ok_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *gtk_imonc;

	reconnect_dialog = lookup_widget (GTK_WIDGET (button), "reconnect_dialog");
	gtk_imonc = gtk_object_get_data (GTK_OBJECT (reconnect_dialog), "gtk_imonc");

	gtk_widget_destroy (reconnect_dialog);
	reconnect_dialog = NULL;

  fli4l_reconnect(0);
}


void
on_calls_reset_button_clicked						(GtkButton       *button,
																				 gpointer         user_data)
{
	GtkWidget *calls_clist;

	send_command (fd, "reset-telmond-log-file");
	get_answer (fd);
	calls_clist = lookup_widget (GTK_WIDGET (button), "calls_clist");
	gtk_clist_clear (GTK_CLIST (calls_clist));
}


void
on_calls_refresh_button_clicked					(GtkButton       *button,
																				 gpointer         user_data)
{
	GtkWidget *calls_clist;
	
	calls_clist = lookup_widget (GTK_WIDGET (button), "calls_clist");
	//	gtk_clist_clear (GTK_CLIST (calls_clist));
	get_calls (GTK_CLIST (calls_clist));
}

void
on_notebook_switch_page                (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	if (page_num != 0)
		{
			show_status = FALSE;
		}
	else
		{
			gtk_widget_show (traffic_info);
			show_status = TRUE;
			init_show_status = TRUE;
			imonc_update(GTK_WIDGET (notebook));
		}
}


void
on_imondlog_reset_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *imondlog_clist;

	imondlog_clist = lookup_widget (GTK_WIDGET (button), "imondlog_clist");

	send_command (fd, "reset-imond-log-file");
	get_answer (fd);

	/* clear list */
	gtk_clist_clear (GTK_CLIST (imondlog_clist));
	con_rows = onltime = obytes = ibytes = charge = 0; /* reset global values */
}

void
on_reboot_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	reboot_warning = create_reboot_warning ();
	gtk_widget_show (reboot_warning);
}


void
on_halt_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	halt_warning = create_halt_warning ();
	gtk_widget_show (halt_warning);
}


void
on_circuit_config_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *circuits_dialog;
	GtkWidget *circuits_clist;
	gchar buf[64];
	gchar *row[3];
	gchar answers[3][128];
	gint i;

	/* create widget */
	circuits_dialog = create_circuits_dialog ();

	/* get clist */
	circuits_clist = lookup_widget (circuits_dialog, "circuits_clist");

	/* add data to clist */
	for (i=1; i<=circuits; i++) {
		sprintf (buf, "circuit %d", i);
		send_command (fd, buf);
		strcpy (answers[0], get_answer (fd));
		row[0] = answers[0];

		sprintf (buf, "device %d", i);
		send_command (fd, buf);
		strcpy (answers[1], get_answer (fd));
		row[1] = answers[1];

		sprintf (buf, "hup-timeout %d", i);
		send_command (fd, buf);
		strcpy (answers[2], get_answer (fd));
		row[2] = answers[2];

		/* add row to clist and mark it as non-selectable if its a pppoe
       device */
		gtk_clist_set_selectable (GTK_CLIST (circuits_clist), gtk_clist_append (GTK_CLIST (circuits_clist), row), (strcmp (row[1], "pppoe")));
	}

	/* finally show the widget */
	gtk_widget_show (circuits_dialog);
}


void
on_edit_circuit_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *edit_circuit_dialog;
	GtkWidget *spinbutton;
	gpointer clist;
	gint row;
	gint val;
	gchar buf[64];

	/* get widget */
	edit_circuit_dialog = lookup_widget (GTK_WIDGET (button), "edit_circuit_dialog");
	spinbutton = lookup_widget (GTK_WIDGET (button), "spinbutton");

	/* get stored values */
	clist = gtk_object_get_data (GTK_OBJECT (edit_circuit_dialog), "clist");
	row = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (edit_circuit_dialog), "row"));
	val = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spinbutton));

	/* update circuit_dialog */
	sprintf (buf, "%d", val);
	gtk_clist_set_text (GTK_CLIST (clist), row, 2, buf);

	/* set huptmeout */
	sprintf (buf, "hup-timeout %d %d", (row+1), val);
	send_command (fd, buf);
	get_answer (fd);

	/* finally close window */
	gtk_widget_destroy (edit_circuit_dialog);
}


void
on_circuits_clist_select_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	GtkWidget *edit_circuit_dialog;
	GtkWidget *circuit_label;
	GtkWidget *spinbutton;
	GtkAdjustment *adj;
	gchar *circuit;
	gchar *timeout;

	/* is it selectable ? */
	/* weird indeed - why does gtk fire this event? */
	if (!gtk_clist_get_selectable (clist, row))
		return; /* no, must have beed a pppoe device */

	/* create widget */
	edit_circuit_dialog = create_edit_circuit_dialog ();
	circuit_label = lookup_widget (edit_circuit_dialog, "circuit_label");
	spinbutton = lookup_widget (edit_circuit_dialog, "spinbutton");

	/* insert values from selected row */
	if (gtk_clist_get_text (clist, row, 0, &circuit))
		gtk_label_set_text (GTK_LABEL (circuit_label), circuit);
	if (gtk_clist_get_text (clist, row, 2, &timeout)) {
		adj = GTK_ADJUSTMENT (gtk_adjustment_new (atof (timeout), 0, 3600, 10, 10, 3600));
		gtk_spin_button_set_adjustment (GTK_SPIN_BUTTON (spinbutton), adj);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinbutton), atof (timeout));
	}
	gtk_object_set_data (GTK_OBJECT (edit_circuit_dialog), "clist", clist);
	gtk_object_set_data (GTK_OBJECT (edit_circuit_dialog), "circuit_nr", GINT_TO_POINTER (row));

	gtk_widget_show (edit_circuit_dialog);
}


void
on_news_refresh_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *news_text;

	news_text = lookup_widget (GTK_WIDGET (button), "news_text");

	get_news (GTK_TEXT_VIEW (news_text));
}


gboolean
on_admin_passwd_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if (event->keyval == GDK_Return)
		check_admin_password (widget, user_data);
  return FALSE;
}

gboolean
on_auth_password_key_press_event       (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if (event->keyval == GDK_Return)
		check_password (widget, user_data);
  return FALSE;
}


void
on_imondlog_export_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fileselection, *imondlog_clist;

	imondlog_clist = lookup_widget (GTK_WIDGET (button), "imondlog_clist");

	fileselection = create_fileselection ();

	gtk_file_selection_set_filename (GTK_FILE_SELECTION (fileselection), "~/imondlog.csv");
	gtk_object_set_data (GTK_OBJECT (fileselection), "clist", imondlog_clist);
	gtk_widget_show (fileselection);
}

void
on_calls_export_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fileselection, *calls_clist;

	calls_clist = lookup_widget (GTK_WIDGET (button), "calls_clist");

	fileselection = create_fileselection ();

	gtk_file_selection_set_filename (GTK_FILE_SELECTION (fileselection), "~/calls.csv");
	gtk_object_set_data (GTK_OBJECT (fileselection), "clist", calls_clist);
	gtk_widget_show (fileselection);

}

void
on_support_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fs;

	fs = create_fileselection ();
	gtk_file_selection_set_filename (GTK_FILE_SELECTION (fs), "~/support.txt");
	gtk_widget_show (fs);
	
}

void
on_fileselection_ok_button_clicked               (GtkButton       *button,
                                                  gpointer         user_data)
{
	FILE *csv_file;
	GtkWidget *clist, *filesel;

  filesel = lookup_widget(GTK_WIDGET(button),"fileselection");

	clist = gtk_object_get_data (GTK_OBJECT (filesel), "clist");

	if ((csv_file = fopen (gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)), "w")) == NULL) 
		{
			/* do some more error handling here */
			GtkWidget *cantopen_error;

			cantopen_error = create_cantopen_error ();
/* 			perror("save file"); */
			gtk_widget_show (cantopen_error);
			return;
		}


	if (clist != NULL)
		{
			csv_dump_clist (GTK_CLIST (clist), csv_file);
			fclose (csv_file);
		}
	else
		{
			/* ask user for remote login password */
			GtkWidget *remote_auth_dialog, *remote_auth_label;
			gchar buf[1024];

			remote_auth_dialog = create_remote_auth_dialog ();

			gtk_object_set_data (GTK_OBJECT (remote_auth_dialog), "csv_file", csv_file);

			/* add hostname to dialog */
			remote_auth_label = lookup_widget (remote_auth_dialog,"remote_auth_label");

			sprintf (buf,_("You need to authenticate yourself!\nPlease enter root password\nfor %s!"),host_name);
			gtk_label_set_text (GTK_LABEL (remote_auth_label),buf);

			gtk_widget_show (remote_auth_dialog);
		}
}



gboolean
on_traffic_info_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	traffic_info_update (widget);
	return TRUE;
}

void
get_support_info												(GtkWidget *widget,
																				 gpointer user_data)
{
	FILE *csv_file;
	gchar buf[128];

	csv_file = (FILE *) gtk_object_get_data (GTK_OBJECT (widget), "csv_file");

	/* get support data and dump it to file */
	sprintf (buf, "support %s", gtk_entry_get_text (GTK_ENTRY (user_data)));
	fprintf (csv_file, "%s", get_buf (fd, buf));
	fclose (csv_file);
	
	gtk_widget_destroy (widget);
}

gboolean
on_remote_auth_password_key_press_event
                                        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if (event->keyval == GDK_Return)
		get_support_info (widget, user_data);
  return FALSE;
}


void
on_remote_auth_ok_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	widget = lookup_widget (GTK_WIDGET (button), "remote_auth_dialog");
	get_support_info (widget, user_data);
}

gboolean
on_gtk_imonc_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->type == GDK_BUTTON_PRESS) {
		GdkEventButton *bevent = (GdkEventButton *) event; 

		/* return if it was not a rightclick */
		if (bevent->button != 3)
			return FALSE;

		gtk_menu_popup (GTK_MENU (rightclick_menu), NULL, NULL, NULL, NULL,
										bevent->button, bevent->time);
		/* Tell calling code that we have handled this event; the buck
		 * stops here. */
		return TRUE;
	}
	
	/* Tell calling code that we have not handled this event; pass it on. */
	return FALSE;
}

void
on_mini_view_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (is_mini) {
		/* show gtk-imonc */
		GtkWidget *alignment;

		alignment = lookup_widget (gtk_imonc, "alignment");
		gtk_widget_reparent (traffic_info, alignment);

		if (!show_status_old)
			gtk_widget_hide (traffic_info);

		gtk_widget_hide (gtk_miniimonc);
		gtk_widget_show (gtk_imonc);

		show_status = show_status_old;
		is_mini = FALSE;

		imonc_update (gtk_imonc);
	} else {
		/* show gtk-miniimonc */
		GtkWidget *eventbox;

		eventbox = lookup_widget (gtk_miniimonc, "eventbox");
		gtk_widget_reparent (traffic_info, eventbox);
		gtk_widget_show (traffic_info);

		gtk_widget_hide (gtk_imonc);
		gtk_widget_show (gtk_miniimonc);

		show_status_old = show_status;
		show_status = FALSE;
		is_mini = TRUE;
	}
}

void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *prefs;
	GtkWidget *hnw, *pw, *nw, *mw, *cnw, *ccw, *ccl, *tiw;
	char buf[64];

	prefs = create_preferences_dialog();

	/* lookup widgets */
	hnw = lookup_widget(prefs,"hostname_entry");
	pw = lookup_widget(prefs,"port_entry");
	nw = lookup_widget(prefs,"news_checkbutton");
	mw = lookup_widget(prefs,"mini_checkbutton");
	tiw = lookup_widget(prefs,"trayicon_checkbutton");
	cnw = lookup_widget(prefs,"call_checkbutton");
	ccw = lookup_widget(prefs,"command_entry");
	ccl = lookup_widget(prefs,"command_label");

	/* set current values */
  if (host_name)
    gtk_entry_set_text(GTK_ENTRY(hnw),host_name);
	snprintf(buf,64,"%d",port);
	gtk_entry_set_text(GTK_ENTRY(pw),buf);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nw),use_news_tab);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tiw),use_trayicon);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(mw),start_mini);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cnw),telmond_popup);
	if (!telmond_popup) {
		gtk_entry_set_editable(GTK_ENTRY(ccw),FALSE);
		gtk_widget_set_sensitive(ccw,FALSE);
		gtk_widget_set_sensitive(ccl,FALSE);
	}

	if (call_notification)
		gtk_entry_set_text(GTK_ENTRY(ccw),call_notification);

	gtk_widget_show(prefs);
}


void
on_preferences_okbutton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *hnw, *pw, *nw, *mw, *cnw, *ccw, *tiw;
	gboolean reconnect = FALSE;
	FILE *fp;
	gchar buf[256];

	/* lookup widgets */
	hnw = lookup_widget(GTK_WIDGET(button),"hostname_entry");
	pw = lookup_widget(GTK_WIDGET(button),"port_entry");
	nw = lookup_widget(GTK_WIDGET(button),"news_checkbutton");
	tiw = lookup_widget(GTK_WIDGET(button),"trayicon_checkbutton");
	mw = lookup_widget(GTK_WIDGET(button),"mini_checkbutton");
	cnw = lookup_widget(GTK_WIDGET(button),"call_checkbutton");
	ccw = lookup_widget(GTK_WIDGET(button),"command_entry");

	if(strcmp(gtk_entry_get_text(GTK_ENTRY(hnw)),host_name) || // hostname changed
     !strcmp(host_name,"") ||
     !fd || fd <0) {  // not connected
		host_name = strdup(gtk_entry_get_text(GTK_ENTRY(hnw)));
		reconnect = TRUE;
	}

	if (port != atoi(gtk_entry_get_text(GTK_ENTRY(pw)))) { // port changed
		port = atoi(gtk_entry_get_text(GTK_ENTRY(pw)));
		reconnect = TRUE;
	}

	use_news_tab = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nw));
	start_mini = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(mw));
/* 	use_trayicon = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tiw)); */
	telmond_popup = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cnw));
	if ((strcmp(gtk_entry_get_text(GTK_ENTRY(ccw)),"")))
		call_notification = strdup(gtk_entry_get_text(GTK_ENTRY(ccw)));
	else
		call_notification = NULL;

	/* now dump to file */
	snprintf(buf,256,"%s/.imoncrc",getenv("HOME"));
	if ((fp=fopen(buf,"w+"))) {
		fprintf(fp,"hostname = %s\n",host_name);
		fprintf(fp,"port = %d\n",port);
		if (!use_news_tab)
			fprintf(fp,"get_news = no\n");
		if (use_trayicon)
			fprintf(fp,"use_trayicon = yes\n");
		if (start_mini)
			fprintf(fp,"mini_mode = yes\n");
		if (telmond_popup)
			fprintf(fp,"call_notification = yes\n");
		if (call_notification)
			fprintf(fp,"call_cmd = %s\n",call_notification);

		fclose(fp);
	} else {
		perror("can't save properties");
	}
	
	if (reconnect || !fd) {
		fli4l_disconnect();
		if (!fli4l_connect())
      host_name = "";
	}

}


void
on_call_checkbutton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *cce, *ccl;

	cce = lookup_widget(GTK_WIDGET(togglebutton),"command_entry");
	ccl = lookup_widget(GTK_WIDGET(togglebutton),"command_label");

	gtk_entry_set_editable(GTK_ENTRY(cce),gtk_toggle_button_get_active(togglebutton));
	gtk_widget_set_sensitive(cce,gtk_toggle_button_get_active(togglebutton));
	gtk_widget_set_sensitive(ccl,gtk_toggle_button_get_active(togglebutton));
}


gboolean
on_preferences_dialog_key_press_event  (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if (event->keyval == GDK_Return) {
		on_preferences_okbutton_clicked(GTK_BUTTON(user_data),NULL);
		gtk_widget_destroy(widget);
	}
  return FALSE;
}

void
on_preferences_cancelbutton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  if ((!is_mini && (!GTK_WIDGET_VISIBLE(gtk_imonc) || !GTK_WIDGET_SENSITIVE(gtk_imonc))) || !fd)
    gtk_main_quit();
  else {
    GtkWidget *pref_dialog = lookup_widget(GTK_WIDGET(button),"preferences_dialog");
    gtk_widget_destroy(pref_dialog);
  }
}

void
on_admin_mode_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show (create_admin_mode_dialog ());
}


void
on_admin_mode_okbutton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	char buf[64];
	int answer;
	GtkWidget *admin_mode_dialog, *admin_mode_label, *admin_password;
	
	admin_mode_dialog = lookup_widget(GTK_WIDGET(button), "admin_mode_dialog");

	admin_password = lookup_widget(admin_mode_dialog, "admin_passwd");

	strcpy (admin_passwd, gtk_entry_get_text(GTK_ENTRY(admin_password)));

	if (salt) {
		gchar tmp[256];
		snprintf(tmp,256,"%s%s",admin_passwd,salt);
		sprintf (buf, "md5pass %s", hexmd5(tmp));
	} else
		sprintf (buf, "pass %s", admin_passwd);

	send_command(fd, buf);
	answer = atoi(get_answer(fd));

	if (answer >= 4) {
			
		imonc_auth_update(gtk_imonc); /* reinitialize imonc functionality */

		gtk_widget_destroy(admin_mode_dialog);
	} else {
		admin_mode_label = lookup_widget(admin_mode_dialog, "admin_mode_label");

		gtk_label_set_text(GTK_LABEL(admin_mode_label), _("Password Incorrect"));
		gtk_entry_set_text(GTK_ENTRY(admin_password), "");
	}

}

void
on_web_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *argv[3];
	argv[0] = "mozilla";
	argv[1] = HOMEPAGE_URL;
	argv[2] = NULL;

	g_spawn_async(NULL,argv,NULL,G_SPAWN_SEARCH_PATH,NULL,NULL,NULL,NULL);
}

void
on_opt_checkbutton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *rc_checkbutton;
	
	rc_checkbutton = lookup_widget(GTK_WIDGET(togglebutton),"rc_checkbutton");
	
	if (gtk_toggle_button_get_active(togglebutton))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rc_checkbutton),TRUE);
}

void
on_trayicon_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	extern EggTrayIcon *docklet;
	if (gtk_toggle_button_get_active(togglebutton)) {
		if (docklet == NULL)
			docklet_init();
		use_trayicon = TRUE;
	} else {
		if (docklet != NULL)
			docklet_destroy();
		use_trayicon = FALSE;
	}
}

gboolean
on_gtk_imonc_delete                    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	extern EggTrayIcon *docklet;
	GtkWidget *active_widget;

	if (docklet == NULL)
		gtk_main_quit();
	else {
	
		
		if (is_mini)
			active_widget = gtk_miniimonc;
		else
			active_widget = gtk_imonc;
		gtk_widget_hide (active_widget);
		gtk_window_get_position (GTK_WINDOW(active_widget), &root_x, &root_y);
		main_is_hidden = TRUE;
		return TRUE;
	}

  return FALSE;
}
