/*  gtk-imonc - imond client for fli4l
 *	library functions for communicating with router
 *  Copyright (C) 2001 Stefan Strigler <zeank@x-berg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <errno.h>
#include <stdio.h>

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

#include <gtk/gtk.h>

#define MAX_CIRCUITS    16
#define IMOND_PORT      5000
#define TELMOND_PORT    5001
#define GRANULARITY     8192
#define READ_TIMEOUT    5				/* timeout for broken tcp/ip connections */
#define ACK_STRING		"\006"		/* ACK = 0x06		    */
#define NAK_STRING		"\025"		/* NAK = 0x15		    */
#define ACK_CHAR		'\006'		/* ACK = 0x06		    */
#define NAK_CHAR		'\025'		/* NAK = 0x15		    */

int fd;
char *host_name;
int port;

/*----------------------------------------------------------------------------
 *  service_connect (host_name, port)	    - connect to tcp-service
 *----------------------------------------------------------------------------
 */
int service_connect (char *host_name, int port);


/*----------------------------------------------------------------------------
 *  service_disconnect (fd)		    - disconnect from service
 *----------------------------------------------------------------------------
 */
void service_disconnect (int fd);


/*----------------------------------------------------------------------------
 *  send_command (fd, str)               - send command str via fd
 *----------------------------------------------------------------------------
 */
void send_command (int fd, char *str);


/*----------------------------------------------------------------------------
 *  get_answer (fd)											- get answer from fd
 *----------------------------------------------------------------------------
 */
char *get_answer (int fd);


/*----------------------------------------------------------------------------
 *  get_lastcall (telmond_port)
 *  gets last incoming call from telmond
 *----------------------------------------------------------------------------
 */
char *get_lastcall (int telmond_port);

/*----------------------------------------------------------------------------
 *  get_list (fd, command)							- get list from command
 *----------------------------------------------------------------------------
 */
GSList *get_list (int fd, char *str);

/*----------------------------------------------------------------------------
 *  get_buf (fd, command)												- get complete buf from fd
 *----------------------------------------------------------------------------
 */
gchar *get_buf (int fd, char *str);


char *hexmd5(const char *string);
