#include <panel-applet.h>
#include <gconf/gconf-client.h>
#include <libgnomeui/libgnomeui.h>
#include <panel-applet-gconf.h>
#include <libgnomevfs/gnome-vfs.h>
#include <glade/glade.h>
#include <gtk/gtk.h>
#include <string.h>
#include "../libgtodo/libgtodo.h"
GTodoClient *client;
GtkWidget *image, *window;
PanelApplet *applet;
GConfClient *gconf_client;
GtkTooltips *tooltip = NULL;

#define UNIX_PATH_MAX 108
void start_gtodo(GtkWidget *wid, GTime id);
int check_for_notification_event();

void start_gtodo_no_id() { start_gtodo(NULL, 0); }
void start_gtodo_new_item() { start_gtodo(NULL, -2); }

static const BonoboUIVerb gtodo_applet_verbs [] = {
	BONOBO_UI_UNSAFE_VERB ("Add an todo item", start_gtodo_new_item),
	BONOBO_UI_UNSAFE_VERB ("Start Gtodo", start_gtodo_no_id),
	BONOBO_UI_VERB_END, 
};


int tooltip_for_applet()
{
	GTodoList *g_list;
	GTodoList *c_list;
	GString *string;
	string = g_string_new("Items that are due:\n");
	/* get the gtodo list */
	c_list = gtodo_client_get_category_list(client);
	if(c_list == NULL) return TRUE;
	do{

		g_list = gtodo_client_get_todo_item_list(client,gtodo_client_get_category_from_list(c_list));
		if(g_list != NULL)
		{
			g_string_append_printf(string,"%s\n", gtodo_client_get_category_from_list(c_list));
			gtodo_client_get_list_first(g_list);

			do{	
				GTodoItem *item = gtodo_client_get_todo_item_from_list(g_list);
				if(gtodo_todo_item_check_due(item) >= 0 && gtodo_todo_item_get_done(item) != TRUE)
				{
					g_string_append_printf(string, "* %s\n", gtodo_todo_item_get_summary(item));

				}


			}while(gtodo_client_get_list_next(g_list));
		}
		/* free the memory used in the todo list */
		gtodo_client_free_todo_item_list(client, g_list);
	}while(gtodo_client_get_list_next(c_list));
	gtodo_client_free_category_list(client, c_list);
	gtk_tooltips_set_tip(tooltip,GTK_WIDGET(applet), string->str,"");
	g_string_free(string, TRUE);
	return TRUE;
}




void start_gtodo(GtkWidget *wid, GTime id)
{
	gchar *command;

	if(id == -1) command = g_strdup("gtodo");
	else if(id == -2) command = g_strdup("gtodo -n");
	else command = g_strdup_printf("gtodo -s %i", (gint)id);
	g_print("%s\n", command);    
	g_spawn_command_line_async(command, NULL);
	g_free(command);    
}


/* load the image size it to the panel size with a 5 px border and draw it into the gtkimage */
void image_resize()
{
	GdkPixbuf *temp;
	GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file(DATADIR"/pixmaps/gtodo_tray.png", NULL);
	gint width = panel_applet_get_size(applet) -1;
	temp = gdk_pixbuf_scale_simple(pixbuf, width,width, GDK_INTERP_HYPER);
	gtk_image_set_from_pixbuf(GTK_IMAGE(image), temp);
	g_object_unref(temp);
	g_object_unref(pixbuf);
}

/* quick hack to make the right mouse menu work  */
gboolean button_press(GtkWidget *widget, GdkEventButton *event,PanelApplet *applet)
{
	if(event->button > 1)
	{
		gtk_propagate_event((GtkWidget *)applet, (GdkEvent *) event);
	}
	else
	{
		if(event->type == GDK_2BUTTON_PRESS)
		{
			start_gtodo(NULL, -1);
		}
	}
	return FALSE;
}

void reload_backend(GTodoClient *cl)
{
    /*
	check_for_notification_event();
    */
	   tooltip_for_applet();

}

static gboolean gtodo_applet_fill (PanelApplet *ap,   const gchar *iid,	gpointer     data)
{
	applet = ap; /* get a global pointer to the applet  */
	/* check if this is the good applet I guess, I just copied the stuff */
	if (strcmp (iid, "OAFIID:gtodo-applet") != 0)
		return FALSE;

	gnome_vfs_init();
	tooltip = gtk_tooltips_new();
	/* create an empty image that is placed on the button */
	image = gtk_image_new();
	/* now load and draw the image in the right size onto the toggle button */
	image_resize();
	/* function that resizes the image when the panel size is changed */
	g_signal_connect (applet,
			"change_size",
			G_CALLBACK (image_resize),
			NULL);

	gtk_container_add (GTK_CONTAINER (applet), image);

	/* show the applet */
	gtk_widget_show_all (GTK_WIDGET (applet));

	g_signal_connect(G_OBJECT(applet), "button_press_event", G_CALLBACK(button_press), NULL);
	/* start the gtodo backend */
	client = gtodo_client_new_default(NULL);
	if(client == NULL)
	{
		return FALSE;
	}
	/*
	   panel_applet_add_preferences (applet, "/schemas/apps/gtodo_applet/prefs", NULL);
	   */
	gconf_client = gconf_client_get_default();
	gconf_client_add_dir(gconf_client,
			"/apps/gtodo/prefs",
			GCONF_CLIENT_PRELOAD_NONE,
			NULL);
	if(gconf_client_get_bool(gconf_client, "/apps/gtodo/prefs/do_notification",NULL) == TRUE) 
		gconf_client_set_bool(gconf_client, "/apps/gtodo/prefs/do_notification",FALSE,NULL);
	/* fill the list with todo items */
	/* connect a signal that reload the signal when something changes */
	gtodo_client_set_changed_callback(client,(void *)reload_backend, NULL);

	gtk_timeout_add((60*5)*1000, check_for_notification_event, NULL);
	gtk_timeout_add((60*5)*1000, tooltip_for_applet, NULL);
	tooltip_for_applet();
	check_for_notification_event();

	panel_applet_setup_menu_from_file (applet,
			NULL,
			"gtodo-applet.xml",
			NULL, 
			gtodo_applet_verbs,
			NULL);
	return TRUE;
}


PANEL_APPLET_BONOBO_FACTORY ("OAFIID:gtodo_applet_Factory",
		PANEL_TYPE_APPLET,
		"Gtodo Applet",
		"0",
		gtodo_applet_fill,
		NULL);

