.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "GURGITATE-MAIL 1"
.TH GURGITATE-MAIL 1 "2006-06-07" "perl v5.8.8" "Gurgitate-Mail"
.SH "NAME"
gurgitate\-mail \- an easy\-to\-use mail filter
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
gurgitate-mail
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\f(CW\*(C`gurgitate\-mail\*(C'\fR is a program which reads your mail and filters
it according to the \fI.gurgitate\-rules.rb\fR file in your home
directory.  The configuration file uses Ruby syntax and is thus
quite flexible.
.PP
It's generally invoked either through your \fI.forward\fR file:
.PP
.Vb 1
\&    "|/path/to/gurgitate\-mail"
.Ve
.PP
Or through your \fI.procmailrc\fR file:
.PP
.Vb 2
\&    :0:
\&    | /path/to/gurgitate\-mail
.Ve
.PP
Alternatively, if you're the sysadmin at your site, or your sysadmin
is friendly, you can use gurgitate-mail as a local delivery agent.  For
postfix, put
.PP
.Vb 1
\&    mailbox_command=/opt/bin/gurgitate\-mail
.Ve
.PP
in \fI/etc/postfix/main.cf\fR.  If you use any other \s-1MTA\s0, and configure
gurgitate-mail as a local delivery agent, please tell me how!  I want to
include this in the documentation.
.SH "CONFIGURATION FILES"
.IX Header "CONFIGURATION FILES"
There are three configuration files used by gurgitate\-mail: two are 
system\-wide, and the third, is the user rules file.
.PP
The two system-wide configuration files are \fI/etc/gurgitate\-rules\fR and
\&\fI/etc/gurgitate\-rules\-default\fR.  These are processed before and
after the user rules, respectively.
.PP
\&\fI/etc/gurgitate\-rules\fR is used to handle system-wide filtering
needs: setting the default mailbox style to Maildir rather than
the default MBox, setting the spool directory, things like that.
.PP
The user configuration file is \fI$HOME/.gurgitate\-rules\fR (or,
alternatively, \fI$HOME/.gurgitate\-rules.rb\fR.  Either work).  You
put your own rules here.  If the user configuration file doesn't
encounter a \*(L"return\*(R" during processing, then the additional rules
contained in \fI/etc/gurgitate\-rules\-default\fR are run.  If that
also doesn't return, then mail messages are saved into the default
mail spool location.
.PP
If the \f(CW\*(C`\-f\*(C'\fR option is used on the commandline, then the file 
specified will be used and the default rules will not. The \f(CW\*(C`\-f\*(C'\fR
option can be used more than once:
.PP
.Vb 1
\&    gurgitate\-mail \-f test\-rules \-f additional\-rules
.Ve
.SH "CONFIGURATION PARAMETERS"
.IX Header "CONFIGURATION PARAMETERS"
There are several parameters that you can set to change the way that
gurgitate-mail behaves.  You set a config parameter by saying, for
instance:
.PP
.Vb 1
\&    sendmail "/usr/sbin/sendmail"
.Ve
.PP
which sets the \*(L"sendmail\*(R" parameter to \*(L"/usr/sbin/sendmail\*(R".
.IP "maildir" 5
.IX Item "maildir"
The directory you want to put mail folders into.  This defaults to
\&\f(CW$HOME\fR/Mail.
.IP "logfile" 5
.IX Item "logfile"
Where you went gurgitate\-mail's log messages to go to.  The standard
location for this is \f(CW$HOME\fR/.gurgitate.log
.IP "sendmail" 5
.IX Item "sendmail"
The full path to the sendmail program, used to deliver mail.  This
can be any program that takes as its parameters the list of addresses
to deliver mail to, and that takes a mail message on standard input.
.IP "homedir" 5
.IX Item "homedir"
The full path of your home directory.  This defaults to whatever your
actual home directory is.
.IP "spooldir" 5
.IX Item "spooldir"
The path where the system's mail spools goes to.  This defaults to
\&\*(L"/var/spool/mail\*(R".  On a Maildir system, this should be set to the
same as \*(L"homedir\*(R".
.IP "spoolfile" 5
.IX Item "spoolfile"
The mail spool file component of the full path of your mail spool.
This is generally your username.  Maildir users should set this to
\&\*(L"Maildir\*(R".
.IP "folderstyle" 5
.IX Item "folderstyle"
The style of folders you prefer.  This can be (at the moment) either
MBox or Maildir.
.SH "FILTER RULES"
.IX Header "FILTER RULES"
The filter rules are a series of Ruby statements, with the
following methods and variables available:
.Sh "Variables"
.IX Subsection "Variables"
.IP "from" 5
.IX Item "from"
This contains the envelope \*(L"from\*(R" address of the email message.
(Note that this isn't necessarily the same as the contents of the
\&\*(L"From:\*(R" header)
.IP "headers" 5
.IX Item "headers"
This is an object containing the headers of the message.  There
are several methods that come with this object:
.IP "body" 5
.IX Item "body"
This contains the body of the email message.  As of yet, there's
nothing really interesting which you can do with this, apart from
assigning to it; you can rewrite the body of an email message this
way.  Dealing with attachments is planned for a future release of
\&\f(CW\*(C`gurgitate\-mail\*(C'\fR.
.IP "maildir" 5
.IX Item "maildir"
The directory which contains the folders, used by the \f(CW\*(C`save\*(C'\fR
method when you specify a folder as "=\fIfolder\fR\*(L" (like Elm).
Defaults to \*(R"$HOME/Mail".
.IP "homedir" 5
.IX Item "homedir"
Your home directory.  Read\-only.
.IP "logfile" 5
.IX Item "logfile"
The location of the \f(CW\*(C`gurgitate\-mail\*(C'\fR logfile.  If set to \f(CW\*(C`nil\*(C'\fR,
then no logging is done.  Defaults to \*(L"$HOME/.gurgitate.log\*(R".
.IP "sendmail" 5
.IX Item "sendmail"
The location of the \f(CW\*(C`sendmail\*(C'\fR program.  Used by the \f(CW\*(C`forward\*(C'\fR
method.  Defaults to \*(L"/usr/lib/sendmail\*(R".
.IP "spoolfile" 5
.IX Item "spoolfile"
The location of the mail spool.  Read\-only.
.Sh "Methods"
.IX Subsection "Methods"
.IP "matches(name(s),regex)" 5
.IX Item "matches(name(s),regex)"
Returns \f(CW\*(C`true\*(C'\fR if the header \f(CW\*(C`name\*(C'\fR matches the regular
expression \f(CW\*(C`regex\*(C'\fR.  If \f(CW\*(C`name\*(C'\fR is an array of header names, then
it returns true if at least one of the headers matches.  Useful
for testing whether both \*(L"To:\*(R" and \*(L"Cc:\*(R" headers match.
.IP "from" 5
.IX Item "from"
Returns the envelope \*(L"from\*(R" address of the email message.  Note
that this is the same as the bare \*(L"from\*(R".
.IP "to" 5
.IX Item "to"
Returns a HeaderBag (a kind of array) with the contents of the
\&\*(L"To\*(R" and the \*(L"Cc\*(R" headers.
.IP "to_s" 5
.IX Item "to_s"
As per Ruby convention, returns all the headers as a \f(CW\*(C`String\*(C'\fR object.
.IP "save(mailbox)" 5
.IX Item "save(mailbox)"
This saves the message to a mailbox.  You can specify the mailbox
as a word with an = sign in front of it, in which case it puts it
into \f(CW\*(C`maildir\*(C'\fR.  If you don't use the =\fIname\fR format, then you
need to specify an absolute pathname.  If it can't write the
message to the file you request it to, it'll attempt to write it
to \f(CW\*(C`spoolfile\*(C'\fR.
.IP "forward(address)" 5
.IX Item "forward(address)"
This forwards the email message to another email address.
.IP "pipe(program)" 5
.IX Item "pipe(program)"
This pipes the message through \f(CW\*(C`program\*(C'\fR.  \f(CW\*(C`pipe\*(C'\fR returns the
exit code of the program that the message was piped through.
.IP "filter(program)" 5
.IX Item "filter(program)"
This pipes the message through \f(CW\*(C`program\*(C'\fR and returns a new
Gurgitate object containing the filtered mail.  (This is handy
for external filters which modify email like, for example,
SpamAssassin, which adds a spam-score header.)
.Sp
You can also say
.Sp
.Vb 3
\&    filter(program) do
\&        # code here
\&    end
.Ve
.Sp
and it yields the newly-created Gurgitate object to the block.
.IP "headers" 5
.IX Item "headers"
This returns the headers as an object of their own.  This object
has its own methods:
.RS 5
.IP "headers[*headernames]" 5
.IX Item "headers[*headernames]"
This returns a HeaderBag (a subclass of array) containing the
headers you asked for.  You can then use the =~ operator on this
result to match the \s-1RHS\s0 regex with everything in the HeaderBag.
.Sp
You can change a header's value with \f(CW\*(C`headers[name]=newvalue\*(C'\fR.
.IP "headers.match(name,regex)" 5
.IX Item "headers.match(name,regex)"
Matches the header with the name \*(L"name\*(R" against the regex.  This
is the same as headers[name] =~ /regex/.
.IP "headers.matches(names,regex)" 5
.IX Item "headers.matches(names,regex)"
Matches the headers with the names \*(L"names\*(R" against the regex.
This is the same as headers[*names] =~ /regex/.
.IP "headers.from" 5
.IX Item "headers.from"
Returns the envelope from.  You can change this with
\&\f(CW\*(C`headers.from=newaddress\*(C'\fR too.
.RE
.RS 5
.RE
.IP "return" 5
.IX Item "return"
This tells \f(CW\*(C`gurgitate\-mail\*(C'\fR to stop processing the email message.
If you don't use \f(CW\*(C`return\*(C'\fR, then \f(CW\*(C`gurgitate\-mail\*(C'\fR will continue
processing the same mail again with the next rule.  If there isn't
a \f(CW\*(C`return\*(C'\fR at the end of \fIgurgitate\-rules.rb\fR, then
\&\f(CW\*(C`gurgitate\-mail\*(C'\fR will save the email message in the normal mail
spool.
.IP "log(message)" 5
.IX Item "log(message)"
This writes a log message to the log file.
.SH "SIMPLE EXAMPLES"
.IX Header "SIMPLE EXAMPLES"
Here are some examples of \f(CW\*(C`gurgitate\-mail\*(C'\fR rules, with
explanations:
.PP
.Vb 1
\&    if from =~ /ebay.com/ then save("=ebay"); return; end
.Ve
.PP
Any email from eBay (automatic end-of-auction notifications, for
example, and outbid notices) gets filed into the \*(L"ebay\*(R" folder.
.PP
.Vb 1
\&    if from =~ /root@/ then save("=root"); return; end
.Ve
.PP
Any email from root (at any host) gets filed into a special
folder.  Useful for sysadmins monitoring crontab email.
.PP
.Vb 4
\&    if headers.matches(["To","Cc"],"webmaster@") then
\&        save("=webmaster")
\&        return
\&    end
.Ve
.PP
Any email with a To: or Cc: line of \*(L"sysadmin\*(R" is saved to a
\&\*(L"sysadmin\*(R" folder.  Useful for people with multiple role accounts
redirected to their address.
.PP
.Vb 4
\&    if headers["Subject"] =~ /\e[SPAM\e]/ then
\&        save("=spam")
\&        return
\&    end
.Ve
.PP
This is a different syntax for matching patterns against headers.
You can also match multiple headers in the square brackets.
.PP
.Vb 4
\&    if headers["Subject","Keywords"] =~ /a bad word/ then
\&        save("=swearing")
\&        return
\&    end
.Ve
.PP
Searches for \*(L"a bad word\*(R" in the Subject and Keywords headers, and
if it's there, saves the email in the \*(L"swearing\*(R" folder.
.PP
.Vb 4
\&    if headers.matches(["To","Cc"],"mailing\-list@example.com") then
\&        pipe("|rcvstore +mailing\-list")
\&        return
\&    end
.Ve
.PP
Any email to a mailing list is piped through \*(L"rcvstore\*(R" to store
it into an \s-1MH\s0 folder.
.PP
That
.PP
.Vb 1
\&    headers.matches(["To","Cc"],/regex/)
.Ve
.PP
idiom happens often enough that there's a shorthand for it:
.PP
.Vb 4
\&    if to =~ /mailing\-list@example.com/ then
\&        pipe("|rcvstore +mailing\-list")
\&        return
\&    end
.Ve
.PP
Pipes the mail to the mailing list through \*(L"rcvstore\*(R".
.SH "ADVANCED EXAMPLES"
.IX Header "ADVANCED EXAMPLES"
Here are some slightly more clever examples to give you an idea
of what you can do with \f(CW\*(C`gurgitate\-mail\*(C'\fR.  Let's suppose you have
an email whitelist in a file called \fI$HOME/.friends\fR, so you can
determine whether some email is likely to be spam or not.
.PP
Then if someone on your whitelist sends you email, then you
automatically save that into the \*(L"inbox\*(R" folder:
.PP
.Vb 10
\&    friends=homedir+"/.friends"
\&    if FileTest.exists?(friends) and FileTest.readable?(friends) then
\&        File.new(friends).each do |friend|
\&            if from =~ friend.chomp then
\&                log "Mail from friend "+friend.chomp
\&                save("=inbox")
\&                return
\&            end
\&        end
\&    end
.Ve
.PP
Okay, if someone sends you email, and it's addressed specifically
to you (and gurgitate-mail hasn't caught it in another form already),
then it might or might not be spam: put it into a \*(L"grey\*(R" folder:
.PP
.Vb 9
\&    my_addresses= [ /me@example\e.com/i,
\&                    /me@example\e.org/i,
\&                    /me@example\e.net/i];  # I have three email addresses
\&    my_addresses.each do |addr|
\&        if headers.matches(["To","Cc"],addr) then
\&            save("=possibly\-not\-spam")
\&            return
\&        end
\&    end
.Ve
.PP
And after that, if it's not from someone you know, and it's not
addressed to your email address either, then it's probably save to
assume that it's spam:
.PP
.Vb 2
\&    save("=spam")
\&    return
.Ve
.PP
This can be improved by using a Bayesian filter, though; for
example, Eric Raymond's bogofilter program
(http://bogofilter.sourceforge.net) can be automatically trained
and used with the help of the white/grey/black distinctions.
Taking the example above, I'll adjust it by adding in calls to
bogofilter:
.PP
.Vb 11
\&    friends=homedir+"/.friends"
\&    if FileTest.exists?(friends) and FileTest.readable?(friends) then
\&        File.new(friends).each do |friend|
\&            if from =~ friend.chomp then
\&                log "Mail from friend "+friend.chomp
\&                pipe("bogofilter \-h")  # <\-\- LINE ADDED HERE
\&                save("=inbox")
\&                return
\&            end
\&        end
\&    end
.Ve
.PP
\&\f(CW\*(C`bogofilter \-h\*(C'\fR trains bogofilter that mail from whitelisted-people 
is not to be considered spam.  Okay, at the end of the
\&.gurgitate\-rules, change
.PP
.Vb 2
\&    save("=spam")
\&    return
.Ve
.PP
to
.PP
.Vb 3
\&    save("=spam")
\&    pipe("bogofilter \-s")
\&    return
.Ve
.PP
This trains \f(CW\*(C`bogofilter\*(C'\fR that anything which doesn't pass the
rest of the filter should be considered spam.  Now for the
interesting bit: Change the bit between these to use \*(L"bogofilter\*(R"
to decide whether email is to be considered spam or not:
.PP
.Vb 16
\&    my_addresses= [ /me@example\e.com/i,
\&                    /me@example\e.org/i,
\&                    /me@example\e.net/i];  # I have three email addresses
\&    my_addresses.each do |addr|
\&        if headers.matches(["To","Cc"],addr) then
\&            if pipe("bogofilter")==1
\&            then
\&                log("bogofilter suspects it might not be spam")
\&                save("=possibly\-not\-spam")
\&            else
\&                log("bogofilter thinks it's probably spam")
\&                save("=spam")
\&            end
\&            return
\&        end
\&    end
.Ve
.PP
\&\f(CW\*(C`bogofilter\*(C'\fR has an exit code of \*(L"1\*(R" if it thinks the message is
not spam, and \*(L"0\*(R" if it thinks the message is spam.
.PP
Hopefully this should give you an idea of the kinds of things that
you can use \f(CW\*(C`bogofilter\*(C'\fR for.
.SH "AUTHOR"
.IX Header "AUTHOR"
Dave Brown <gurgitate\-mail@dagbrown.com>
