module HAppS.MACID.SideEffect(startSideRunner, SideEffect(..)) where

import Control.Concurrent
import Control.Exception
import Control.Monad
import qualified Data.ByteString.Char8 as P
import HAppS.MACID.Saver
import HAppS.MACID.Types
import HAppS.Util.TimeOut
import System.Log.Logger

logMS = logM "HAppS.MACID.SideEffect"

data SideEffect = SideEffect TxId [(Seconds, IO ())]
                | Sequence SaverImpl (IO ())
                | SwitchNow SaverImpl (IO ())

startSideRunner :: Int -> SaverImpl -> IO (Chan SideEffect)
startSideRunner threads simpl = do
    chs <- newChan
    dv  <- newEmptyMVar
    forkIO $ sideRunner threads chs 0 dv simpl
    return chs

-- FIXME: 'threads', 'chs' and 'done' can be hoisted out of the loop.
sideRunner :: Int -> Chan SideEffect -> Int -> MVar () -> SaverImpl -> IO ()
sideRunner threads chs pending done saver = do
    se  <- readChan chs
    cur <- getNDone done
    let pending' = pending - cur
    case se of
      SideEffect txid ses -> do logMS NOTICE $ unwords ["sideRunner: txid",show txid,"wait",show $ map fst ses]
                                let fin = saverAdd saver [P.pack $ shows txid "\n"] (putMVar done ())
                                    effects = [withSafeTimeOutMaybe (t*second) v | (t,v) <- ses]
                                forkIO (spawner threads effects `finally` fin)
                                sideRunner threads chs (pending' + 1) done saver
      Sequence new act    -> do logMS NOTICE ("SEQUENCE 0: "++show pending')
                                replicateM_ pending' $ takeMVar done -- Wait for all side-effects to terminate.
                                logMS NOTICE "SEQUENCE E"
                                saverClose saver
                                act
                                sideRunner threads chs 0 done new
      SwitchNow new act   -> do saverClose saver
                                act
                                sideRunner threads chs pending' done new

getNDone :: MVar () -> IO Int
getNDone mv = loop 0 where loop k = maybe (return k) (\_ -> loop (k+1)) =<< tryTakeMVar mv

spawner :: Int -> [IO a] -> IO ()
spawner threads actions
    = do qsem <- newQSem threads
         flip mapM_ actions $ \action -> waitQSem qsem >> forkIO (void action `finally` signalQSem qsem)
         replicateM_ threads (waitQSem qsem)
    where void x = x >> return ()
