{-# OPTIONS -fno-cse #-}
module HAppS.Protocols.HTTP.Clock(getApproximateTime) where

import Control.Concurrent
import Data.IORef
import System.IO.Unsafe
import System.Time

{-# NOINLINE clock #-}
clock :: IORef ClockTime
clock = unsafePerformIO $ do
  ref <- newIORef =<< getClockTime
  forkIO $ updater ref
  return ref

updater :: IORef ClockTime -> IO ()
updater ref = do threadDelay 1000000
                 writeIORef ref =<< getClockTime
                 updater ref

getApproximateTime :: IO ClockTime
getApproximateTime = readIORef clock
