module Hat.Data.FiniteMap
  (FiniteMap(),gemptyFM,gunitFM,aunitFM,hunitFM,glistToFM,glookupFM,alookupFM
    ,hlookupFM,glookupWithDefaultFM,alookupWithDefaultFM,hlookupWithDefaultFM
    ,gelemFM,aelemFM,helemFM,gaddToFM,aaddToFM,haddToFM,gaddToFM_C,aaddToFM_C
    ,haddToFM_C,gaddListToFM,aaddListToFM,haddListToFM,gaddListToFM_C
    ,aaddListToFM_C,haddListToFM_C,gdelFromFM,adelFromFM,hdelFromFM
    ,gdelListFromFM,adelListFromFM,hdelListFromFM,gplusFM,aplusFM,hplusFM
    ,gplusFM_C,aplusFM_C,hplusFM_C,gfmToList,afmToList,hfmToList,gkeysFM,akeysFM
    ,hkeysFM,geltsFM,aeltsFM,heltsFM,gsizeFM,asizeFM,hsizeFM,gisEmptyFM
    ,aisEmptyFM,hisEmptyFM,gminusFM,aminusFM,hminusFM,gfoldFM,afoldFM,hfoldFM
    ,gintersectFM,aintersectFM,hintersectFM,gintersectFM_C,aintersectFM_C
    ,hintersectFM_C,gmapFM,amapFM,hmapFM,gfilterFM,afilterFM,hfilterFM) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 
import Hat.Data.Maybe  (gisJust,aisJust,hisJust)

gemptyFM :: T.RefSrcPos -> T.RefExp -> T.R (FiniteMap key elt)

semptyFM :: T.R (FiniteMap key elt)

gunitFM ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun key (T.Fun elt (FiniteMap key elt)))

hunitFM :: (T.R key) -> (T.R elt) -> T.RefExp -> T.R (FiniteMap key elt)

glistToFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.List (T.Tuple2 key elt)) (FiniteMap key elt))

slistToFM ::
  Ord key => T.R (T.Fun (T.List (T.Tuple2 key elt)) (FiniteMap key elt))

gaddToFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (FiniteMap key elt) (T.Fun key (T.Fun elt (FiniteMap key elt))))

haddToFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R key) -> (T.R elt) -> T.RefExp -> T.R (FiniteMap key elt)

gaddListToFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (FiniteMap key elt)
          (T.Fun (T.List (T.Tuple2 key elt)) (FiniteMap key elt)))

haddListToFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R (T.List (T.Tuple2 key elt))) -> T.RefExp -> T.R (FiniteMap key elt)

gaddToFM_C ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun elt (T.Fun elt elt))
          (T.Fun (FiniteMap key elt)
            (T.Fun key (T.Fun elt (FiniteMap key elt)))))

haddToFM_C ::
  Ord key =>
  (T.R (T.Fun elt (T.Fun elt elt))) ->
    (T.R (FiniteMap key elt)) ->
      (T.R key) -> (T.R elt) -> T.RefExp -> T.R (FiniteMap key elt)

gaddListToFM_C ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun elt (T.Fun elt elt))
          (T.Fun (FiniteMap key elt)
            (T.Fun (T.List (T.Tuple2 key elt)) (FiniteMap key elt))))

haddListToFM_C ::
  Ord key =>
  (T.R (T.Fun elt (T.Fun elt elt))) ->
    (T.R (FiniteMap key elt)) ->
      (T.R (T.List (T.Tuple2 key elt))) -> T.RefExp -> T.R (FiniteMap key elt)

gdelFromFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.Fun key (FiniteMap key elt)))

hdelFromFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) -> (T.R key) -> T.RefExp -> T.R (FiniteMap key elt)

gdelListFromFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (FiniteMap key elt) (T.Fun (T.List key) (FiniteMap key elt)))

hdelListFromFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R (T.List key)) -> T.RefExp -> T.R (FiniteMap key elt)

gplusFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (FiniteMap key elt)
          (T.Fun (FiniteMap key elt) (FiniteMap key elt)))

hplusFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gplusFM_C ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun elt (T.Fun elt elt))
          (T.Fun (FiniteMap key elt)
            (T.Fun (FiniteMap key elt) (FiniteMap key elt))))

hplusFM_C ::
  Ord key =>
  (T.R (T.Fun elt (T.Fun elt elt))) ->
    (T.R (FiniteMap key elt)) ->
      (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gminusFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (FiniteMap key elt)
          (T.Fun (FiniteMap key elt) (FiniteMap key elt)))

hminusFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gintersectFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (FiniteMap key elt)
          (T.Fun (FiniteMap key elt) (FiniteMap key elt)))

hintersectFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gintersectFM_C ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun elt1 (T.Fun elt2 elt3))
          (T.Fun (FiniteMap key elt1)
            (T.Fun (FiniteMap key elt2) (FiniteMap key elt3))))

hintersectFM_C ::
  Ord key =>
  (T.R (T.Fun elt1 (T.Fun elt2 elt3))) ->
    (T.R (FiniteMap key elt1)) ->
      (T.R (FiniteMap key elt2)) -> T.RefExp -> T.R (FiniteMap key elt3)

gfoldFM ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun key (T.Fun elt (T.Fun a a)))
          (T.Fun a (T.Fun (FiniteMap key elt) a)))

hfoldFM ::
  (T.R (T.Fun key (T.Fun elt (T.Fun a a)))) ->
    (T.R a) -> (T.R (FiniteMap key elt)) -> T.RefExp -> T.R a

gmapFM ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun key (T.Fun elt1 elt2))
          (T.Fun (FiniteMap key elt1) (FiniteMap key elt2)))

hmapFM ::
  (T.R (T.Fun key (T.Fun elt1 elt2))) ->
    (T.R (FiniteMap key elt1)) -> T.RefExp -> T.R (FiniteMap key elt2)

gfilterFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun key (T.Fun elt Bool))
          (T.Fun (FiniteMap key elt) (FiniteMap key elt)))

hfilterFM ::
  Ord key =>
  (T.R (T.Fun key (T.Fun elt Bool))) ->
    (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gsizeFM :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) Int)

hsizeFM :: (T.R (FiniteMap key elt)) -> T.RefExp -> T.R Int

gisEmptyFM :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) Bool)

hisEmptyFM :: (T.R (FiniteMap key elt)) -> T.RefExp -> T.R Bool

gelemFM ::
  Ord key =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun key (T.Fun (FiniteMap key elt) Bool))

helemFM ::
  Ord key => (T.R key) -> (T.R (FiniteMap key elt)) -> T.RefExp -> T.R Bool

glookupFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.Fun key (Maybe elt)))

hlookupFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) -> (T.R key) -> T.RefExp -> T.R (Maybe elt)

glookupWithDefaultFM ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.Fun elt (T.Fun key elt)))

hlookupWithDefaultFM ::
  Ord key =>
  (T.R (FiniteMap key elt)) -> (T.R elt) -> (T.R key) -> T.RefExp -> T.R elt

gfmToList ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.List (T.Tuple2 key elt)))

hfmToList ::
  (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (T.List (T.Tuple2 key elt))

gkeysFM ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.List key))

hkeysFM :: (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (T.List key)

geltsFM ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.List elt))

heltsFM :: (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (T.List elt)

data FiniteMap key elt =
  EmptyFM 
  | Branch
    (T.R key) (T.R elt) !(T.R Int) (T.R (FiniteMap key elt))
    (T.R (FiniteMap key elt))

instance T.WrapVal ((FiniteMap key elt))
  where
  
  wrapVal pwrapVal (kwrapVal@EmptyFM) p =
    T.R kwrapVal (T.mkValueUse p pwrapVal aEmptyFM)
  wrapVal pwrapVal
    (kwrapVal@(Branch (T.R _ z1wrapVal) (T.R _ z2wrapVal) (T.R _ z3wrapVal)
        (T.R _ z4wrapVal) (T.R _ z5wrapVal))) p =
    T.R kwrapVal
      (T.mkValueApp5 p pwrapVal aBranch z1wrapVal z2wrapVal z3wrapVal z4wrapVal
        z5wrapVal)
  

instance (Show a,Show b) => Show ((FiniteMap a b))
  where
  
  gshow pshow p =
    T.ufun1 a93v3v100v73show pshow p hshow
    where
    
    hshow fm p =
      T.uwrapForward p
        (((T.fromLitString T.mkNoSrcPos p "{")
            *++
            (T.uwrapForward p
              (((T.uwrapForward p
                    (((gaddCommas T.mkNoSrcPos p)
                        *$
                        (T.uwrapForward p (helems fm p))) p))
                  *++
                  (T.fromLitString T.mkNoSrcPos p "}")) p))) p)
      where
      
      gaddCommas paddCommas p =
        T.ufun1 a96v7v98v49addCommas paddCommas p haddCommas
      
      aaddCommas = a96v7v98v49addCommas
      
      haddCommas (T.R T.List _) p = T.fromLitString T.mkNoSrcPos p ""
      haddCommas (T.R (T.Cons fx (T.R T.List _)) _) p =
        T.projection T.mkNoSrcPos p fx
      haddCommas (T.R (T.Cons fx fxs) _) p =
        T.uwrapForward p
          ((fx
              *++
              (T.uwrapForward p
                (((T.fromLitString T.mkNoSrcPos p ",")
                    *++
                    (T.uwrapForward p (haddCommas fxs p))) p))) p)
      haddCommas _ p = T.fatal p
      
      gelems pelems p = T.ufun1 a100v7v100v73elems pelems p helems
      
      aelems = a100v7v100v73elems
      
      helems ffm p =
        T.uwrapForward p
          (hmap
            (T.ufun1 T.mkLambda T.mkNoSrcPos p
              (\ v100v23v100v59v1 p ->
                case (v100v23v100v59v1) of
                  (T.R (T.Tuple2 fx fy) _) ->
                    T.uwrapForward p
                      (((T.uap1 T.mkNoSrcPos p (gshow T.mkNoSrcPos p) fx)
                          *++
                          (T.uwrapForward p
                            (((T.fromLitString T.mkNoSrcPos p " |-> ")
                                *++
                                (T.uap1 T.mkNoSrcPos p (gshow T.mkNoSrcPos p)
                                  fy)) p))) p)
                  _ -> T.fatal p)) (T.uwrapForward p (hfmToList ffm p)) p)
      
    
  

gemptyFM pemptyFM p = T.uconstUse pemptyFM p semptyFM

semptyFM =
  T.uconstDef T.mkRoot aemptyFM (\ p -> T.con0 T.mkNoSrcPos p EmptyFM aEmptyFM)

gunitFM punitFM p = T.ufun2 aunitFM punitFM p hunitFM

hunitFM fkey felt p =
  T.con5 T.mkNoSrcPos p Branch aBranch fkey felt
    (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 1)) (gemptyFM T.mkNoSrcPos p)
    (gemptyFM T.mkNoSrcPos p)

glistToFM plistToFM p = T.uconstUse plistToFM p slistToFM

slistToFM =
  T.uconstDef T.mkRoot alistToFM
    (\ p ->
      T.uap1 T.mkNoSrcPos p (gaddListToFM T.mkNoSrcPos p)
        (gemptyFM T.mkNoSrcPos p))

gaddToFM paddToFM p = T.ufun3 aaddToFM paddToFM p haddToFM

haddToFM ffm fkey felt p =
  T.uwrapForward p
    (haddToFM_C
      (T.ufun2 T.mkLambda T.mkNoSrcPos p
        (\ fold fnew p -> T.projection T.mkNoSrcPos p fnew)) ffm fkey felt p)

gaddToFM_C paddToFM_C p = T.ufun4 aaddToFM_C paddToFM_C p haddToFM_C

haddToFM_C fcombiner (T.R EmptyFM _) fkey felt p =
  T.uwrapForward p (hunitFM fkey felt p)
haddToFM_C fcombiner (T.R (Branch fkey felt fsize ffm_l ffm_r) _) fnew_key
  fnew_elt p =
  T.uccase T.mkNoSrcPos p
    (let
      v109v5v112v64v1 (T.R LT _) p =
        T.uwrapForward p
          (hmkBalBranch fkey felt
            (T.uwrapForward p (haddToFM_C fcombiner ffm_l fnew_key fnew_elt p))
            ffm_r p)
      v109v5v112v64v1 (T.R GT _) p =
        T.uwrapForward p
          (hmkBalBranch fkey felt ffm_l
            (T.uwrapForward p (haddToFM_C fcombiner ffm_r fnew_key fnew_elt p))
            p)
      v109v5v112v64v1 (T.R EQ _) p =
        T.con5 T.mkNoSrcPos p Branch aBranch fnew_key
          (T.uap2 T.mkNoSrcPos p fcombiner felt fnew_elt) fsize ffm_l ffm_r
      v109v5v112v64v1 _ p = T.fatal p in (v109v5v112v64v1))
    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fnew_key fkey)
haddToFM_C _ _ _ _ p = T.fatal p

gaddListToFM paddListToFM p = T.ufun2 aaddListToFM paddListToFM p haddListToFM

haddListToFM ffm fkey_elt_pairs p =
  T.uwrapForward p
    (haddListToFM_C
      (T.ufun2 T.mkLambda T.mkNoSrcPos p
        (\ fold fnew p -> T.projection T.mkNoSrcPos p fnew)) ffm fkey_elt_pairs
      p)

gaddListToFM_C paddListToFM_C p =
  T.ufun3 aaddListToFM_C paddListToFM_C p haddListToFM_C

haddListToFM_C fcombiner ffm fkey_elt_pairs p =
  T.uwrapForward p (hfoldl (gadd T.mkNoSrcPos p) ffm fkey_elt_pairs p)
  where
  
  gadd padd p = T.ufun2 a118v5v118v56add padd p hadd
  
  aadd = a118v5v118v56add
  
  hadd ffmap (T.R (T.Tuple2 fkey felt) _) p =
    T.uwrapForward p (haddToFM_C fcombiner ffmap fkey felt p)
  hadd _ _ p = T.fatal p
  

gdelFromFM pdelFromFM p = T.ufun2 adelFromFM pdelFromFM p hdelFromFM

hdelFromFM (T.R EmptyFM _) fdel_key p = gemptyFM T.mkNoSrcPos p
hdelFromFM (T.R (Branch fkey felt fsize ffm_l ffm_r) _) fdel_key p =
  T.uccase T.mkNoSrcPos p
    (let
      v122v5v125v31v1 (T.R GT _) p =
        T.uwrapForward p
          (hmkBalBranch fkey felt ffm_l
            (T.uwrapForward p (hdelFromFM ffm_r fdel_key p)) p)
      v122v5v125v31v1 (T.R LT _) p =
        T.uwrapForward p
          (hmkBalBranch fkey felt
            (T.uwrapForward p (hdelFromFM ffm_l fdel_key p)) ffm_r p)
      v122v5v125v31v1 (T.R EQ _) p = T.uwrapForward p (hglueBal ffm_l ffm_r p)
      v122v5v125v31v1 _ p = T.fatal p in (v122v5v125v31v1))
    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fdel_key fkey)
hdelFromFM _ _ p = T.fatal p

gdelListFromFM pdelListFromFM p =
  T.ufun2 adelListFromFM pdelListFromFM p hdelListFromFM

hdelListFromFM ffm fkeys p =
  T.uwrapForward p (hfoldl (gdelFromFM T.mkNoSrcPos p) ffm fkeys p)

gplusFM_C pplusFM_C p = T.ufun3 aplusFM_C pplusFM_C p hplusFM_C

hplusFM_C fcombiner (T.R EmptyFM _) ffm2 p = T.projection T.mkNoSrcPos p ffm2
hplusFM_C fcombiner ffm1 (T.R EmptyFM _) p = T.projection T.mkNoSrcPos p ffm1
hplusFM_C fcombiner ffm1 (T.R (Branch fsplit_key felt2 _ fleft fright) _) p =
  T.uwrapForward p
    (hmkVBalBranch fsplit_key (gnew_elt T.mkNoSrcPos p)
      (T.uwrapForward p (hplusFM_C fcombiner (glts T.mkNoSrcPos p) fleft p))
      (T.uwrapForward p (hplusFM_C fcombiner (ggts T.mkNoSrcPos p) fright p)) p)
  where
  
  glts plts p = T.uconstUse plts p slts
  
  slts =
    T.uconstDef p a136v5v136v35lts
      (\ p -> T.uwrapForward p (hsplitLT ffm1 fsplit_key p))
  
  ggts pgts p = T.uconstUse pgts p sgts
  
  sgts =
    T.uconstDef p a137v5v137v35gts
      (\ p -> T.uwrapForward p (hsplitGT ffm1 fsplit_key p))
  
  gnew_elt pnew_elt p = T.uconstUse pnew_elt p snew_elt
  
  snew_elt =
    T.uconstDef p a138v5v140v47new_elt
      (\ p ->
        T.uccase T.mkNoSrcPos p
          (let
            v138v15v140v47v1 (T.R Nothing _) p =
              T.projection T.mkNoSrcPos p felt2
            v138v15v140v47v1 (T.R (Just felt1) _) p =
              T.uap2 T.mkNoSrcPos p fcombiner felt1 felt2
            v138v15v140v47v1 _ p = T.fatal p in (v138v15v140v47v1))
          (T.uwrapForward p (hlookupFM ffm1 fsplit_key p)))
  
hplusFM_C _ _ _ p = T.fatal p

gplusFM pplusFM p = T.ufun2 aplusFM pplusFM p hplusFM

hplusFM (T.R EmptyFM _) ffm2 p = T.projection T.mkNoSrcPos p ffm2
hplusFM ffm1 (T.R EmptyFM _) p = T.projection T.mkNoSrcPos p ffm1
hplusFM ffm1 (T.R (Branch fsplit_key felt1 _ fleft fright) _) p =
  T.uwrapForward p
    (hmkVBalBranch fsplit_key felt1
      (T.uwrapForward p (hplusFM (glts T.mkNoSrcPos p) fleft p))
      (T.uwrapForward p (hplusFM (ggts T.mkNoSrcPos p) fright p)) p)
  where
  
  glts plts p = T.uconstUse plts p slts
  
  slts =
    T.uconstDef p a147v5v147v35lts
      (\ p -> T.uwrapForward p (hsplitLT ffm1 fsplit_key p))
  
  ggts pgts p = T.uconstUse pgts p sgts
  
  sgts =
    T.uconstDef p a148v5v148v35gts
      (\ p -> T.uwrapForward p (hsplitGT ffm1 fsplit_key p))
  
hplusFM _ _ p = T.fatal p

gminusFM pminusFM p = T.ufun2 aminusFM pminusFM p hminusFM

hminusFM (T.R EmptyFM _) ffm2 p = gemptyFM T.mkNoSrcPos p
hminusFM ffm1 (T.R EmptyFM _) p = T.projection T.mkNoSrcPos p ffm1
hminusFM ffm1 (T.R (Branch fsplit_key felt _ fleft fright) _) p =
  T.uwrapForward p
    (hglueVBal (T.uwrapForward p (hminusFM (glts T.mkNoSrcPos p) fleft p))
      (T.uwrapForward p (hminusFM (ggts T.mkNoSrcPos p) fright p)) p)
  where
  
  glts plts p = T.uconstUse plts p slts
  
  slts =
    T.uconstDef p a156v5v156v31lts
      (\ p -> T.uwrapForward p (hsplitLT ffm1 fsplit_key p))
  
  ggts pgts p = T.uconstUse pgts p sgts
  
  sgts =
    T.uconstDef p a157v5v157v31gts
      (\ p -> T.uwrapForward p (hsplitGT ffm1 fsplit_key p))
  
hminusFM _ _ p = T.fatal p

gintersectFM pintersectFM p = T.ufun2 aintersectFM pintersectFM p hintersectFM

hintersectFM ffm1 ffm2 p =
  T.uwrapForward p
    (hintersectFM_C
      (T.ufun2 T.mkLambda T.mkNoSrcPos p
        (\ fleft fright p -> T.projection T.mkNoSrcPos p fright)) ffm1 ffm2 p)

gintersectFM_C pintersectFM_C p =
  T.ufun3 aintersectFM_C pintersectFM_C p hintersectFM_C

hintersectFM_C fcombiner ffm1 (T.R EmptyFM _) p = gemptyFM T.mkNoSrcPos p
hintersectFM_C fcombiner (T.R EmptyFM _) ffm2 p = gemptyFM T.mkNoSrcPos p
hintersectFM_C fcombiner ffm1 (T.R (Branch fsplit_key felt2 _ fleft fright) _)
  p =
  T.ucguard (T.uwrapForward p (hisJust (gmaybe_elt1 T.mkNoSrcPos p) p))
    (T.uwrapForward p
      (hmkVBalBranch fsplit_key
        (T.uap2 T.mkNoSrcPos p fcombiner (gelt1 T.mkNoSrcPos p) felt2)
        (T.uwrapForward p
          (hintersectFM_C fcombiner (glts T.mkNoSrcPos p) fleft p))
        (T.uwrapForward p
          (hintersectFM_C fcombiner (ggts T.mkNoSrcPos p) fright p)) p))
    (T.ucguard (gotherwise T.mkNoSrcPos p)
      (T.uwrapForward p
        (hglueVBal
          (T.uwrapForward p
            (hintersectFM_C fcombiner (glts T.mkNoSrcPos p) fleft p))
          (T.uwrapForward p
            (hintersectFM_C fcombiner (ggts T.mkNoSrcPos p) fright p)) p))
      (T.fatal p))
  where
  
  glts plts p = T.uconstUse plts p slts
  
  slts =
    T.uconstDef p a172v5v172v31lts
      (\ p -> T.uwrapForward p (hsplitLT ffm1 fsplit_key p))
  
  ggts pgts p = T.uconstUse pgts p sgts
  
  sgts =
    T.uconstDef p a173v5v173v31gts
      (\ p -> T.uwrapForward p (hsplitGT ffm1 fsplit_key p))
  
  gmaybe_elt1 pmaybe_elt1 p = T.uconstUse pmaybe_elt1 p smaybe_elt1
  
  smaybe_elt1 =
    T.uconstDef p a175v5v175v39maybe_elt1
      (\ p -> T.uwrapForward p (hlookupFM ffm1 fsplit_key p))
  
  gelt1 pelt1 p = T.uconstUse pelt1 p selt1
  
  j176v5v176v13elt1 =
    case gmaybe_elt1 T.mkNoSrcPos p of
      T.R (Just felt1) kelt1 -> (kelt1,felt1)
      _ -> T.fatal p
  
  selt1 =
    T.uconstDef p a176v10v176v13elt1
      (\ _ -> case j176v5v176v13elt1 of (kelt1,felt1) -> felt1)
  
hintersectFM_C _ _ _ p = T.fatal p

gfoldFM pfoldFM p = T.ufun3 afoldFM pfoldFM p hfoldFM

hfoldFM fk fz (T.R EmptyFM _) p = T.projection T.mkNoSrcPos p fz
hfoldFM fk fz (T.R (Branch fkey felt _ ffm_l ffm_r) _) p =
  T.uwrapForward p
    (hfoldFM fk
      (T.uap3 T.mkNoSrcPos p fk fkey felt
        (T.uwrapForward p (hfoldFM fk fz ffm_r p))) ffm_l p)
hfoldFM _ _ _ p = T.fatal p

gmapFM pmapFM p = T.ufun2 amapFM pmapFM p hmapFM

hmapFM ff (T.R EmptyFM _) p = gemptyFM T.mkNoSrcPos p
hmapFM ff (T.R (Branch fkey felt fsize ffm_l ffm_r) _) p =
  T.con5 T.mkNoSrcPos p Branch aBranch fkey (T.uap2 T.mkNoSrcPos p ff fkey felt)
    fsize (T.uwrapForward p (hmapFM ff ffm_l p))
    (T.uwrapForward p (hmapFM ff ffm_r p))
hmapFM _ _ p = T.fatal p

gfilterFM pfilterFM p = T.ufun2 afilterFM pfilterFM p hfilterFM

hfilterFM fp (T.R EmptyFM _) p = gemptyFM T.mkNoSrcPos p
hfilterFM fp (T.R (Branch fkey felt _ ffm_l ffm_r) _) p =
  T.ucguard (T.uap2 T.mkNoSrcPos p fp fkey felt)
    (T.uwrapForward p
      (hmkVBalBranch fkey felt (T.uwrapForward p (hfilterFM fp ffm_l p))
        (T.uwrapForward p (hfilterFM fp ffm_r p)) p))
    (T.ucguard (gotherwise T.mkNoSrcPos p)
      (T.uwrapForward p
        (hglueVBal (T.uwrapForward p (hfilterFM fp ffm_l p))
          (T.uwrapForward p (hfilterFM fp ffm_r p)) p)) (T.fatal p))
hfilterFM _ _ p = T.fatal p

gsizeFM psizeFM p = T.ufun1 asizeFM psizeFM p hsizeFM

hsizeFM (T.R EmptyFM _) p =
  T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
    (T.conInteger T.mkNoSrcPos p 0)
hsizeFM (T.R (Branch _ _ fsize _ _) _) p = T.projection T.mkNoSrcPos p fsize
hsizeFM _ p = T.fatal p

gisEmptyFM pisEmptyFM p = T.ufun1 aisEmptyFM pisEmptyFM p hisEmptyFM

hisEmptyFM ffm p =
  T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) (T.uwrapForward p (hsizeFM ffm p))
    (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 0))

glookupFM plookupFM p = T.ufun2 alookupFM plookupFM p hlookupFM

hlookupFM (T.R EmptyFM _) fkey p = T.con0 T.mkNoSrcPos p Nothing aNothing
hlookupFM (T.R (Branch fkey felt _ ffm_l ffm_r) _) fkey_to_find p =
  T.uccase T.mkNoSrcPos p
    (let
      v201v5v204v22v1 (T.R LT _) p =
        T.uwrapForward p (hlookupFM ffm_l fkey_to_find p)
      v201v5v204v22v1 (T.R GT _) p =
        T.uwrapForward p (hlookupFM ffm_r fkey_to_find p)
      v201v5v204v22v1 (T.R EQ _) p = T.con1 T.mkNoSrcPos p Just aJust felt
      v201v5v204v22v1 _ p = T.fatal p in (v201v5v204v22v1))
    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fkey_to_find fkey)
hlookupFM _ _ p = T.fatal p

gelemFM pelemFM p = T.ufun2 aelemFM pelemFM p helemFM

helemFM fkey ffm p =
  T.uccase T.mkNoSrcPos p
    (let
      v207v5v207v66v1 (T.R Nothing _) p = T.con0 T.mkNoSrcPos p False aFalse
      v207v5v207v66v1 (T.R (Just felt) _) p = T.con0 T.mkNoSrcPos p True aTrue
      v207v5v207v66v1 _ p = T.fatal p in (v207v5v207v66v1))
    (T.uwrapForward p (hlookupFM ffm fkey p))

glookupWithDefaultFM plookupWithDefaultFM p =
  T.ufun3 alookupWithDefaultFM plookupWithDefaultFM p hlookupWithDefaultFM

hlookupWithDefaultFM ffm fdeflt fkey p =
  T.uccase T.mkNoSrcPos p
    (let
      v210v5v210v65v1 (T.R Nothing _) p = T.projection T.mkNoSrcPos p fdeflt
      v210v5v210v65v1 (T.R (Just felt) _) p = T.projection T.mkNoSrcPos p felt
      v210v5v210v65v1 _ p = T.fatal p in (v210v5v210v65v1))
    (T.uwrapForward p (hlookupFM ffm fkey p))

gfmToList pfmToList p = T.ufun1 afmToList pfmToList p hfmToList

hfmToList ffm p =
  T.uwrapForward p
    (hfoldFM
      (T.ufun3 T.mkLambda T.mkNoSrcPos p
        (\ fkey felt frest p ->
          T.con2 T.mkNoSrcPos p T.Cons T.aCons
            (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 fkey felt) frest))
      (T.con0 T.mkNoSrcPos p T.List T.aList) ffm p)

gkeysFM pkeysFM p = T.ufun1 akeysFM pkeysFM p hkeysFM

hkeysFM ffm p =
  T.uwrapForward p
    (hfoldFM
      (T.ufun3 T.mkLambda T.mkNoSrcPos p
        (\ fkey felt frest p ->
          T.con2 T.mkNoSrcPos p T.Cons T.aCons fkey frest))
      (T.con0 T.mkNoSrcPos p T.List T.aList) ffm p)

geltsFM peltsFM p = T.ufun1 aeltsFM peltsFM p heltsFM

heltsFM ffm p =
  T.uwrapForward p
    (hfoldFM
      (T.ufun3 T.mkLambda T.mkNoSrcPos p
        (\ fkey felt frest p ->
          T.con2 T.mkNoSrcPos p T.Cons T.aCons felt frest))
      (T.con0 T.mkNoSrcPos p T.List T.aList) ffm p)

gsIZE_RATIO :: T.RefSrcPos -> T.RefExp -> T.R Int

ssIZE_RATIO :: T.R Int

gsIZE_RATIO psIZE_RATIO p = T.uconstUse psIZE_RATIO p ssIZE_RATIO

ssIZE_RATIO =
  T.uconstDef T.mkRoot asIZE_RATIO
    (\ p ->
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 5))

gmkBranch ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun Int
          (T.Fun key
            (T.Fun elt
              (T.Fun (FiniteMap key elt)
                (T.Fun (FiniteMap key elt) (FiniteMap key elt))))))

hmkBranch ::
  Ord key =>
  (T.R Int) ->
    (T.R key) ->
      (T.R elt) ->
        (T.R (FiniteMap key elt)) ->
          (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gmkBranch pmkBranch p = T.ufun5 amkBranch pmkBranch p hmkBranch

hmkBranch fwhich fkey felt ffm_l ffm_r p =
  let
    gresult presult p = T.uconstUse presult p sresult
    sresult =
      T.uconstDef p a225v9v225v70result
        (\ p ->
          T.con5 T.mkNoSrcPos p Branch aBranch fkey felt
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 1)) (gleft_size T.mkNoSrcPos p))
              (gright_size T.mkNoSrcPos p)) ffm_l ffm_r) in
    (gresult T.mkNoSrcPos p)
  where
  
  gleft_ok pleft_ok p = T.uconstUse pleft_ok p sleft_ok
  
  sleft_ok =
    T.uconstDef p a228v5v232v63left_ok
      (\ p ->
        T.uccase T.mkNoSrcPos p
          (let
            v229v9v232v63v1 (T.R EmptyFM _) p = T.con0 T.mkNoSrcPos p True aTrue
            v229v9v232v63v1 (T.R (Branch fleft_key _ _ _ _) _) p =
              let
                gbiggest_left_key pbiggest_left_key p =
                  T.uconstUse pbiggest_left_key p sbiggest_left_key
                sbiggest_left_key =
                  T.uconstDef p a231v43v231v78biggest_left_key
                    (\ p ->
                      T.uwrapForward p
                        (hfst (T.uwrapForward p (hfindMax ffm_l p)) p)) in
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
                  (gbiggest_left_key T.mkNoSrcPos p) fkey)
            v229v9v232v63v1 _ p = T.fatal p in (v229v9v232v63v1)) ffm_l)
  
  gright_ok pright_ok p = T.uconstUse pright_ok p sright_ok
  
  sright_ok =
    T.uconstDef p a233v5v237v61right_ok
      (\ p ->
        T.uccase T.mkNoSrcPos p
          (let
            v234v9v237v61v1 (T.R EmptyFM _) p = T.con0 T.mkNoSrcPos p True aTrue
            v234v9v237v61v1 (T.R (Branch fright_key _ _ _ _) _) p =
              let
                gsmallest_r_key psmallest_r_key p =
                  T.uconstUse psmallest_r_key p ssmallest_r_key
                ssmallest_r_key =
                  T.uconstDef p a236v43v236v76smallest_r_key
                    (\ p ->
                      T.uwrapForward p
                        (hfst (T.uwrapForward p (hfindMin ffm_r p)) p)) in
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fkey
                  (gsmallest_r_key T.mkNoSrcPos p))
            v234v9v237v61v1 _ p = T.fatal p in (v234v9v237v61v1)) ffm_r)
  
  gbalance_ok pbalance_ok p = T.uconstUse pbalance_ok p sbalance_ok
  
  sbalance_ok =
    T.uconstDef p a238v5v238v21balance_ok
      (\ p -> T.con0 T.mkNoSrcPos p True aTrue)
  
  gleft_size pleft_size p = T.uconstUse pleft_size p sleft_size
  
  sleft_size =
    T.uconstDef p a240v5v240v28left_size
      (\ p -> T.uwrapForward p (hsizeFM ffm_l p))
  
  gright_size pright_size p = T.uconstUse pright_size p sright_size
  
  sright_size =
    T.uconstDef p a241v5v241v28right_size
      (\ p -> T.uwrapForward p (hsizeFM ffm_r p))
  

gmkBalBranch ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun key
          (T.Fun elt
            (T.Fun (FiniteMap key elt)
              (T.Fun (FiniteMap key elt) (FiniteMap key elt)))))

hmkBalBranch ::
  Ord key =>
  (T.R key) ->
    (T.R elt) ->
      (T.R (FiniteMap key elt)) ->
        (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gmkBalBranch pmkBalBranch p = T.ufun4 amkBalBranch pmkBalBranch p hmkBalBranch

hmkBalBranch fkey felt ffm_L ffm_R p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gsize_l T.mkNoSrcPos p)
        (gsize_r T.mkNoSrcPos p))
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 2)))
    (T.uwrapForward p
      (hmkBranch
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1)) fkey felt ffm_L ffm_R p))
    (T.ucguard
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) (gsize_r T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsIZE_RATIO T.mkNoSrcPos p)
          (gsize_l T.mkNoSrcPos p)))
      (T.uccase T.mkNoSrcPos p
        (let
          v252v5v255v71v1 (T.R (Branch _ _ _ ffm_rl ffm_rr) _) p =
            T.ucguard
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
                (T.uwrapForward p (hsizeFM ffm_rl p))
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 2))
                  (T.uwrapForward p (hsizeFM ffm_rr p))))
              (T.uwrapForward p (hsingle_L ffm_L ffm_R p))
              (T.ucguard (gotherwise T.mkNoSrcPos p)
                (T.uwrapForward p (hdouble_L ffm_L ffm_R p)) (T.fatal p))
          v252v5v255v71v1 _ p = T.fatal p in (v252v5v255v71v1)) ffm_R)
      (T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) (gsize_l T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
            (gsIZE_RATIO T.mkNoSrcPos p) (gsize_r T.mkNoSrcPos p)))
        (T.uccase T.mkNoSrcPos p
          (let
            v259v5v262v71v1 (T.R (Branch _ _ _ ffm_ll ffm_lr) _) p =
              T.ucguard
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
                  (T.uwrapForward p (hsizeFM ffm_lr p))
                  (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
                    (T.uap1 T.mkNoSrcPos p
                      (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                      (T.conInteger T.mkNoSrcPos p 2))
                    (T.uwrapForward p (hsizeFM ffm_ll p))))
                (T.uwrapForward p (hsingle_R ffm_L ffm_R p))
                (T.ucguard (gotherwise T.mkNoSrcPos p)
                  (T.uwrapForward p (hdouble_R ffm_L ffm_R p)) (T.fatal p))
            v259v5v262v71v1 _ p = T.fatal p in (v259v5v262v71v1)) ffm_L)
        (T.ucguard (gotherwise T.mkNoSrcPos p)
          (T.uwrapForward p
            (hmkBranch
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 2)) fkey felt ffm_L ffm_R p))
          (T.fatal p))))
  where
  
  gsize_l psize_l p = T.uconstUse psize_l p ssize_l
  
  ssize_l =
    T.uconstDef p a269v5v269v26size_l
      (\ p -> T.uwrapForward p (hsizeFM ffm_L p))
  
  gsize_r psize_r p = T.uconstUse psize_r p ssize_r
  
  ssize_r =
    T.uconstDef p a270v5v270v26size_r
      (\ p -> T.uwrapForward p (hsizeFM ffm_R p))
  
  gsingle_L psingle_L p = T.ufun2 a271v5v274v35single_L psingle_L p hsingle_L
  
  asingle_L = a271v5v274v35single_L
  
  hsingle_L ffm_l (T.R (Branch fkey_r felt_r _ ffm_rl ffm_rr) _) p =
    T.uwrapForward p
      (hmkBranch
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 3)) fkey_r felt_r
        (T.uwrapForward p
          (hmkBranch
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 4)) fkey felt ffm_l ffm_rl p)) ffm_rr
        p)
  hsingle_L _ _ p = T.fatal p
  
  gdouble_L pdouble_L p = T.ufun2 a275v5v280v75double_L pdouble_L p hdouble_L
  
  adouble_L = a275v5v280v75double_L
  
  hdouble_L ffm_l
    (T.R
      (Branch fkey_r felt_r _ (T.R (Branch fkey_rl felt_rl _ ffm_rll ffm_rlr) _)
        ffm_rr) _) p =
    T.uwrapForward p
      (hmkBranch
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 5)) fkey_rl felt_rl
        (T.uwrapForward p
          (hmkBranch
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 6)) fkey felt ffm_l ffm_rll p))
        (T.uwrapForward p
          (hmkBranch
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 7)) fkey_r felt_r ffm_rlr ffm_rr p))
        p)
  hdouble_L _ _ p = T.fatal p
  
  gsingle_R psingle_R p = T.ufun2 a281v5v283v69single_R psingle_R p hsingle_R
  
  asingle_R = a281v5v283v69single_R
  
  hsingle_R (T.R (Branch fkey_l felt_l _ ffm_ll ffm_lr) _) ffm_r p =
    T.uwrapForward p
      (hmkBranch
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 8)) fkey_l felt_l ffm_ll
        (T.uwrapForward p
          (hmkBranch
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 9)) fkey felt ffm_lr ffm_r p)) p)
  hsingle_R _ _ p = T.fatal p
  
  gdouble_R pdouble_R p = T.ufun2 a284v5v288v76double_R pdouble_R p hdouble_R
  
  adouble_R = a284v5v288v76double_R
  
  hdouble_R
    (T.R
      (Branch fkey_l felt_l _ ffm_ll
        (T.R (Branch fkey_lr felt_lr _ ffm_lrl ffm_lrr) _)) _) ffm_r p =
    T.uwrapForward p
      (hmkBranch
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 10)) fkey_lr felt_lr
        (T.uwrapForward p
          (hmkBranch
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 11)) fkey_l felt_l ffm_ll ffm_lrl p))
        (T.uwrapForward p
          (hmkBranch
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 12)) fkey felt ffm_lrr ffm_r p)) p)
  hdouble_R _ _ p = T.fatal p
  

gmkVBalBranch ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun key
          (T.Fun elt
            (T.Fun (FiniteMap key elt)
              (T.Fun (FiniteMap key elt) (FiniteMap key elt)))))

hmkVBalBranch ::
  Ord key =>
  (T.R key) ->
    (T.R elt) ->
      (T.R (FiniteMap key elt)) ->
        (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gmkVBalBranch pmkVBalBranch p =
  T.ufun4 amkVBalBranch pmkVBalBranch p hmkVBalBranch

hmkVBalBranch fkey felt (T.R EmptyFM _) ffm_r p =
  T.uwrapForward p (haddToFM ffm_r fkey felt p)
hmkVBalBranch fkey felt ffm_l (T.R EmptyFM _) p =
  T.uwrapForward p (haddToFM ffm_l fkey felt p)
hmkVBalBranch fkey felt (ffm_l@(T.R (Branch fkey_l felt_l _ ffm_ll ffm_lr) _))
  (ffm_r@(T.R (Branch fkey_r felt_r _ ffm_rl ffm_rr) _)) p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsIZE_RATIO T.mkNoSrcPos p)
        (gsize_l T.mkNoSrcPos p)) (gsize_r T.mkNoSrcPos p))
    (T.uwrapForward p
      (hmkBalBranch fkey_r felt_r
        (T.uwrapForward p (hmkVBalBranch fkey felt ffm_l ffm_rl p)) ffm_rr p))
    (T.ucguard
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsIZE_RATIO T.mkNoSrcPos p)
          (gsize_r T.mkNoSrcPos p)) (gsize_l T.mkNoSrcPos p))
      (T.uwrapForward p
        (hmkBalBranch fkey_l felt_l ffm_ll
          (T.uwrapForward p (hmkVBalBranch fkey felt ffm_lr ffm_r p)) p))
      (T.ucguard (gotherwise T.mkNoSrcPos p)
        (T.uwrapForward p
          (hmkBranch
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 13)) fkey felt ffm_l ffm_r p))
        (T.fatal p)))
  where
  
  gsize_l psize_l p = T.uconstUse psize_l p ssize_l
  
  ssize_l =
    T.uconstDef p a310v5v310v24size_l
      (\ p -> T.uwrapForward p (hsizeFM ffm_l p))
  
  gsize_r psize_r p = T.uconstUse psize_r p ssize_r
  
  ssize_r =
    T.uconstDef p a311v5v311v24size_r
      (\ p -> T.uwrapForward p (hsizeFM ffm_r p))
  
hmkVBalBranch _ _ _ _ p = T.fatal p

gglueBal ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (FiniteMap key elt)
          (T.Fun (FiniteMap key elt) (FiniteMap key elt)))

hglueBal ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gglueBal pglueBal p = T.ufun2 aglueBal pglueBal p hglueBal

hglueBal (T.R EmptyFM _) ffm2 p = T.projection T.mkNoSrcPos p ffm2
hglueBal ffm1 (T.R EmptyFM _) p = T.projection T.mkNoSrcPos p ffm1
hglueBal ffm1 ffm2 p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p)
      (T.uwrapForward p (hsizeFM ffm2 p)) (T.uwrapForward p (hsizeFM ffm1 p)))
    (T.uwrapForward p
      (hmkBalBranch (gmid_key2 T.mkNoSrcPos p) (gmid_elt2 T.mkNoSrcPos p) ffm1
        (T.uwrapForward p (hdeleteMin ffm2 p)) p))
    (T.ucguard (gotherwise T.mkNoSrcPos p)
      (T.uwrapForward p
        (hmkBalBranch (gmid_key1 T.mkNoSrcPos p) (gmid_elt1 T.mkNoSrcPos p)
          (T.uwrapForward p (hdeleteMax ffm1 p)) ffm2 p)) (T.fatal p))
  where
  
  gmid_key1 pmid_key1 p = T.uconstUse pmid_key1 p smid_key1
  
  gmid_elt1 pmid_key1 p = T.uconstUse pmid_key1 p smid_elt1
  
  j329v5v329v24mid_key1 =
    case T.uwrapForward p (hfindMax ffm1 p) of
      T.R (T.Tuple2 fmid_key1 fmid_elt1) kmid_key1 ->
        (kmid_key1,fmid_key1,fmid_elt1)
      _ -> T.fatal p
  
  smid_key1 =
    T.uconstDef p a329v6v329v13mid_key1
      (\ _ ->
        case j329v5v329v24mid_key1 of
          (kmid_key1,fmid_key1,fmid_elt1) -> fmid_key1)
  
  smid_elt1 =
    T.uconstDef p a329v16v329v23mid_elt1
      (\ _ ->
        case j329v5v329v24mid_key1 of
          (kmid_key1,fmid_key1,fmid_elt1) -> fmid_elt1)
  
  gmid_key2 pmid_key2 p = T.uconstUse pmid_key2 p smid_key2
  
  gmid_elt2 pmid_key2 p = T.uconstUse pmid_key2 p smid_elt2
  
  j330v5v330v24mid_key2 =
    case T.uwrapForward p (hfindMin ffm2 p) of
      T.R (T.Tuple2 fmid_key2 fmid_elt2) kmid_key2 ->
        (kmid_key2,fmid_key2,fmid_elt2)
      _ -> T.fatal p
  
  smid_key2 =
    T.uconstDef p a330v6v330v13mid_key2
      (\ _ ->
        case j330v5v330v24mid_key2 of
          (kmid_key2,fmid_key2,fmid_elt2) -> fmid_key2)
  
  smid_elt2 =
    T.uconstDef p a330v16v330v23mid_elt2
      (\ _ ->
        case j330v5v330v24mid_key2 of
          (kmid_key2,fmid_key2,fmid_elt2) -> fmid_elt2)
  

gglueVBal ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (FiniteMap key elt)
          (T.Fun (FiniteMap key elt) (FiniteMap key elt)))

hglueVBal ::
  Ord key =>
  (T.R (FiniteMap key elt)) ->
    (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gglueVBal pglueVBal p = T.ufun2 aglueVBal pglueVBal p hglueVBal

hglueVBal (T.R EmptyFM _) ffm2 p = T.projection T.mkNoSrcPos p ffm2
hglueVBal ffm1 (T.R EmptyFM _) p = T.projection T.mkNoSrcPos p ffm1
hglueVBal (ffm_l@(T.R (Branch fkey_l felt_l _ ffm_ll ffm_lr) _))
  (ffm_r@(T.R (Branch fkey_r felt_r _ ffm_rl ffm_rr) _)) p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsIZE_RATIO T.mkNoSrcPos p)
        (gsize_l T.mkNoSrcPos p)) (gsize_r T.mkNoSrcPos p))
    (T.uwrapForward p
      (hmkBalBranch fkey_r felt_r (T.uwrapForward p (hglueVBal ffm_l ffm_rl p))
        ffm_rr p))
    (T.ucguard
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsIZE_RATIO T.mkNoSrcPos p)
          (gsize_r T.mkNoSrcPos p)) (gsize_l T.mkNoSrcPos p))
      (T.uwrapForward p
        (hmkBalBranch fkey_l felt_l ffm_ll
          (T.uwrapForward p (hglueVBal ffm_lr ffm_r p)) p))
      (T.ucguard (gotherwise T.mkNoSrcPos p)
        (T.uwrapForward p (hglueBal ffm_l ffm_r p)) (T.fatal p)))
  where
  
  gsize_l psize_l p = T.uconstUse psize_l p ssize_l
  
  ssize_l =
    T.uconstDef p a349v5v349v24size_l
      (\ p -> T.uwrapForward p (hsizeFM ffm_l p))
  
  gsize_r psize_r p = T.uconstUse psize_r p ssize_r
  
  ssize_r =
    T.uconstDef p a350v5v350v24size_r
      (\ p -> T.uwrapForward p (hsizeFM ffm_r p))
  
hglueVBal _ _ p = T.fatal p

gsplitLT,gsplitGT ::
  Ord key =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.Fun key (FiniteMap key elt)))

hsplitLT ::
  Ord key =>
  (T.R (FiniteMap key elt)) -> (T.R key) -> T.RefExp -> T.R (FiniteMap key elt)

hsplitGT ::
  Ord key =>
  (T.R (FiniteMap key elt)) -> (T.R key) -> T.RefExp -> T.R (FiniteMap key elt)

gsplitLT psplitLT p = T.ufun2 asplitLT psplitLT p hsplitLT

hsplitLT (T.R EmptyFM _) fsplit_key p = gemptyFM T.mkNoSrcPos p
hsplitLT (T.R (Branch fkey felt _ ffm_l ffm_r) _) fsplit_key p =
  T.uccase T.mkNoSrcPos p
    (let
      v355v5v358v18v1 (T.R LT _) p =
        T.uwrapForward p (hsplitLT ffm_l fsplit_key p)
      v355v5v358v18v1 (T.R GT _) p =
        T.uwrapForward p
          (hmkVBalBranch fkey felt ffm_l
            (T.uwrapForward p (hsplitLT ffm_r fsplit_key p)) p)
      v355v5v358v18v1 (T.R EQ _) p = T.projection T.mkNoSrcPos p ffm_l
      v355v5v358v18v1 _ p = T.fatal p in (v355v5v358v18v1))
    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fsplit_key fkey)
hsplitLT _ _ p = T.fatal p

gsplitGT psplitGT p = T.ufun2 asplitGT psplitGT p hsplitGT

hsplitGT (T.R EmptyFM _) fsplit_key p = gemptyFM T.mkNoSrcPos p
hsplitGT (T.R (Branch fkey felt _ ffm_l ffm_r) _) fsplit_key p =
  T.uccase T.mkNoSrcPos p
    (let
      v361v5v364v18v1 (T.R GT _) p =
        T.uwrapForward p (hsplitGT ffm_r fsplit_key p)
      v361v5v364v18v1 (T.R LT _) p =
        T.uwrapForward p
          (hmkVBalBranch fkey felt
            (T.uwrapForward p (hsplitGT ffm_l fsplit_key p)) ffm_r p)
      v361v5v364v18v1 (T.R EQ _) p = T.projection T.mkNoSrcPos p ffm_r
      v361v5v364v18v1 _ p = T.fatal p in (v361v5v364v18v1))
    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fsplit_key fkey)
hsplitGT _ _ p = T.fatal p

gfindMin ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.Tuple2 key elt))

hfindMin :: (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (T.Tuple2 key elt)

gfindMin pfindMin p = T.ufun1 afindMin pfindMin p hfindMin

hfindMin (T.R (Branch fkey felt _ (T.R EmptyFM _) _) _) p =
  T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 fkey felt
hfindMin (T.R (Branch fkey felt _ ffm_l _) _) p =
  T.uwrapForward p (hfindMin ffm_l p)
hfindMin _ p = T.fatal p

gdeleteMin ::
  Ord key =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) (FiniteMap key elt))

hdeleteMin ::
  Ord key => (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gdeleteMin pdeleteMin p = T.ufun1 adeleteMin pdeleteMin p hdeleteMin

hdeleteMin (T.R (Branch fkey felt _ (T.R EmptyFM _) ffm_r) _) p =
  T.projection T.mkNoSrcPos p ffm_r
hdeleteMin (T.R (Branch fkey felt _ ffm_l ffm_r) _) p =
  T.uwrapForward p
    (hmkBalBranch fkey felt (T.uwrapForward p (hdeleteMin ffm_l p)) ffm_r p)
hdeleteMin _ p = T.fatal p

gfindMax ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) (T.Tuple2 key elt))

hfindMax :: (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (T.Tuple2 key elt)

gfindMax pfindMax p = T.ufun1 afindMax pfindMax p hfindMax

hfindMax (T.R (Branch fkey felt _ _ (T.R EmptyFM _)) _) p =
  T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 fkey felt
hfindMax (T.R (Branch fkey felt _ _ ffm_r) _) p =
  T.uwrapForward p (hfindMax ffm_r p)
hfindMax _ p = T.fatal p

gdeleteMax ::
  Ord key =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FiniteMap key elt) (FiniteMap key elt))

hdeleteMax ::
  Ord key => (T.R (FiniteMap key elt)) -> T.RefExp -> T.R (FiniteMap key elt)

gdeleteMax pdeleteMax p = T.ufun1 adeleteMax pdeleteMax p hdeleteMax

hdeleteMax (T.R (Branch fkey felt _ ffm_l (T.R EmptyFM _)) _) p =
  T.projection T.mkNoSrcPos p ffm_l
hdeleteMax (T.R (Branch fkey felt _ ffm_l ffm_r) _) p =
  T.uwrapForward p
    (hmkBalBranch fkey felt ffm_l (T.uwrapForward p (hdeleteMax ffm_r p)) p)
hdeleteMax _ p = T.fatal p

instance (Eq key,Eq elt) => Eq ((FiniteMap key elt))
  where
  
  (!==) (%==) p =
    T.ufun2 (+%@+=@=%@+=>==) (%==) p (*==)
    where
    
    (*==) ffm_1 ffm_2 p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
              (T.uwrapForward p (hsizeFM ffm_1 p))
              (T.uwrapForward p (hsizeFM ffm_2 p)))
            *&&
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
              (T.uwrapForward p (hfmToList ffm_1 p))
              (T.uwrapForward p (hfmToList ffm_2 p)))) p)
    
  

tData_FiniteMap = T.mkModule "Data.FiniteMap" "Data/FiniteMap.hs" Prelude.False

aEmptyFM = T.mkConstructor tData_FiniteMap 860005 860011 3 0 "EmptyFM"

aBranch = T.mkConstructor tData_FiniteMap 870005 870010 3 5 "Branch"

aemptyFM =
  T.mkVariable tData_FiniteMap 1020001 1020017 3 0 "emptyFM" Prelude.False

aunitFM =
  T.mkVariable tData_FiniteMap 1030001 1030049 3 2 "unitFM" Prelude.False

alistToFM =
  T.mkVariable tData_FiniteMap 1040001 1040030 3 0 "listToFM" Prelude.False

aaddToFM =
  T.mkVariable tData_FiniteMap 1050001 1050060 3 3 "addToFM" Prelude.False

aaddToFM_C =
  T.mkVariable tData_FiniteMap 1070001 1120064 3 4 "addToFM_C" Prelude.False

aaddListToFM =
  T.mkVariable tData_FiniteMap 1140001 1140080 3 2 "addListToFM" Prelude.False

aaddListToFM_C =
  T.mkVariable tData_FiniteMap 1150001 1180056 3 3 "addListToFM_C" Prelude.False

adelFromFM =
  T.mkVariable tData_FiniteMap 1200001 1250031 3 2 "delFromFM" Prelude.False

adelListFromFM =
  T.mkVariable tData_FiniteMap 1270001 1270047 3 2 "delListFromFM" Prelude.False

aplusFM_C =
  T.mkVariable tData_FiniteMap 1290001 1400047 3 3 "plusFM_C" Prelude.False

aplusFM =
  T.mkVariable tData_FiniteMap 1420001 1480035 3 2 "plusFM" Prelude.False

aminusFM =
  T.mkVariable tData_FiniteMap 1500001 1570031 3 2 "minusFM" Prelude.False

aintersectFM =
  T.mkVariable tData_FiniteMap 1590001 1590067 3 2 "intersectFM" Prelude.False

aintersectFM_C =
  T.mkVariable tData_FiniteMap 1610001 1760027 3 3 "intersectFM_C" Prelude.False

afoldFM =
  T.mkVariable tData_FiniteMap 1780001 1800047 3 3 "foldFM" Prelude.False

amapFM = T.mkVariable tData_FiniteMap 1820001 1840060 3 2 "mapFM" Prelude.False

afilterFM =
  T.mkVariable tData_FiniteMap 1860001 1920047 3 2 "filterFM" Prelude.False

asizeFM =
  T.mkVariable tData_FiniteMap 1940001 1950035 3 1 "sizeFM" Prelude.False

aisEmptyFM =
  T.mkVariable tData_FiniteMap 1970001 1970029 3 1 "isEmptyFM" Prelude.False

alookupFM =
  T.mkVariable tData_FiniteMap 1990001 2040022 3 2 "lookupFM" Prelude.False

aelemFM =
  T.mkVariable tData_FiniteMap 2060006 2060011 3 2 "elemFM" Prelude.False

alookupWithDefaultFM =
  T.mkVariable tData_FiniteMap 2090001 2100065 3 3 "lookupWithDefaultFM"
    Prelude.False

afmToList =
  T.mkVariable tData_FiniteMap 2120001 2120063 3 1 "fmToList" Prelude.False

akeysFM =
  T.mkVariable tData_FiniteMap 2130001 2130063 3 1 "keysFM" Prelude.False

aeltsFM =
  T.mkVariable tData_FiniteMap 2140001 2140063 3 1 "eltsFM" Prelude.False

asIZE_RATIO =
  T.mkVariable tData_FiniteMap 2170001 2170014 3 0 "sIZE_RATIO" Prelude.False

amkBranch =
  T.mkVariable tData_FiniteMap 2240001 2410028 3 5 "mkBranch" Prelude.False

amkBalBranch =
  T.mkVariable tData_FiniteMap 2470001 2880076 3 4 "mkBalBranch" Prelude.False

amkVBalBranch =
  T.mkVariable tData_FiniteMap 2950001 3110024 3 4 "mkVBalBranch" Prelude.False

aglueBal =
  T.mkVariable tData_FiniteMap 3170001 3300038 3 2 "glueBal" Prelude.False

aglueVBal =
  T.mkVariable tData_FiniteMap 3360001 3500024 3 2 "glueVBal" Prelude.False

asplitLT =
  T.mkVariable tData_FiniteMap 3530001 3580018 3 2 "splitLT" Prelude.False

asplitGT =
  T.mkVariable tData_FiniteMap 3590001 3640018 3 2 "splitGT" Prelude.False

afindMin =
  T.mkVariable tData_FiniteMap 3670001 3680051 3 1 "findMin" Prelude.False

adeleteMin =
  T.mkVariable tData_FiniteMap 3710001 3730077 3 1 "deleteMin" Prelude.False

afindMax =
  T.mkVariable tData_FiniteMap 3760001 3770051 3 1 "findMax" Prelude.False

adeleteMax =
  T.mkVariable tData_FiniteMap 3800001 3820071 3 1 "deleteMax" Prelude.False

a93v3v100v73show =
  T.mkVariable tData_FiniteMap 930003 1000073 3 1 "show" Prelude.False

(+%@+=@=%@+=>==) =
  T.mkVariable tData_FiniteMap 3860008 3860009 16 2 "==" Prelude.False

a96v7v98v49addCommas =
  T.mkVariable tData_FiniteMap 960007 980049 3 1 "addCommas" Prelude.True

a100v7v100v73elems =
  T.mkVariable tData_FiniteMap 1000007 1000073 3 1 "elems" Prelude.True

a118v5v118v56add =
  T.mkVariable tData_FiniteMap 1180005 1180056 3 2 "add" Prelude.True

a136v5v136v35lts =
  T.mkVariable tData_FiniteMap 1360005 1360035 3 0 "lts" Prelude.True

a137v5v137v35gts =
  T.mkVariable tData_FiniteMap 1370005 1370035 3 0 "gts" Prelude.True

a138v5v140v47new_elt =
  T.mkVariable tData_FiniteMap 1380005 1400047 3 0 "new_elt" Prelude.True

a147v5v147v35lts =
  T.mkVariable tData_FiniteMap 1470005 1470035 3 0 "lts" Prelude.True

a148v5v148v35gts =
  T.mkVariable tData_FiniteMap 1480005 1480035 3 0 "gts" Prelude.True

a156v5v156v31lts =
  T.mkVariable tData_FiniteMap 1560005 1560031 3 0 "lts" Prelude.True

a157v5v157v31gts =
  T.mkVariable tData_FiniteMap 1570005 1570031 3 0 "gts" Prelude.True

a172v5v172v31lts =
  T.mkVariable tData_FiniteMap 1720005 1720031 3 0 "lts" Prelude.True

a173v5v173v31gts =
  T.mkVariable tData_FiniteMap 1730005 1730031 3 0 "gts" Prelude.True

a175v5v175v39maybe_elt1 =
  T.mkVariable tData_FiniteMap 1750005 1750039 3 0 "maybe_elt1" Prelude.True

a176v10v176v13elt1 =
  T.mkVariable tData_FiniteMap 1760010 1760013 3 0 "elt1" Prelude.True

a228v5v232v63left_ok =
  T.mkVariable tData_FiniteMap 2280005 2320063 3 0 "left_ok" Prelude.True

a233v5v237v61right_ok =
  T.mkVariable tData_FiniteMap 2330005 2370061 3 0 "right_ok" Prelude.True

a238v5v238v21balance_ok =
  T.mkVariable tData_FiniteMap 2380005 2380021 3 0 "balance_ok" Prelude.True

a240v5v240v28left_size =
  T.mkVariable tData_FiniteMap 2400005 2400028 3 0 "left_size" Prelude.True

a241v5v241v28right_size =
  T.mkVariable tData_FiniteMap 2410005 2410028 3 0 "right_size" Prelude.True

a231v43v231v78biggest_left_key =
  T.mkVariable tData_FiniteMap 2310043 2310078 3 0 "biggest_left_key"
    Prelude.True

a236v43v236v76smallest_r_key =
  T.mkVariable tData_FiniteMap 2360043 2360076 3 0 "smallest_r_key" Prelude.True

a225v9v225v70result =
  T.mkVariable tData_FiniteMap 2250009 2250070 3 0 "result" Prelude.True

a269v5v269v26size_l =
  T.mkVariable tData_FiniteMap 2690005 2690026 3 0 "size_l" Prelude.True

a270v5v270v26size_r =
  T.mkVariable tData_FiniteMap 2700005 2700026 3 0 "size_r" Prelude.True

a271v5v274v35single_L =
  T.mkVariable tData_FiniteMap 2710005 2740035 3 2 "single_L" Prelude.True

a275v5v280v75double_L =
  T.mkVariable tData_FiniteMap 2750005 2800075 3 2 "double_L" Prelude.True

a281v5v283v69single_R =
  T.mkVariable tData_FiniteMap 2810005 2830069 3 2 "single_R" Prelude.True

a284v5v288v76double_R =
  T.mkVariable tData_FiniteMap 2840005 2880076 3 2 "double_R" Prelude.True

a310v5v310v24size_l =
  T.mkVariable tData_FiniteMap 3100005 3100024 3 0 "size_l" Prelude.True

a311v5v311v24size_r =
  T.mkVariable tData_FiniteMap 3110005 3110024 3 0 "size_r" Prelude.True

a329v6v329v13mid_key1 =
  T.mkVariable tData_FiniteMap 3290006 3290013 3 0 "mid_key1" Prelude.True

a329v16v329v23mid_elt1 =
  T.mkVariable tData_FiniteMap 3290016 3290023 3 0 "mid_elt1" Prelude.True

a330v6v330v13mid_key2 =
  T.mkVariable tData_FiniteMap 3300006 3300013 3 0 "mid_key2" Prelude.True

a330v16v330v23mid_elt2 =
  T.mkVariable tData_FiniteMap 3300016 3300023 3 0 "mid_elt2" Prelude.True

a349v5v349v24size_l =
  T.mkVariable tData_FiniteMap 3490005 3490024 3 0 "size_l" Prelude.True

a350v5v350v24size_r =
  T.mkVariable tData_FiniteMap 3500005 3500024 3 0 "size_r" Prelude.True
