module Hat.Foreign.Storable
  (Storable(gsizeOf,galignment,gpeekElemOff,gpokeElemOff,gpeekByteOff
      ,gpokeByteOff,gpeek,gpoke,ssizeOf,salignment,speekElemOff,spokeElemOff
      ,speekByteOff,spokeByteOff,speek,spoke)) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 
import Hat.Control.Monad  (gliftM,aliftM,hliftM)
import Hat.PreludeBuiltinTypes 
import Hat.Foreign.BuiltinTypes 
import Hat.Foreign.Ptr 
import qualified Foreign.Storable 
import qualified Foreign.StablePtr 

class Storable a
  where
  
  gsizeOf :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Int)
  
  galignment :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Int)
  
  gpeekElemOff ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun Int (IO a)))
  
  gpokeElemOff ::
    T.RefSrcPos ->
      T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun Int (T.Fun a (IO T.Tuple0))))
  
  gpeekByteOff ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO a)))
  
  gpokeByteOff ::
    T.RefSrcPos ->
      T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun a (IO T.Tuple0))))
  
  gpeek :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (IO a))
  
  gpoke ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun a (IO T.Tuple0)))
  
  gpeekElemOff ppeekElemOff p =
    T.ufun2 a30v5v32v37peekElemOff ppeekElemOff p hpeekElemOff
    where
    
    hpeekElemOff fptr foff p =
      T.uap2 T.mkNoSrcPos p (gpeekByteOff T.mkNoSrcPos p) fptr
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) foff
          (T.uwrapForward p (hsizeOfP fptr (gundefined T.mkNoSrcPos p) p)))
      where
      
      gsizeOfP ::
        Storable b =>
        T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun b Int))
      
      hsizeOfP :: Storable b => (T.R (Ptr b)) -> (T.R b) -> T.RefExp -> T.R Int
      
      gsizeOfP psizeOfP p = T.ufun2 a32v15v32v37sizeOfP psizeOfP p hsizeOfP
      
      asizeOfP = a32v15v32v37sizeOfP
      
      hsizeOfP fpx fx p = T.uap1 T.mkNoSrcPos p (gsizeOf T.mkNoSrcPos p) fx
      
    
  
  gpokeElemOff ppokeElemOff p =
    T.ufun3 a33v5v33v68pokeElemOff ppokeElemOff p hpokeElemOff
    where
    
    hpokeElemOff fptr foff fval p =
      T.uap3 T.mkNoSrcPos p (gpokeByteOff T.mkNoSrcPos p) fptr
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) foff
          (T.uap1 T.mkNoSrcPos p (gsizeOf T.mkNoSrcPos p) fval)) fval
    
  
  gpeekByteOff ppeekByteOff p =
    T.ufun2 a35v5v35v49peekByteOff ppeekByteOff p hpeekByteOff
    where
    
    hpeekByteOff fptr foff p =
      T.uap1 T.mkNoSrcPos p (gpeek T.mkNoSrcPos p)
        (T.uwrapForward p (hplusPtr fptr foff p))
    
  
  gpokeByteOff ppokeByteOff p =
    T.ufun2 a36v5v36v49pokeByteOff ppokeByteOff p hpokeByteOff
    where
    
    hpokeByteOff fptr foff p =
      T.uap1 T.mkNoSrcPos p (gpoke T.mkNoSrcPos p)
        (T.uwrapForward p (hplusPtr fptr foff p))
    
  
  gpeek ppeek p =
    T.ufun1 a38v5v38v32peek ppeek p hpeek
    where
    
    hpeek fptr p =
      T.uap2 T.mkNoSrcPos p (gpeekElemOff T.mkNoSrcPos p) fptr
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))
    
  
  gpoke ppoke p =
    T.ufun1 a39v5v39v32poke ppoke p hpoke
    where
    
    hpoke fptr p =
      T.uap2 T.mkNoSrcPos p (gpokeElemOff T.mkNoSrcPos p) fptr
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))
    
  
  ssizeOf :: T.R (T.Fun a Int)
  
  salignment :: T.R (T.Fun a Int)
  
  speekElemOff :: T.R (T.Fun (Ptr a) (T.Fun Int (IO a)))
  
  spokeElemOff :: T.R (T.Fun (Ptr a) (T.Fun Int (T.Fun a (IO T.Tuple0))))
  
  speekByteOff :: T.R (T.Fun (Ptr b) (T.Fun Int (IO a)))
  
  spokeByteOff :: T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun a (IO T.Tuple0))))
  
  speek :: T.R (T.Fun (Ptr a) (IO a))
  
  spoke :: T.R (T.Fun (Ptr a) (T.Fun a (IO T.Tuple0)))
  

gsizeOfBool :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Bool Int)

gsizeOfBool psizeOfBool p = T.ufun1 asizeOfBool psizeOfBool p hsizeOfBool

hsizeOfBool z1sizeOfBool ksizeOfBool =
  T.fromInt ksizeOfBool
    (Foreign.Storable.sizeOf (toBool ksizeOfBool z1sizeOfBool))

galignmentBool :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Bool Int)

galignmentBool palignmentBool p =
  T.ufun1 aalignmentBool palignmentBool p halignmentBool

halignmentBool z1alignmentBool kalignmentBool =
  T.fromInt kalignmentBool
    (Foreign.Storable.alignment (toBool kalignmentBool z1alignmentBool))

gpeekElemOffBool ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Bool) (T.Fun Int (IO Bool)))

gpeekElemOffBool ppeekElemOffBool p =
  T.ufun2 apeekElemOffBool ppeekElemOffBool p hpeekElemOffBool

hpeekElemOffBool z1peekElemOffBool z2peekElemOffBool kpeekElemOffBool =
  (T.fromIO fromBool) kpeekElemOffBool
    (Foreign.Storable.peekElemOff
      ((toPtr toBool) kpeekElemOffBool z1peekElemOffBool)
      (T.toInt kpeekElemOffBool z2peekElemOffBool))

gpokeElemOffBool ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr Bool) (T.Fun Int (T.Fun Bool (IO T.Tuple0))))

gpokeElemOffBool ppokeElemOffBool p =
  T.ufun3 apokeElemOffBool ppokeElemOffBool p hpokeElemOffBool

hpokeElemOffBool z1pokeElemOffBool z2pokeElemOffBool z3pokeElemOffBool
  kpokeElemOffBool =
  (T.fromIO T.fromTuple0) kpokeElemOffBool
    (Foreign.Storable.pokeElemOff
      ((toPtr toBool) kpokeElemOffBool z1pokeElemOffBool)
      (T.toInt kpokeElemOffBool z2pokeElemOffBool)
      (toBool kpokeElemOffBool z3pokeElemOffBool))

gpeekByteOffBool ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO Bool)))

gpeekByteOffBool ppeekByteOffBool p =
  T.ufun2 apeekByteOffBool ppeekByteOffBool p hpeekByteOffBool

hpeekByteOffBool z1peekByteOffBool z2peekByteOffBool kpeekByteOffBool =
  (T.fromIO fromBool) kpeekByteOffBool
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffBool z1peekByteOffBool)
      (T.toInt kpeekByteOffBool z2peekByteOffBool))

gpokeByteOffBool ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun Bool (IO T.Tuple0))))

gpokeByteOffBool ppokeByteOffBool p =
  T.ufun3 apokeByteOffBool ppokeByteOffBool p hpokeByteOffBool

hpokeByteOffBool z1pokeByteOffBool z2pokeByteOffBool z3pokeByteOffBool
  kpokeByteOffBool =
  (T.fromIO T.fromTuple0) kpokeByteOffBool
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffBool z1pokeByteOffBool)
      (T.toInt kpokeByteOffBool z2pokeByteOffBool)
      (toBool kpokeByteOffBool z3pokeByteOffBool))

gpeekBool :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Bool) (IO Bool))

gpeekBool ppeekBool p = T.ufun1 apeekBool ppeekBool p hpeekBool

hpeekBool z1peekBool kpeekBool =
  (T.fromIO fromBool) kpeekBool
    (Foreign.Storable.peek ((toPtr toBool) kpeekBool z1peekBool))

gpokeBool ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Bool) (T.Fun Bool (IO T.Tuple0)))

gpokeBool ppokeBool p = T.ufun2 apokeBool ppokeBool p hpokeBool

hpokeBool z1pokeBool z2pokeBool kpokeBool =
  (T.fromIO T.fromTuple0) kpokeBool
    (Foreign.Storable.poke ((toPtr toBool) kpokeBool z1pokeBool)
      (toBool kpokeBool z2pokeBool))

instance Storable (Bool)
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a61v5v61v23sizeOf (\ p -> gsizeOfBool T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a62v5v62v29alignment
      (\ p -> galignmentBool T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a63v5v63v33peekElemOff
      (\ p -> gpeekElemOffBool T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a64v5v64v33pokeElemOff
      (\ p -> gpokeElemOffBool T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a65v5v65v33peekByteOff
      (\ p -> gpeekByteOffBool T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a66v5v66v33pokeByteOff
      (\ p -> gpokeByteOffBool T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek = T.uconstDef T.mkRoot a67v5v67v19peek (\ p -> gpeekBool T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke = T.uconstDef T.mkRoot a68v5v68v19poke (\ p -> gpokeBool T.mkNoSrcPos p)
  

gsizeOfChar :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Char Int)

gsizeOfChar psizeOfChar p = T.ufun1 asizeOfChar psizeOfChar p hsizeOfChar

hsizeOfChar z1sizeOfChar ksizeOfChar =
  T.fromInt ksizeOfChar
    (Foreign.Storable.sizeOf (T.toChar ksizeOfChar z1sizeOfChar))

galignmentChar :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Char Int)

galignmentChar palignmentChar p =
  T.ufun1 aalignmentChar palignmentChar p halignmentChar

halignmentChar z1alignmentChar kalignmentChar =
  T.fromInt kalignmentChar
    (Foreign.Storable.alignment (T.toChar kalignmentChar z1alignmentChar))

gpeekElemOffChar ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Char) (T.Fun Int (IO Char)))

gpeekElemOffChar ppeekElemOffChar p =
  T.ufun2 apeekElemOffChar ppeekElemOffChar p hpeekElemOffChar

hpeekElemOffChar z1peekElemOffChar z2peekElemOffChar kpeekElemOffChar =
  (T.fromIO T.fromChar) kpeekElemOffChar
    (Foreign.Storable.peekElemOff
      ((toPtr T.toChar) kpeekElemOffChar z1peekElemOffChar)
      (T.toInt kpeekElemOffChar z2peekElemOffChar))

gpokeElemOffChar ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr Char) (T.Fun Int (T.Fun Char (IO T.Tuple0))))

gpokeElemOffChar ppokeElemOffChar p =
  T.ufun3 apokeElemOffChar ppokeElemOffChar p hpokeElemOffChar

hpokeElemOffChar z1pokeElemOffChar z2pokeElemOffChar z3pokeElemOffChar
  kpokeElemOffChar =
  (T.fromIO T.fromTuple0) kpokeElemOffChar
    (Foreign.Storable.pokeElemOff
      ((toPtr T.toChar) kpokeElemOffChar z1pokeElemOffChar)
      (T.toInt kpokeElemOffChar z2pokeElemOffChar)
      (T.toChar kpokeElemOffChar z3pokeElemOffChar))

gpeekByteOffChar ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO Char)))

gpeekByteOffChar ppeekByteOffChar p =
  T.ufun2 apeekByteOffChar ppeekByteOffChar p hpeekByteOffChar

hpeekByteOffChar z1peekByteOffChar z2peekByteOffChar kpeekByteOffChar =
  (T.fromIO T.fromChar) kpeekByteOffChar
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffChar z1peekByteOffChar)
      (T.toInt kpeekByteOffChar z2peekByteOffChar))

gpokeByteOffChar ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun Char (IO T.Tuple0))))

gpokeByteOffChar ppokeByteOffChar p =
  T.ufun3 apokeByteOffChar ppokeByteOffChar p hpokeByteOffChar

hpokeByteOffChar z1pokeByteOffChar z2pokeByteOffChar z3pokeByteOffChar
  kpokeByteOffChar =
  (T.fromIO T.fromTuple0) kpokeByteOffChar
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffChar z1pokeByteOffChar)
      (T.toInt kpokeByteOffChar z2pokeByteOffChar)
      (T.toChar kpokeByteOffChar z3pokeByteOffChar))

gpeekChar :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Char) (IO Char))

gpeekChar ppeekChar p = T.ufun1 apeekChar ppeekChar p hpeekChar

hpeekChar z1peekChar kpeekChar =
  (T.fromIO T.fromChar) kpeekChar
    (Foreign.Storable.peek ((toPtr T.toChar) kpeekChar z1peekChar))

gpokeChar ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Char) (T.Fun Char (IO T.Tuple0)))

gpokeChar ppokeChar p = T.ufun2 apokeChar ppokeChar p hpokeChar

hpokeChar z1pokeChar z2pokeChar kpokeChar =
  (T.fromIO T.fromTuple0) kpokeChar
    (Foreign.Storable.poke ((toPtr T.toChar) kpokeChar z1pokeChar)
      (T.toChar kpokeChar z2pokeChar))

instance Storable (Char)
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a88v5v88v23sizeOf (\ p -> gsizeOfChar T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a89v5v89v29alignment
      (\ p -> galignmentChar T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a90v5v90v33peekElemOff
      (\ p -> gpeekElemOffChar T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a91v5v91v33pokeElemOff
      (\ p -> gpokeElemOffChar T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a92v5v92v33peekByteOff
      (\ p -> gpeekByteOffChar T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a93v5v93v33pokeByteOff
      (\ p -> gpokeByteOffChar T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek = T.uconstDef T.mkRoot a94v5v94v19peek (\ p -> gpeekChar T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke = T.uconstDef T.mkRoot a95v5v95v19poke (\ p -> gpokeChar T.mkNoSrcPos p)
  

gsizeOfInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Int)

gsizeOfInt psizeOfInt p = T.ufun1 asizeOfInt psizeOfInt p hsizeOfInt

hsizeOfInt z1sizeOfInt ksizeOfInt =
  T.fromInt ksizeOfInt
    (Foreign.Storable.sizeOf (T.toInt ksizeOfInt z1sizeOfInt))

galignmentInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Int)

galignmentInt palignmentInt p =
  T.ufun1 aalignmentInt palignmentInt p halignmentInt

halignmentInt z1alignmentInt kalignmentInt =
  T.fromInt kalignmentInt
    (Foreign.Storable.alignment (T.toInt kalignmentInt z1alignmentInt))

gpeekElemOffInt ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Int) (T.Fun Int (IO Int)))

gpeekElemOffInt ppeekElemOffInt p =
  T.ufun2 apeekElemOffInt ppeekElemOffInt p hpeekElemOffInt

hpeekElemOffInt z1peekElemOffInt z2peekElemOffInt kpeekElemOffInt =
  (T.fromIO T.fromInt) kpeekElemOffInt
    (Foreign.Storable.peekElemOff
      ((toPtr T.toInt) kpeekElemOffInt z1peekElemOffInt)
      (T.toInt kpeekElemOffInt z2peekElemOffInt))

gpokeElemOffInt ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr Int) (T.Fun Int (T.Fun Int (IO T.Tuple0))))

gpokeElemOffInt ppokeElemOffInt p =
  T.ufun3 apokeElemOffInt ppokeElemOffInt p hpokeElemOffInt

hpokeElemOffInt z1pokeElemOffInt z2pokeElemOffInt z3pokeElemOffInt
  kpokeElemOffInt =
  (T.fromIO T.fromTuple0) kpokeElemOffInt
    (Foreign.Storable.pokeElemOff
      ((toPtr T.toInt) kpokeElemOffInt z1pokeElemOffInt)
      (T.toInt kpokeElemOffInt z2pokeElemOffInt)
      (T.toInt kpokeElemOffInt z3pokeElemOffInt))

gpeekByteOffInt ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO Int)))

gpeekByteOffInt ppeekByteOffInt p =
  T.ufun2 apeekByteOffInt ppeekByteOffInt p hpeekByteOffInt

hpeekByteOffInt z1peekByteOffInt z2peekByteOffInt kpeekByteOffInt =
  (T.fromIO T.fromInt) kpeekByteOffInt
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffInt z1peekByteOffInt)
      (T.toInt kpeekByteOffInt z2peekByteOffInt))

gpokeByteOffInt ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun Int (IO T.Tuple0))))

gpokeByteOffInt ppokeByteOffInt p =
  T.ufun3 apokeByteOffInt ppokeByteOffInt p hpokeByteOffInt

hpokeByteOffInt z1pokeByteOffInt z2pokeByteOffInt z3pokeByteOffInt
  kpokeByteOffInt =
  (T.fromIO T.fromTuple0) kpokeByteOffInt
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffInt z1pokeByteOffInt)
      (T.toInt kpokeByteOffInt z2pokeByteOffInt)
      (T.toInt kpokeByteOffInt z3pokeByteOffInt))

gpeekInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Int) (IO Int))

gpeekInt ppeekInt p = T.ufun1 apeekInt ppeekInt p hpeekInt

hpeekInt z1peekInt kpeekInt =
  (T.fromIO T.fromInt) kpeekInt
    (Foreign.Storable.peek ((toPtr T.toInt) kpeekInt z1peekInt))

gpokeInt ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Int) (T.Fun Int (IO T.Tuple0)))

gpokeInt ppokeInt p = T.ufun2 apokeInt ppokeInt p hpokeInt

hpokeInt z1pokeInt z2pokeInt kpokeInt =
  (T.fromIO T.fromTuple0) kpokeInt
    (Foreign.Storable.poke ((toPtr T.toInt) kpokeInt z1pokeInt)
      (T.toInt kpokeInt z2pokeInt))

instance Storable (Int)
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a115v5v115v22sizeOf (\ p -> gsizeOfInt T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a116v5v116v28alignment
      (\ p -> galignmentInt T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a117v5v117v32peekElemOff
      (\ p -> gpeekElemOffInt T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a118v5v118v32pokeElemOff
      (\ p -> gpokeElemOffInt T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a119v5v119v32peekByteOff
      (\ p -> gpeekByteOffInt T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a120v5v120v32pokeByteOff
      (\ p -> gpokeByteOffInt T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek =
    T.uconstDef T.mkRoot a121v5v121v18peek (\ p -> gpeekInt T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke =
    T.uconstDef T.mkRoot a122v5v122v18poke (\ p -> gpokeInt T.mkNoSrcPos p)
  

gsizeOfPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) Int)

gsizeOfPtr psizeOfPtr p = T.ufun1 asizeOfPtr psizeOfPtr p hsizeOfPtr

hsizeOfPtr z1sizeOfPtr ksizeOfPtr =
  T.fromInt ksizeOfPtr
    (Foreign.Storable.sizeOf ((toPtr T.toId) ksizeOfPtr z1sizeOfPtr))

galignmentPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) Int)

galignmentPtr palignmentPtr p =
  T.ufun1 aalignmentPtr palignmentPtr p halignmentPtr

halignmentPtr z1alignmentPtr kalignmentPtr =
  T.fromInt kalignmentPtr
    (Foreign.Storable.alignment ((toPtr T.toId) kalignmentPtr z1alignmentPtr))

gpeekElemOffPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr (Ptr a)) (T.Fun Int (IO (Ptr a))))

gpeekElemOffPtr ppeekElemOffPtr p =
  T.ufun2 apeekElemOffPtr ppeekElemOffPtr p hpeekElemOffPtr

hpeekElemOffPtr z1peekElemOffPtr z2peekElemOffPtr kpeekElemOffPtr =
  (T.fromIO (fromPtr T.fromId)) kpeekElemOffPtr
    (Foreign.Storable.peekElemOff
      ((toPtr (toPtr T.toId)) kpeekElemOffPtr z1peekElemOffPtr)
      (T.toInt kpeekElemOffPtr z2peekElemOffPtr))

gpokeElemOffPtr ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (Ptr (Ptr a)) (T.Fun Int (T.Fun (Ptr a) (IO T.Tuple0))))

gpokeElemOffPtr ppokeElemOffPtr p =
  T.ufun3 apokeElemOffPtr ppokeElemOffPtr p hpokeElemOffPtr

hpokeElemOffPtr z1pokeElemOffPtr z2pokeElemOffPtr z3pokeElemOffPtr
  kpokeElemOffPtr =
  (T.fromIO T.fromTuple0) kpokeElemOffPtr
    (Foreign.Storable.pokeElemOff
      ((toPtr (toPtr T.toId)) kpokeElemOffPtr z1pokeElemOffPtr)
      (T.toInt kpokeElemOffPtr z2pokeElemOffPtr)
      ((toPtr T.toId) kpokeElemOffPtr z3pokeElemOffPtr))

gpeekByteOffPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO (Ptr a))))

gpeekByteOffPtr ppeekByteOffPtr p =
  T.ufun2 apeekByteOffPtr ppeekByteOffPtr p hpeekByteOffPtr

hpeekByteOffPtr z1peekByteOffPtr z2peekByteOffPtr kpeekByteOffPtr =
  (T.fromIO (fromPtr T.fromId)) kpeekByteOffPtr
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffPtr z1peekByteOffPtr)
      (T.toInt kpeekByteOffPtr z2peekByteOffPtr))

gpokeByteOffPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun (Ptr a) (IO T.Tuple0))))

gpokeByteOffPtr ppokeByteOffPtr p =
  T.ufun3 apokeByteOffPtr ppokeByteOffPtr p hpokeByteOffPtr

hpokeByteOffPtr z1pokeByteOffPtr z2pokeByteOffPtr z3pokeByteOffPtr
  kpokeByteOffPtr =
  (T.fromIO T.fromTuple0) kpokeByteOffPtr
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffPtr z1pokeByteOffPtr)
      (T.toInt kpokeByteOffPtr z2pokeByteOffPtr)
      ((toPtr T.toId) kpokeByteOffPtr z3pokeByteOffPtr))

gpeekPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr (Ptr a)) (IO (Ptr a)))

gpeekPtr ppeekPtr p = T.ufun1 apeekPtr ppeekPtr p hpeekPtr

hpeekPtr z1peekPtr kpeekPtr =
  (T.fromIO (fromPtr T.fromId)) kpeekPtr
    (Foreign.Storable.peek ((toPtr (toPtr T.toId)) kpeekPtr z1peekPtr))

gpokePtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr (Ptr a)) (T.Fun (Ptr a) (IO T.Tuple0)))

gpokePtr ppokePtr p = T.ufun2 apokePtr ppokePtr p hpokePtr

hpokePtr z1pokePtr z2pokePtr kpokePtr =
  (T.fromIO T.fromTuple0) kpokePtr
    (Foreign.Storable.poke ((toPtr (toPtr T.toId)) kpokePtr z1pokePtr)
      ((toPtr T.toId) kpokePtr z2pokePtr))

instance Storable ((Ptr a))
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a142v5v142v22sizeOf (\ p -> gsizeOfPtr T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a143v5v143v28alignment
      (\ p -> galignmentPtr T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a144v5v144v32peekElemOff
      (\ p -> gpeekElemOffPtr T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a145v5v145v32pokeElemOff
      (\ p -> gpokeElemOffPtr T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a146v5v146v32peekByteOff
      (\ p -> gpeekByteOffPtr T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a147v5v147v32pokeByteOff
      (\ p -> gpokeByteOffPtr T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek =
    T.uconstDef T.mkRoot a148v5v148v18peek (\ p -> gpeekPtr T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke =
    T.uconstDef T.mkRoot a149v5v149v18poke (\ p -> gpokePtr T.mkNoSrcPos p)
  

gsizeOfFunPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FunPtr a) Int)

gsizeOfFunPtr psizeOfFunPtr p =
  T.ufun1 asizeOfFunPtr psizeOfFunPtr p hsizeOfFunPtr

hsizeOfFunPtr z1sizeOfFunPtr ksizeOfFunPtr =
  T.fromInt ksizeOfFunPtr
    (Foreign.Storable.sizeOf ((toFunPtr T.toId) ksizeOfFunPtr z1sizeOfFunPtr))

galignmentFunPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FunPtr a) Int)

galignmentFunPtr palignmentFunPtr p =
  T.ufun1 aalignmentFunPtr palignmentFunPtr p halignmentFunPtr

halignmentFunPtr z1alignmentFunPtr kalignmentFunPtr =
  T.fromInt kalignmentFunPtr
    (Foreign.Storable.alignment
      ((toFunPtr T.toId) kalignmentFunPtr z1alignmentFunPtr))

gpeekElemOffFunPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr (FunPtr a)) (T.Fun Int (IO (FunPtr a))))

gpeekElemOffFunPtr ppeekElemOffFunPtr p =
  T.ufun2 apeekElemOffFunPtr ppeekElemOffFunPtr p hpeekElemOffFunPtr

hpeekElemOffFunPtr z1peekElemOffFunPtr z2peekElemOffFunPtr kpeekElemOffFunPtr =
  (T.fromIO (fromFunPtr T.fromId)) kpeekElemOffFunPtr
    (Foreign.Storable.peekElemOff
      ((toPtr (toFunPtr T.toId)) kpeekElemOffFunPtr z1peekElemOffFunPtr)
      (T.toInt kpeekElemOffFunPtr z2peekElemOffFunPtr))

gpokeElemOffFunPtr ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (Ptr (FunPtr a)) (T.Fun Int (T.Fun (FunPtr a) (IO T.Tuple0))))

gpokeElemOffFunPtr ppokeElemOffFunPtr p =
  T.ufun3 apokeElemOffFunPtr ppokeElemOffFunPtr p hpokeElemOffFunPtr

hpokeElemOffFunPtr z1pokeElemOffFunPtr z2pokeElemOffFunPtr z3pokeElemOffFunPtr
  kpokeElemOffFunPtr =
  (T.fromIO T.fromTuple0) kpokeElemOffFunPtr
    (Foreign.Storable.pokeElemOff
      ((toPtr (toFunPtr T.toId)) kpokeElemOffFunPtr z1pokeElemOffFunPtr)
      (T.toInt kpokeElemOffFunPtr z2pokeElemOffFunPtr)
      ((toFunPtr T.toId) kpokeElemOffFunPtr z3pokeElemOffFunPtr))

gpeekByteOffFunPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO (FunPtr a))))

gpeekByteOffFunPtr ppeekByteOffFunPtr p =
  T.ufun2 apeekByteOffFunPtr ppeekByteOffFunPtr p hpeekByteOffFunPtr

hpeekByteOffFunPtr z1peekByteOffFunPtr z2peekByteOffFunPtr kpeekByteOffFunPtr =
  (T.fromIO (fromFunPtr T.fromId)) kpeekByteOffFunPtr
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffFunPtr z1peekByteOffFunPtr)
      (T.toInt kpeekByteOffFunPtr z2peekByteOffFunPtr))

gpokeByteOffFunPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun (FunPtr a) (IO T.Tuple0))))

gpokeByteOffFunPtr ppokeByteOffFunPtr p =
  T.ufun3 apokeByteOffFunPtr ppokeByteOffFunPtr p hpokeByteOffFunPtr

hpokeByteOffFunPtr z1pokeByteOffFunPtr z2pokeByteOffFunPtr z3pokeByteOffFunPtr
  kpokeByteOffFunPtr =
  (T.fromIO T.fromTuple0) kpokeByteOffFunPtr
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffFunPtr z1pokeByteOffFunPtr)
      (T.toInt kpokeByteOffFunPtr z2pokeByteOffFunPtr)
      ((toFunPtr T.toId) kpokeByteOffFunPtr z3pokeByteOffFunPtr))

gpeekFunPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr (FunPtr a)) (IO (FunPtr a)))

gpeekFunPtr ppeekFunPtr p = T.ufun1 apeekFunPtr ppeekFunPtr p hpeekFunPtr

hpeekFunPtr z1peekFunPtr kpeekFunPtr =
  (T.fromIO (fromFunPtr T.fromId)) kpeekFunPtr
    (Foreign.Storable.peek ((toPtr (toFunPtr T.toId)) kpeekFunPtr z1peekFunPtr))

gpokeFunPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr (FunPtr a)) (T.Fun (FunPtr a) (IO T.Tuple0)))

gpokeFunPtr ppokeFunPtr p = T.ufun2 apokeFunPtr ppokeFunPtr p hpokeFunPtr

hpokeFunPtr z1pokeFunPtr z2pokeFunPtr kpokeFunPtr =
  (T.fromIO T.fromTuple0) kpokeFunPtr
    (Foreign.Storable.poke ((toPtr (toFunPtr T.toId)) kpokeFunPtr z1pokeFunPtr)
      ((toFunPtr T.toId) kpokeFunPtr z2pokeFunPtr))

instance Storable ((FunPtr a))
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a169v5v169v25sizeOf
      (\ p -> gsizeOfFunPtr T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a170v5v170v31alignment
      (\ p -> galignmentFunPtr T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a171v5v171v35peekElemOff
      (\ p -> gpeekElemOffFunPtr T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a172v5v172v35pokeElemOff
      (\ p -> gpokeElemOffFunPtr T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a173v5v173v35peekByteOff
      (\ p -> gpeekByteOffFunPtr T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a174v5v174v35pokeByteOff
      (\ p -> gpokeByteOffFunPtr T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek =
    T.uconstDef T.mkRoot a175v5v175v21peek (\ p -> gpeekFunPtr T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke =
    T.uconstDef T.mkRoot a176v5v176v21poke (\ p -> gpokeFunPtr T.mkNoSrcPos p)
  

gsizeOfStablePtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (StablePtr a) Int)

gsizeOfStablePtr psizeOfStablePtr p =
  T.ufun1 asizeOfStablePtr psizeOfStablePtr p hsizeOfStablePtr

hsizeOfStablePtr z1sizeOfStablePtr ksizeOfStablePtr =
  T.fromInt ksizeOfStablePtr
    (Foreign.Storable.sizeOf
      ((toStablePtr T.toId) ksizeOfStablePtr z1sizeOfStablePtr))

galignmentStablePtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (StablePtr a) Int)

galignmentStablePtr palignmentStablePtr p =
  T.ufun1 aalignmentStablePtr palignmentStablePtr p halignmentStablePtr

halignmentStablePtr z1alignmentStablePtr kalignmentStablePtr =
  T.fromInt kalignmentStablePtr
    (Foreign.Storable.alignment
      ((toStablePtr T.toId) kalignmentStablePtr z1alignmentStablePtr))

gpeekElemOffStablePtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr (StablePtr a)) (T.Fun Int (IO (StablePtr a))))

gpeekElemOffStablePtr ppeekElemOffStablePtr p =
  T.ufun2 apeekElemOffStablePtr ppeekElemOffStablePtr p hpeekElemOffStablePtr

hpeekElemOffStablePtr z1peekElemOffStablePtr z2peekElemOffStablePtr
  kpeekElemOffStablePtr =
  (T.fromIO (fromStablePtr T.fromId)) kpeekElemOffStablePtr
    (Foreign.Storable.peekElemOff
      ((toPtr (toStablePtr T.toId)) kpeekElemOffStablePtr
        z1peekElemOffStablePtr)
      (T.toInt kpeekElemOffStablePtr z2peekElemOffStablePtr))

gpokeElemOffStablePtr ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (Ptr (StablePtr a))
          (T.Fun Int (T.Fun (StablePtr a) (IO T.Tuple0))))

gpokeElemOffStablePtr ppokeElemOffStablePtr p =
  T.ufun3 apokeElemOffStablePtr ppokeElemOffStablePtr p hpokeElemOffStablePtr

hpokeElemOffStablePtr z1pokeElemOffStablePtr z2pokeElemOffStablePtr
  z3pokeElemOffStablePtr kpokeElemOffStablePtr =
  (T.fromIO T.fromTuple0) kpokeElemOffStablePtr
    (Foreign.Storable.pokeElemOff
      ((toPtr (toStablePtr T.toId)) kpokeElemOffStablePtr
        z1pokeElemOffStablePtr)
      (T.toInt kpokeElemOffStablePtr z2pokeElemOffStablePtr)
      ((toStablePtr T.toId) kpokeElemOffStablePtr z3pokeElemOffStablePtr))

gpeekByteOffStablePtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO (StablePtr a))))

gpeekByteOffStablePtr ppeekByteOffStablePtr p =
  T.ufun2 apeekByteOffStablePtr ppeekByteOffStablePtr p hpeekByteOffStablePtr

hpeekByteOffStablePtr z1peekByteOffStablePtr z2peekByteOffStablePtr
  kpeekByteOffStablePtr =
  (T.fromIO (fromStablePtr T.fromId)) kpeekByteOffStablePtr
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffStablePtr z1peekByteOffStablePtr)
      (T.toInt kpeekByteOffStablePtr z2peekByteOffStablePtr))

gpokeByteOffStablePtr ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun (StablePtr a) (IO T.Tuple0))))

gpokeByteOffStablePtr ppokeByteOffStablePtr p =
  T.ufun3 apokeByteOffStablePtr ppokeByteOffStablePtr p hpokeByteOffStablePtr

hpokeByteOffStablePtr z1pokeByteOffStablePtr z2pokeByteOffStablePtr
  z3pokeByteOffStablePtr kpokeByteOffStablePtr =
  (T.fromIO T.fromTuple0) kpokeByteOffStablePtr
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffStablePtr z1pokeByteOffStablePtr)
      (T.toInt kpokeByteOffStablePtr z2pokeByteOffStablePtr)
      ((toStablePtr T.toId) kpokeByteOffStablePtr z3pokeByteOffStablePtr))

gpeekStablePtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr (StablePtr a)) (IO (StablePtr a)))

gpeekStablePtr ppeekStablePtr p =
  T.ufun1 apeekStablePtr ppeekStablePtr p hpeekStablePtr

hpeekStablePtr z1peekStablePtr kpeekStablePtr =
  (T.fromIO (fromStablePtr T.fromId)) kpeekStablePtr
    (Foreign.Storable.peek
      ((toPtr (toStablePtr T.toId)) kpeekStablePtr z1peekStablePtr))

gpokeStablePtr ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (Ptr (StablePtr a)) (T.Fun (StablePtr a) (IO T.Tuple0)))

gpokeStablePtr ppokeStablePtr p =
  T.ufun2 apokeStablePtr ppokeStablePtr p hpokeStablePtr

hpokeStablePtr z1pokeStablePtr z2pokeStablePtr kpokeStablePtr =
  (T.fromIO T.fromTuple0) kpokeStablePtr
    (Foreign.Storable.poke
      ((toPtr (toStablePtr T.toId)) kpokeStablePtr z1pokeStablePtr)
      ((toStablePtr T.toId) kpokeStablePtr z2pokeStablePtr))

instance Storable ((StablePtr a))
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a196v5v196v28sizeOf
      (\ p -> gsizeOfStablePtr T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a197v5v197v34alignment
      (\ p -> galignmentStablePtr T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a198v5v198v38peekElemOff
      (\ p -> gpeekElemOffStablePtr T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a199v5v199v38pokeElemOff
      (\ p -> gpokeElemOffStablePtr T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a200v5v200v38peekByteOff
      (\ p -> gpeekByteOffStablePtr T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a201v5v201v38pokeByteOff
      (\ p -> gpokeByteOffStablePtr T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek =
    T.uconstDef T.mkRoot a202v5v202v24peek
      (\ p -> gpeekStablePtr T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke =
    T.uconstDef T.mkRoot a203v5v203v24poke
      (\ p -> gpokeStablePtr T.mkNoSrcPos p)
  

gsizeOfFloat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Float Int)

gsizeOfFloat psizeOfFloat p = T.ufun1 asizeOfFloat psizeOfFloat p hsizeOfFloat

hsizeOfFloat z1sizeOfFloat ksizeOfFloat =
  T.fromInt ksizeOfFloat
    (Foreign.Storable.sizeOf (T.toFloat ksizeOfFloat z1sizeOfFloat))

galignmentFloat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Float Int)

galignmentFloat palignmentFloat p =
  T.ufun1 aalignmentFloat palignmentFloat p halignmentFloat

halignmentFloat z1alignmentFloat kalignmentFloat =
  T.fromInt kalignmentFloat
    (Foreign.Storable.alignment (T.toFloat kalignmentFloat z1alignmentFloat))

gpeekElemOffFloat ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Float) (T.Fun Int (IO Float)))

gpeekElemOffFloat ppeekElemOffFloat p =
  T.ufun2 apeekElemOffFloat ppeekElemOffFloat p hpeekElemOffFloat

hpeekElemOffFloat z1peekElemOffFloat z2peekElemOffFloat kpeekElemOffFloat =
  (T.fromIO T.fromFloat) kpeekElemOffFloat
    (Foreign.Storable.peekElemOff
      ((toPtr T.toFloat) kpeekElemOffFloat z1peekElemOffFloat)
      (T.toInt kpeekElemOffFloat z2peekElemOffFloat))

gpokeElemOffFloat ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr Float) (T.Fun Int (T.Fun Float (IO T.Tuple0))))

gpokeElemOffFloat ppokeElemOffFloat p =
  T.ufun3 apokeElemOffFloat ppokeElemOffFloat p hpokeElemOffFloat

hpokeElemOffFloat z1pokeElemOffFloat z2pokeElemOffFloat z3pokeElemOffFloat
  kpokeElemOffFloat =
  (T.fromIO T.fromTuple0) kpokeElemOffFloat
    (Foreign.Storable.pokeElemOff
      ((toPtr T.toFloat) kpokeElemOffFloat z1pokeElemOffFloat)
      (T.toInt kpokeElemOffFloat z2pokeElemOffFloat)
      (T.toFloat kpokeElemOffFloat z3pokeElemOffFloat))

gpeekByteOffFloat ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO Float)))

gpeekByteOffFloat ppeekByteOffFloat p =
  T.ufun2 apeekByteOffFloat ppeekByteOffFloat p hpeekByteOffFloat

hpeekByteOffFloat z1peekByteOffFloat z2peekByteOffFloat kpeekByteOffFloat =
  (T.fromIO T.fromFloat) kpeekByteOffFloat
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffFloat z1peekByteOffFloat)
      (T.toInt kpeekByteOffFloat z2peekByteOffFloat))

gpokeByteOffFloat ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun Float (IO T.Tuple0))))

gpokeByteOffFloat ppokeByteOffFloat p =
  T.ufun3 apokeByteOffFloat ppokeByteOffFloat p hpokeByteOffFloat

hpokeByteOffFloat z1pokeByteOffFloat z2pokeByteOffFloat z3pokeByteOffFloat
  kpokeByteOffFloat =
  (T.fromIO T.fromTuple0) kpokeByteOffFloat
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffFloat z1pokeByteOffFloat)
      (T.toInt kpokeByteOffFloat z2pokeByteOffFloat)
      (T.toFloat kpokeByteOffFloat z3pokeByteOffFloat))

gpeekFloat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Float) (IO Float))

gpeekFloat ppeekFloat p = T.ufun1 apeekFloat ppeekFloat p hpeekFloat

hpeekFloat z1peekFloat kpeekFloat =
  (T.fromIO T.fromFloat) kpeekFloat
    (Foreign.Storable.peek ((toPtr T.toFloat) kpeekFloat z1peekFloat))

gpokeFloat ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Float) (T.Fun Float (IO T.Tuple0)))

gpokeFloat ppokeFloat p = T.ufun2 apokeFloat ppokeFloat p hpokeFloat

hpokeFloat z1pokeFloat z2pokeFloat kpokeFloat =
  (T.fromIO T.fromTuple0) kpokeFloat
    (Foreign.Storable.poke ((toPtr T.toFloat) kpokeFloat z1pokeFloat)
      (T.toFloat kpokeFloat z2pokeFloat))

instance Storable (Float)
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a223v5v223v24sizeOf
      (\ p -> gsizeOfFloat T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a224v5v224v30alignment
      (\ p -> galignmentFloat T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a225v5v225v34peekElemOff
      (\ p -> gpeekElemOffFloat T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a226v5v226v34pokeElemOff
      (\ p -> gpokeElemOffFloat T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a227v5v227v34peekByteOff
      (\ p -> gpeekByteOffFloat T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a228v5v228v34pokeByteOff
      (\ p -> gpokeByteOffFloat T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek =
    T.uconstDef T.mkRoot a229v5v229v20peek (\ p -> gpeekFloat T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke =
    T.uconstDef T.mkRoot a230v5v230v20poke (\ p -> gpokeFloat T.mkNoSrcPos p)
  

gsizeOfDouble :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Double Int)

gsizeOfDouble psizeOfDouble p =
  T.ufun1 asizeOfDouble psizeOfDouble p hsizeOfDouble

hsizeOfDouble z1sizeOfDouble ksizeOfDouble =
  T.fromInt ksizeOfDouble
    (Foreign.Storable.sizeOf (T.toDouble ksizeOfDouble z1sizeOfDouble))

galignmentDouble :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Double Int)

galignmentDouble palignmentDouble p =
  T.ufun1 aalignmentDouble palignmentDouble p halignmentDouble

halignmentDouble z1alignmentDouble kalignmentDouble =
  T.fromInt kalignmentDouble
    (Foreign.Storable.alignment (T.toDouble kalignmentDouble z1alignmentDouble))

gpeekElemOffDouble ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Double) (T.Fun Int (IO Double)))

gpeekElemOffDouble ppeekElemOffDouble p =
  T.ufun2 apeekElemOffDouble ppeekElemOffDouble p hpeekElemOffDouble

hpeekElemOffDouble z1peekElemOffDouble z2peekElemOffDouble kpeekElemOffDouble =
  (T.fromIO T.fromDouble) kpeekElemOffDouble
    (Foreign.Storable.peekElemOff
      ((toPtr T.toDouble) kpeekElemOffDouble z1peekElemOffDouble)
      (T.toInt kpeekElemOffDouble z2peekElemOffDouble))

gpokeElemOffDouble ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (Ptr Double) (T.Fun Int (T.Fun Double (IO T.Tuple0))))

gpokeElemOffDouble ppokeElemOffDouble p =
  T.ufun3 apokeElemOffDouble ppokeElemOffDouble p hpokeElemOffDouble

hpokeElemOffDouble z1pokeElemOffDouble z2pokeElemOffDouble z3pokeElemOffDouble
  kpokeElemOffDouble =
  (T.fromIO T.fromTuple0) kpokeElemOffDouble
    (Foreign.Storable.pokeElemOff
      ((toPtr T.toDouble) kpokeElemOffDouble z1pokeElemOffDouble)
      (T.toInt kpokeElemOffDouble z2pokeElemOffDouble)
      (T.toDouble kpokeElemOffDouble z3pokeElemOffDouble))

gpeekByteOffDouble ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (IO Double)))

gpeekByteOffDouble ppeekByteOffDouble p =
  T.ufun2 apeekByteOffDouble ppeekByteOffDouble p hpeekByteOffDouble

hpeekByteOffDouble z1peekByteOffDouble z2peekByteOffDouble kpeekByteOffDouble =
  (T.fromIO T.fromDouble) kpeekByteOffDouble
    (Foreign.Storable.peekByteOff
      ((toPtr T.toId) kpeekByteOffDouble z1peekByteOffDouble)
      (T.toInt kpeekByteOffDouble z2peekByteOffDouble))

gpokeByteOffDouble ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr b) (T.Fun Int (T.Fun Double (IO T.Tuple0))))

gpokeByteOffDouble ppokeByteOffDouble p =
  T.ufun3 apokeByteOffDouble ppokeByteOffDouble p hpokeByteOffDouble

hpokeByteOffDouble z1pokeByteOffDouble z2pokeByteOffDouble z3pokeByteOffDouble
  kpokeByteOffDouble =
  (T.fromIO T.fromTuple0) kpokeByteOffDouble
    (Foreign.Storable.pokeByteOff
      ((toPtr T.toId) kpokeByteOffDouble z1pokeByteOffDouble)
      (T.toInt kpokeByteOffDouble z2pokeByteOffDouble)
      (T.toDouble kpokeByteOffDouble z3pokeByteOffDouble))

gpeekDouble :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr Double) (IO Double))

gpeekDouble ppeekDouble p = T.ufun1 apeekDouble ppeekDouble p hpeekDouble

hpeekDouble z1peekDouble kpeekDouble =
  (T.fromIO T.fromDouble) kpeekDouble
    (Foreign.Storable.peek ((toPtr T.toDouble) kpeekDouble z1peekDouble))

gpokeDouble ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr Double) (T.Fun Double (IO T.Tuple0)))

gpokeDouble ppokeDouble p = T.ufun2 apokeDouble ppokeDouble p hpokeDouble

hpokeDouble z1pokeDouble z2pokeDouble kpokeDouble =
  (T.fromIO T.fromTuple0) kpokeDouble
    (Foreign.Storable.poke ((toPtr T.toDouble) kpokeDouble z1pokeDouble)
      (T.toDouble kpokeDouble z2pokeDouble))

instance Storable (Double)
  where
  
  gsizeOf psizeOf p = T.uconstUse psizeOf p ssizeOf
  
  ssizeOf =
    T.uconstDef T.mkRoot a250v5v250v25sizeOf
      (\ p -> gsizeOfDouble T.mkNoSrcPos p)
  
  galignment palignment p = T.uconstUse palignment p salignment
  
  salignment =
    T.uconstDef T.mkRoot a251v5v251v31alignment
      (\ p -> galignmentDouble T.mkNoSrcPos p)
  
  gpeekElemOff ppeekElemOff p = T.uconstUse ppeekElemOff p speekElemOff
  
  speekElemOff =
    T.uconstDef T.mkRoot a252v5v252v35peekElemOff
      (\ p -> gpeekElemOffDouble T.mkNoSrcPos p)
  
  gpokeElemOff ppokeElemOff p = T.uconstUse ppokeElemOff p spokeElemOff
  
  spokeElemOff =
    T.uconstDef T.mkRoot a253v5v253v35pokeElemOff
      (\ p -> gpokeElemOffDouble T.mkNoSrcPos p)
  
  gpeekByteOff ppeekByteOff p = T.uconstUse ppeekByteOff p speekByteOff
  
  speekByteOff =
    T.uconstDef T.mkRoot a254v5v254v35peekByteOff
      (\ p -> gpeekByteOffDouble T.mkNoSrcPos p)
  
  gpokeByteOff ppokeByteOff p = T.uconstUse ppokeByteOff p spokeByteOff
  
  spokeByteOff =
    T.uconstDef T.mkRoot a255v5v255v35pokeByteOff
      (\ p -> gpokeByteOffDouble T.mkNoSrcPos p)
  
  gpeek ppeek p = T.uconstUse ppeek p speek
  
  speek =
    T.uconstDef T.mkRoot a256v5v256v21peek (\ p -> gpeekDouble T.mkNoSrcPos p)
  
  gpoke ppoke p = T.uconstUse ppoke p spoke
  
  spoke =
    T.uconstDef T.mkRoot a257v5v257v21poke (\ p -> gpokeDouble T.mkNoSrcPos p)
  

tForeign_Storable =
  T.mkModule "Foreign.Storable" "Foreign/Storable.hs" Prelude.False

asizeOfBool =
  T.mkVariable tForeign_Storable 430001 440027 3 1 "sizeOfBool" Prelude.False

aalignmentBool =
  T.mkVariable tForeign_Storable 450001 460030 3 1 "alignmentBool" Prelude.False

apeekElemOffBool =
  T.mkVariable tForeign_Storable 470001 480042 3 2 "peekElemOffBool"
    Prelude.False

apokeElemOffBool =
  T.mkVariable tForeign_Storable 490001 500050 3 3 "pokeElemOffBool"
    Prelude.False

apeekByteOffBool =
  T.mkVariable tForeign_Storable 510001 520039 3 2 "peekByteOffBool"
    Prelude.False

apokeByteOffBool =
  T.mkVariable tForeign_Storable 530001 540047 3 3 "pokeByteOffBool"
    Prelude.False

apeekBool =
  T.mkVariable tForeign_Storable 550001 560028 3 1 "peekBool" Prelude.False

apokeBool =
  T.mkVariable tForeign_Storable 570001 580036 3 2 "pokeBool" Prelude.False

asizeOfChar =
  T.mkVariable tForeign_Storable 700001 710027 3 1 "sizeOfChar" Prelude.False

aalignmentChar =
  T.mkVariable tForeign_Storable 720001 730030 3 1 "alignmentChar" Prelude.False

apeekElemOffChar =
  T.mkVariable tForeign_Storable 740001 750042 3 2 "peekElemOffChar"
    Prelude.False

apokeElemOffChar =
  T.mkVariable tForeign_Storable 760001 770050 3 3 "pokeElemOffChar"
    Prelude.False

apeekByteOffChar =
  T.mkVariable tForeign_Storable 780001 790039 3 2 "peekByteOffChar"
    Prelude.False

apokeByteOffChar =
  T.mkVariable tForeign_Storable 800001 810047 3 3 "pokeByteOffChar"
    Prelude.False

apeekChar =
  T.mkVariable tForeign_Storable 820001 830028 3 1 "peekChar" Prelude.False

apokeChar =
  T.mkVariable tForeign_Storable 840001 850036 3 2 "pokeChar" Prelude.False

asizeOfInt =
  T.mkVariable tForeign_Storable 970001 980025 3 1 "sizeOfInt" Prelude.False

aalignmentInt =
  T.mkVariable tForeign_Storable 990001 1000028 3 1 "alignmentInt" Prelude.False

apeekElemOffInt =
  T.mkVariable tForeign_Storable 1010001 1020040 3 2 "peekElemOffInt"
    Prelude.False

apokeElemOffInt =
  T.mkVariable tForeign_Storable 1030001 1040047 3 3 "pokeElemOffInt"
    Prelude.False

apeekByteOffInt =
  T.mkVariable tForeign_Storable 1050001 1060038 3 2 "peekByteOffInt"
    Prelude.False

apokeByteOffInt =
  T.mkVariable tForeign_Storable 1070001 1080045 3 3 "pokeByteOffInt"
    Prelude.False

apeekInt =
  T.mkVariable tForeign_Storable 1090001 1100026 3 1 "peekInt" Prelude.False

apokeInt =
  T.mkVariable tForeign_Storable 1110001 1120033 3 2 "pokeInt" Prelude.False

asizeOfPtr =
  T.mkVariable tForeign_Storable 1240001 1250027 3 1 "sizeOfPtr" Prelude.False

aalignmentPtr =
  T.mkVariable tForeign_Storable 1260001 1270030 3 1 "alignmentPtr"
    Prelude.False

apeekElemOffPtr =
  T.mkVariable tForeign_Storable 1280001 1290044 3 2 "peekElemOffPtr"
    Prelude.False

apokeElemOffPtr =
  T.mkVariable tForeign_Storable 1300001 1310055 3 3 "pokeElemOffPtr"
    Prelude.False

apeekByteOffPtr =
  T.mkVariable tForeign_Storable 1320001 1330038 3 2 "peekByteOffPtr"
    Prelude.False

apokeByteOffPtr =
  T.mkVariable tForeign_Storable 1340001 1350049 3 3 "pokeByteOffPtr"
    Prelude.False

apeekPtr =
  T.mkVariable tForeign_Storable 1360001 1370030 3 1 "peekPtr" Prelude.False

apokePtr =
  T.mkVariable tForeign_Storable 1380001 1390041 3 2 "pokePtr" Prelude.False

asizeOfFunPtr =
  T.mkVariable tForeign_Storable 1510001 1520033 3 1 "sizeOfFunPtr"
    Prelude.False

aalignmentFunPtr =
  T.mkVariable tForeign_Storable 1530001 1540036 3 1 "alignmentFunPtr"
    Prelude.False

apeekElemOffFunPtr =
  T.mkVariable tForeign_Storable 1550001 1560050 3 2 "peekElemOffFunPtr"
    Prelude.False

apokeElemOffFunPtr =
  T.mkVariable tForeign_Storable 1570001 1580064 3 3 "pokeElemOffFunPtr"
    Prelude.False

apeekByteOffFunPtr =
  T.mkVariable tForeign_Storable 1590001 1600041 3 2 "peekByteOffFunPtr"
    Prelude.False

apokeByteOffFunPtr =
  T.mkVariable tForeign_Storable 1610001 1620055 3 3 "pokeByteOffFunPtr"
    Prelude.False

apeekFunPtr =
  T.mkVariable tForeign_Storable 1630001 1640036 3 1 "peekFunPtr" Prelude.False

apokeFunPtr =
  T.mkVariable tForeign_Storable 1650001 1660050 3 2 "pokeFunPtr" Prelude.False

asizeOfStablePtr =
  T.mkVariable tForeign_Storable 1780001 1790039 3 1 "sizeOfStablePtr"
    Prelude.False

aalignmentStablePtr =
  T.mkVariable tForeign_Storable 1800001 1810042 3 1 "alignmentStablePtr"
    Prelude.False

apeekElemOffStablePtr =
  T.mkVariable tForeign_Storable 1820001 1830056 3 2 "peekElemOffStablePtr"
    Prelude.False

apokeElemOffStablePtr =
  T.mkVariable tForeign_Storable 1840001 1850073 3 3 "pokeElemOffStablePtr"
    Prelude.False

apeekByteOffStablePtr =
  T.mkVariable tForeign_Storable 1860001 1870044 3 2 "peekByteOffStablePtr"
    Prelude.False

apokeByteOffStablePtr =
  T.mkVariable tForeign_Storable 1880001 1890061 3 3 "pokeByteOffStablePtr"
    Prelude.False

apeekStablePtr =
  T.mkVariable tForeign_Storable 1900001 1910042 3 1 "peekStablePtr"
    Prelude.False

apokeStablePtr =
  T.mkVariable tForeign_Storable 1920001 1930059 3 2 "pokeStablePtr"
    Prelude.False

asizeOfFloat =
  T.mkVariable tForeign_Storable 2050001 2060029 3 1 "sizeOfFloat" Prelude.False

aalignmentFloat =
  T.mkVariable tForeign_Storable 2070001 2080032 3 1 "alignmentFloat"
    Prelude.False

apeekElemOffFloat =
  T.mkVariable tForeign_Storable 2090001 2100044 3 2 "peekElemOffFloat"
    Prelude.False

apokeElemOffFloat =
  T.mkVariable tForeign_Storable 2110001 2120053 3 3 "pokeElemOffFloat"
    Prelude.False

apeekByteOffFloat =
  T.mkVariable tForeign_Storable 2130001 2140040 3 2 "peekByteOffFloat"
    Prelude.False

apokeByteOffFloat =
  T.mkVariable tForeign_Storable 2150001 2160049 3 3 "pokeByteOffFloat"
    Prelude.False

apeekFloat =
  T.mkVariable tForeign_Storable 2170001 2180030 3 1 "peekFloat" Prelude.False

apokeFloat =
  T.mkVariable tForeign_Storable 2190001 2200039 3 2 "pokeFloat" Prelude.False

asizeOfDouble =
  T.mkVariable tForeign_Storable 2320001 2330031 3 1 "sizeOfDouble"
    Prelude.False

aalignmentDouble =
  T.mkVariable tForeign_Storable 2340001 2350034 3 1 "alignmentDouble"
    Prelude.False

apeekElemOffDouble =
  T.mkVariable tForeign_Storable 2360001 2370046 3 2 "peekElemOffDouble"
    Prelude.False

apokeElemOffDouble =
  T.mkVariable tForeign_Storable 2380001 2390056 3 3 "pokeElemOffDouble"
    Prelude.False

apeekByteOffDouble =
  T.mkVariable tForeign_Storable 2400001 2410041 3 2 "peekByteOffDouble"
    Prelude.False

apokeByteOffDouble =
  T.mkVariable tForeign_Storable 2420001 2430051 3 3 "pokeByteOffDouble"
    Prelude.False

apeekDouble =
  T.mkVariable tForeign_Storable 2440001 2450032 3 1 "peekDouble" Prelude.False

apokeDouble =
  T.mkVariable tForeign_Storable 2460001 2470042 3 2 "pokeDouble" Prelude.False

a30v5v32v37peekElemOff =
  T.mkVariable tForeign_Storable 300005 320037 3 2 "peekElemOff" Prelude.False

a33v5v33v68pokeElemOff =
  T.mkVariable tForeign_Storable 330005 330068 3 3 "pokeElemOff" Prelude.False

a35v5v35v49peekByteOff =
  T.mkVariable tForeign_Storable 350005 350049 3 2 "peekByteOff" Prelude.False

a36v5v36v49pokeByteOff =
  T.mkVariable tForeign_Storable 360005 360049 3 2 "pokeByteOff" Prelude.False

a38v5v38v32peek =
  T.mkVariable tForeign_Storable 380005 380032 3 1 "peek" Prelude.False

a39v5v39v32poke =
  T.mkVariable tForeign_Storable 390005 390032 3 1 "poke" Prelude.False

a61v5v61v23sizeOf =
  T.mkVariable tForeign_Storable 610005 610023 3 0 "sizeOf" Prelude.False

a62v5v62v29alignment =
  T.mkVariable tForeign_Storable 620005 620029 3 0 "alignment" Prelude.False

a63v5v63v33peekElemOff =
  T.mkVariable tForeign_Storable 630005 630033 3 0 "peekElemOff" Prelude.False

a64v5v64v33pokeElemOff =
  T.mkVariable tForeign_Storable 640005 640033 3 0 "pokeElemOff" Prelude.False

a65v5v65v33peekByteOff =
  T.mkVariable tForeign_Storable 650005 650033 3 0 "peekByteOff" Prelude.False

a66v5v66v33pokeByteOff =
  T.mkVariable tForeign_Storable 660005 660033 3 0 "pokeByteOff" Prelude.False

a67v5v67v19peek =
  T.mkVariable tForeign_Storable 670005 670019 3 0 "peek" Prelude.False

a68v5v68v19poke =
  T.mkVariable tForeign_Storable 680005 680019 3 0 "poke" Prelude.False

a88v5v88v23sizeOf =
  T.mkVariable tForeign_Storable 880005 880023 3 0 "sizeOf" Prelude.False

a89v5v89v29alignment =
  T.mkVariable tForeign_Storable 890005 890029 3 0 "alignment" Prelude.False

a90v5v90v33peekElemOff =
  T.mkVariable tForeign_Storable 900005 900033 3 0 "peekElemOff" Prelude.False

a91v5v91v33pokeElemOff =
  T.mkVariable tForeign_Storable 910005 910033 3 0 "pokeElemOff" Prelude.False

a92v5v92v33peekByteOff =
  T.mkVariable tForeign_Storable 920005 920033 3 0 "peekByteOff" Prelude.False

a93v5v93v33pokeByteOff =
  T.mkVariable tForeign_Storable 930005 930033 3 0 "pokeByteOff" Prelude.False

a94v5v94v19peek =
  T.mkVariable tForeign_Storable 940005 940019 3 0 "peek" Prelude.False

a95v5v95v19poke =
  T.mkVariable tForeign_Storable 950005 950019 3 0 "poke" Prelude.False

a115v5v115v22sizeOf =
  T.mkVariable tForeign_Storable 1150005 1150022 3 0 "sizeOf" Prelude.False

a116v5v116v28alignment =
  T.mkVariable tForeign_Storable 1160005 1160028 3 0 "alignment" Prelude.False

a117v5v117v32peekElemOff =
  T.mkVariable tForeign_Storable 1170005 1170032 3 0 "peekElemOff" Prelude.False

a118v5v118v32pokeElemOff =
  T.mkVariable tForeign_Storable 1180005 1180032 3 0 "pokeElemOff" Prelude.False

a119v5v119v32peekByteOff =
  T.mkVariable tForeign_Storable 1190005 1190032 3 0 "peekByteOff" Prelude.False

a120v5v120v32pokeByteOff =
  T.mkVariable tForeign_Storable 1200005 1200032 3 0 "pokeByteOff" Prelude.False

a121v5v121v18peek =
  T.mkVariable tForeign_Storable 1210005 1210018 3 0 "peek" Prelude.False

a122v5v122v18poke =
  T.mkVariable tForeign_Storable 1220005 1220018 3 0 "poke" Prelude.False

a142v5v142v22sizeOf =
  T.mkVariable tForeign_Storable 1420005 1420022 3 0 "sizeOf" Prelude.False

a143v5v143v28alignment =
  T.mkVariable tForeign_Storable 1430005 1430028 3 0 "alignment" Prelude.False

a144v5v144v32peekElemOff =
  T.mkVariable tForeign_Storable 1440005 1440032 3 0 "peekElemOff" Prelude.False

a145v5v145v32pokeElemOff =
  T.mkVariable tForeign_Storable 1450005 1450032 3 0 "pokeElemOff" Prelude.False

a146v5v146v32peekByteOff =
  T.mkVariable tForeign_Storable 1460005 1460032 3 0 "peekByteOff" Prelude.False

a147v5v147v32pokeByteOff =
  T.mkVariable tForeign_Storable 1470005 1470032 3 0 "pokeByteOff" Prelude.False

a148v5v148v18peek =
  T.mkVariable tForeign_Storable 1480005 1480018 3 0 "peek" Prelude.False

a149v5v149v18poke =
  T.mkVariable tForeign_Storable 1490005 1490018 3 0 "poke" Prelude.False

a169v5v169v25sizeOf =
  T.mkVariable tForeign_Storable 1690005 1690025 3 0 "sizeOf" Prelude.False

a170v5v170v31alignment =
  T.mkVariable tForeign_Storable 1700005 1700031 3 0 "alignment" Prelude.False

a171v5v171v35peekElemOff =
  T.mkVariable tForeign_Storable 1710005 1710035 3 0 "peekElemOff" Prelude.False

a172v5v172v35pokeElemOff =
  T.mkVariable tForeign_Storable 1720005 1720035 3 0 "pokeElemOff" Prelude.False

a173v5v173v35peekByteOff =
  T.mkVariable tForeign_Storable 1730005 1730035 3 0 "peekByteOff" Prelude.False

a174v5v174v35pokeByteOff =
  T.mkVariable tForeign_Storable 1740005 1740035 3 0 "pokeByteOff" Prelude.False

a175v5v175v21peek =
  T.mkVariable tForeign_Storable 1750005 1750021 3 0 "peek" Prelude.False

a176v5v176v21poke =
  T.mkVariable tForeign_Storable 1760005 1760021 3 0 "poke" Prelude.False

a196v5v196v28sizeOf =
  T.mkVariable tForeign_Storable 1960005 1960028 3 0 "sizeOf" Prelude.False

a197v5v197v34alignment =
  T.mkVariable tForeign_Storable 1970005 1970034 3 0 "alignment" Prelude.False

a198v5v198v38peekElemOff =
  T.mkVariable tForeign_Storable 1980005 1980038 3 0 "peekElemOff" Prelude.False

a199v5v199v38pokeElemOff =
  T.mkVariable tForeign_Storable 1990005 1990038 3 0 "pokeElemOff" Prelude.False

a200v5v200v38peekByteOff =
  T.mkVariable tForeign_Storable 2000005 2000038 3 0 "peekByteOff" Prelude.False

a201v5v201v38pokeByteOff =
  T.mkVariable tForeign_Storable 2010005 2010038 3 0 "pokeByteOff" Prelude.False

a202v5v202v24peek =
  T.mkVariable tForeign_Storable 2020005 2020024 3 0 "peek" Prelude.False

a203v5v203v24poke =
  T.mkVariable tForeign_Storable 2030005 2030024 3 0 "poke" Prelude.False

a223v5v223v24sizeOf =
  T.mkVariable tForeign_Storable 2230005 2230024 3 0 "sizeOf" Prelude.False

a224v5v224v30alignment =
  T.mkVariable tForeign_Storable 2240005 2240030 3 0 "alignment" Prelude.False

a225v5v225v34peekElemOff =
  T.mkVariable tForeign_Storable 2250005 2250034 3 0 "peekElemOff" Prelude.False

a226v5v226v34pokeElemOff =
  T.mkVariable tForeign_Storable 2260005 2260034 3 0 "pokeElemOff" Prelude.False

a227v5v227v34peekByteOff =
  T.mkVariable tForeign_Storable 2270005 2270034 3 0 "peekByteOff" Prelude.False

a228v5v228v34pokeByteOff =
  T.mkVariable tForeign_Storable 2280005 2280034 3 0 "pokeByteOff" Prelude.False

a229v5v229v20peek =
  T.mkVariable tForeign_Storable 2290005 2290020 3 0 "peek" Prelude.False

a230v5v230v20poke =
  T.mkVariable tForeign_Storable 2300005 2300020 3 0 "poke" Prelude.False

a250v5v250v25sizeOf =
  T.mkVariable tForeign_Storable 2500005 2500025 3 0 "sizeOf" Prelude.False

a251v5v251v31alignment =
  T.mkVariable tForeign_Storable 2510005 2510031 3 0 "alignment" Prelude.False

a252v5v252v35peekElemOff =
  T.mkVariable tForeign_Storable 2520005 2520035 3 0 "peekElemOff" Prelude.False

a253v5v253v35pokeElemOff =
  T.mkVariable tForeign_Storable 2530005 2530035 3 0 "pokeElemOff" Prelude.False

a254v5v254v35peekByteOff =
  T.mkVariable tForeign_Storable 2540005 2540035 3 0 "peekByteOff" Prelude.False

a255v5v255v35pokeByteOff =
  T.mkVariable tForeign_Storable 2550005 2550035 3 0 "pokeByteOff" Prelude.False

a256v5v256v21peek =
  T.mkVariable tForeign_Storable 2560005 2560021 3 0 "peek" Prelude.False

a257v5v257v21poke =
  T.mkVariable tForeign_Storable 2570005 2570021 3 0 "poke" Prelude.False

a32v15v32v37sizeOfP =
  T.mkVariable tForeign_Storable 320015 320037 3 2 "sizeOfP" Prelude.True
