/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: cladvsnk.cpp,v 1.3.24.1 2004/07/09 01:54:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "hxcore.h"
#include "hxclsnk.h"
// pxcomlib
#include "cladvsnk.h"

PXClientAdviseSink::PXClientAdviseSink()
{
    m_lRefCount = 0;
    m_pPlayer   = NULL;
    m_pResponse = NULL;
}

PXClientAdviseSink::~PXClientAdviseSink()
{
    Close();
}

STDMETHODIMP PXClientAdviseSink::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        if (IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = (IUnknown*) (IHXClientAdviseSink*) this;
        }
        else if (IsEqualIID(riid, IID_IHXClientAdviseSink))
        {
            AddRef();
            *ppvObj = (IHXClientAdviseSink*) this;
        }
        else
        {
            retVal = HXR_NOINTERFACE;
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

STDMETHODIMP_(ULONG32) PXClientAdviseSink::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG32) PXClientAdviseSink::Release()
{
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;

    return 0;
}

STDMETHODIMP PXClientAdviseSink::Init(IHXPlayer*                 pPlayer,
                                      PXClientAdviseSinkResponse* pResponse)
{
    HX_RESULT retVal = HXR_OK;

    if (pPlayer && pResponse)
    {
        // Save the IHXPlayer
        HX_RELEASE(m_pPlayer);
        m_pPlayer = pPlayer;
        m_pPlayer->AddRef();
        // Save the response interface
        if (m_pResponse)
        {
            m_pResponse->Release();
            m_pResponse = NULL;
        }
        m_pResponse = pResponse;
        m_pResponse->AddRef();
        // Add ourselves as a client advise sink
        if (m_pPlayer)
        {
            // Get our own IHXClientAdviseSink interface
            IHXClientAdviseSink* pSink = NULL;
            QueryInterface(IID_IHXClientAdviseSink, (void**) &pSink);
            if (pSink)
            {
                retVal = m_pPlayer->AddAdviseSink(pSink);
            }
            HX_RELEASE(pSink);
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::Close()
{
    HX_RESULT retVal = HXR_OK;

    // Remove ourselves as an advise sink
    if (m_pPlayer)
    {
        // Get our own IHXClientAdviseSink interface
        IHXClientAdviseSink* pSink = NULL;
        QueryInterface(IID_IHXClientAdviseSink, (void**) &pSink);
        if (pSink)
        {
            retVal = m_pPlayer->RemoveAdviseSink(pSink);
        }
        HX_RELEASE(pSink);
    }
    // Release our refs on the player and the response interfaces
    HX_RELEASE(m_pPlayer);
    if (m_pResponse)
    {
        m_pResponse->Release();
        m_pResponse = NULL;
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnPosLength(UINT32 ulPosition, UINT32 ulLength)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnPosLength(ulPosition, ulLength);
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnPresentationOpened()
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnPresentationOpened();
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnPresentationClosed()
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnPresentationClosed();
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnStatisticsChanged()
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnStatisticsChanged();
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnPreSeek(ULONG32 ulOldTime, ULONG32 ulNewTime)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnPreSeek(ulOldTime, ulNewTime);
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnPostSeek(ULONG32 ulOldTime, ULONG32 ulNewTime)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnPostSeek(ulOldTime, ulNewTime);
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnStop()
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnStop();
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnPause(ULONG32 ulTime)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnPause(ulTime);
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnBegin(ULONG32 ulTime)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnBegin(ulTime);
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnBuffering(ULONG32 ulFlags, UINT16 unPercentComplete)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnBuffering(ulFlags, unPercentComplete);
    }

    return retVal;
}

STDMETHODIMP PXClientAdviseSink::OnContacting(const char* pHostName)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pResponse)
    {
        retVal = m_pResponse->CASOnContacting(pHostName);
    }

    return retVal;
}
