/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: group_info.h,v 1.1.4.1 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef GROUP_INFO_H
#define GROUP_INFO_H

#include "ogg/ogg.h"

#include "hxresult.h"

#include "ogg_timestamp.h"
#include "chxmaplongtoobj.h"

class COggCodecInfo;

class COggGroupInfo
{
public:
    COggGroupInfo(ULONG32 ulStartPageOffset,
                  UINT32 uStartPageSize,
                  ULONG32 ulEndPageOffset,
                  const COggTimestamp& duration);
    ~COggGroupInfo();

    HX_RESULT GetStartPageOffset(ULONG32& ulStartPageOffset) const;
    HX_RESULT GetPageOffsetInfo(ULONG32& ulStartPageOffset, 
                                UINT32& ulStartPageSize,
                                ULONG32& ulEndPageOffset) const;

    HX_RESULT GetStartTime(COggTimestamp& startTime) const;
    HX_RESULT GetDuration(COggTimestamp& duration) const;
    HX_RESULT GetTimestamp(int serialNum, ogg_int64_t granulepos,
                           COggTimestamp& timestamp) const;


    UINT32 StreamCount() const;
    HX_RESULT GetStreamSerialNum(UINT32 uStreamIndex, int& serialNum) const;
    HX_RESULT GetCodecInfo(int serialNum, 
                           const COggCodecInfo*& pCodecInfo) const;

    void SetStartTime(const COggTimestamp& startTime);
    HX_RESULT AddCodecInfo(int serialNum, const COggCodecInfo* pCodecInfo);

private:
    ULONG32 m_ulStartPageOffset;
    UINT32  m_uStartPageSize;
    ULONG32 m_ulEndPageOffset;
    COggTimestamp m_duration;
    COggTimestamp m_startTime;

    int* m_pSerialNums;
    CHXMapLongToObj m_codecInfoMap;
};

#endif /* GROUP_INFO_H */
