/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: brushrnd.h,v 1.5.2.1 2004/07/09 01:57:49 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef BRUSHRND_H
#define BRUSHRND_H

#include "baseobj.h"

// Forward declarations
typedef _INTERFACE IHXValues       IHXValues;
typedef _INTERFACE IHXPacket       IHXPacket;
typedef _INTERFACE IHXBuffer       IHXBuffer;
typedef _INTERFACE IHXVideoSurface IHXVideoSurface;
typedef struct _HXBitmapInfoHeader HXBitmapInfoHeader;

class CBrushRenderer : public CRNVisualBaseRenderer
{
public:
    CBrushRenderer();
    virtual ~CBrushRenderer();

    // IUnknown Methods
    STDMETHOD (QueryInterface)  (THIS_ REFIID ID, void** ppObj);
    STDMETHOD_(UINT32, AddRef)  (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

    // Methods required for CRNBaseRenderer
    STDMETHOD(OnHeader)         (THIS_ IHXValues* pHeader);
    STDMETHOD(OnPacketNoOffset) (THIS_ IHXPacket* pPacket);
    STDMETHOD(OnTimeSyncOffset) (THIS_ UINT32 ulTime);
    STDMETHOD(GetDisplayType)   (THIS_ REF(HX_DISPLAY_TYPE) rulFlags,
                                       REF(IHXBuffer*)      pBuffer);

    // Methods required for CRNVisualBaseRenderer
    STDMETHOD(GetWindowSize)         (THIS_ REF(HXxSize) rSize);
    STDMETHOD(IsMouseOverActiveLink) (THIS_ INT16 x, INT16 y, REF(BOOL) rbActive, REF(IHXBuffer*) rpLink);
    STDMETHOD(RMASurfaceUpdate)      (THIS_ IHXVideoSurface* pSurface);
    STDMETHOD(HandleClick)           (THIS_ INT16 x, INT16 y);

    // IHXValues methods - overridden from CRNBaseRenderer
    STDMETHOD(SetPropertyULONG32) (THIS_ const char* pName, ULONG32 ulVal);

    // CBrushFileFormat methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
    static HX_RESULT STDAPICALLTYPE CanUnload2();
protected:
    UINT32              m_ulColor;
    HXBitmapInfoHeader* m_pHeader;
    UINT32              m_ulChromaKey;
    UINT32              m_ulChromaKeyTolerance;
    UINT32              m_ulChromaKeyOpacity;
    UINT32              m_ulLastColor;
    BYTE*               m_pucBuffer;
    HX_BITFIELD         m_bFirstDraw : 1;
    HX_BITFIELD         m_bChromaKeySpecified : 1;
    HX_BITFIELD         m_bNullBrush : 1;

    STDMETHOD(GetName)                       (THIS_ REF(const char*) rpszName);
    STDMETHOD(GetDescription)                (THIS_ REF(const char*) rpszDescription);
    STDMETHOD(GetMimeTypes)                  (THIS_ REF(const char**) rppszMimeType);
    STDMETHOD_(UINT32,GetPluginVersion)      (THIS);
    STDMETHOD_(UINT32,GetInitialGranularity) (THIS);

    static const char* const m_pszName;
    static const char* const m_pszDescription;
    static const char* const m_ppszMimeType[];

    virtual HX_RESULT RMASurfaceUpdate2(IHXSubRectVideoSurface* pSurface,
                                        HXxRect*                 pExtens,
                                        HXxBoxRegion*              pDirtyRegion);
    virtual void      _AttachSite();
    HX_RESULT         SetupBuffer();
};

#endif

